	.include	'eq.s'
	.include	'externs.s'

	.bss

;OBJECT HEADERS
gameobjs::
bkground::		ds.b	OBJ_SIZE		;background buffer
statn::			ds.b	OBJ_SIZE		;station
statnflg::		ds.b	OBJ_SIZE		;flag for station
enemy0::			ds.b	OBJ_SIZE		;enemies
enemy1::			ds.b	OBJ_SIZE
enemy2::			ds.b	OBJ_SIZE
enemy3::			ds.b	OBJ_SIZE
enemy4::			ds.b	OBJ_SIZE
enemy5::			ds.b	OBJ_SIZE
enemy6::			ds.b	OBJ_SIZE
enemy7::			ds.b	OBJ_SIZE
enemy8::			ds.b	OBJ_SIZE
enemy9::			ds.b	OBJ_SIZE
powerup::			ds.b	OBJ_SIZE		;powerup
cutter::			ds.b	OBJ_SIZE		;cutter ship
cutshot0::		ds.b	OBJ_SIZE		;cutter shots
cutshot1::		ds.b	OBJ_SIZE
cutshot2::		ds.b	OBJ_SIZE
cutshot3::		ds.b	OBJ_SIZE
player::			ds.b	OBJ_SIZE		;player object
bullet0::			ds.b	OBJ_SIZE		;player bullets
bullet1::			ds.b	OBJ_SIZE
bullet2::			ds.b	OBJ_SIZE
bullet3::			ds.b	OBJ_SIZE
bullet4::			ds.b	OBJ_SIZE
bullet5::			ds.b	OBJ_SIZE
bullet6::			ds.b	OBJ_SIZE
bullet7::			ds.b	OBJ_SIZE
en_shot0::		ds.b	OBJ_SIZE		;enemy shots
en_shot1::		ds.b	OBJ_SIZE
en_shot2::		ds.b	OBJ_SIZE
en_shot3::		ds.b	OBJ_SIZE
en_shot4::		ds.b	OBJ_SIZE
en_shot5::		ds.b	OBJ_SIZE
en_shot6::		ds.b	OBJ_SIZE
en_shot7::		ds.b	OBJ_SIZE
bomb::			ds.b	OBJ_SIZE		;player bomb
specweap::		ds.b	OBJ_SIZE		;special weapon
front0::			ds.b	OBJ_SIZE		;foreground objects
front1::			ds.b	OBJ_SIZE
front2::			ds.b	OBJ_SIZE
front3::			ds.b	OBJ_SIZE
front4::			ds.b	OBJ_SIZE
front5::			ds.b	OBJ_SIZE
front6::			ds.b	OBJ_SIZE
front7::			ds.b	OBJ_SIZE
front8::			ds.b	OBJ_SIZE
front9::			ds.b	OBJ_SIZE
iconbox::			ds.b	OBJ_SIZE		;icons
scorebox::		ds.b	OBJ_SIZE		;score numbers
specflsh::		ds.b	OBJ_SIZE		;special weapon flash
message::			ds.b	OBJ_SIZE		;paused, game over, continue

scrcover::		ds.b	OBJ_SIZE		;screen cover

;Title screen
titlobjs::
t_scr::			ds.b	OBJ_SIZE			;title screen background
t_cg::			ds.b	OBJ_SIZE			;CG logo
t_cr::			ds.b	OBJ_SIZE			;CR logo
t_ship::			ds.b	OBJ_SIZE			;ship

selobjs::
selbackg::		ds.b	OBJ_SIZE			;background
planet1::			ds.b	OBJ_SIZE			;planet over background
planet2::			ds.b	OBJ_SIZE			;planet over background
planet3::			ds.b	OBJ_SIZE			;planet over background
planet4::			ds.b	OBJ_SIZE			;planet over background
planet5::			ds.b	OBJ_SIZE			;planet over background
planet6::			ds.b	OBJ_SIZE			;bonus planet
dashobj::			ds.b	OBJ_SIZE			;dashboard
selicons::		ds.b	OBJ_SIZE			;icon bar
selscore::		ds.b	OBJ_SIZE			;score numbers
cursor::			ds.b	OBJ_SIZE			;cursor

congobjs::
congscr::			ds.b	OBJ_SIZE			;congratulations screen
congln0::			ds.b	OBJ_SIZE			;text line 0
congln1::			ds.b	OBJ_SIZE			;text line 1
congln2::			ds.b	OBJ_SIZE			;text line 2
congln3::			ds.b	OBJ_SIZE			;text line 3
congln4::			ds.b	OBJ_SIZE			;text line 4
congln5::			ds.b	OBJ_SIZE			;text line 5
congln6::			ds.b	OBJ_SIZE			;text line 6
congln7::			ds.b	OBJ_SIZE			;text line 7
congln8::			ds.b	OBJ_SIZE			;text line 8
congscor::		ds.b	OBJ_SIZE			;score for congratulations screen

intobjs::
introscr::		ds.b	OBJ_SIZE
introtxt::		ds.b	OBJ_SIZE
introicn::		ds.b	OBJ_SIZE
introsco::		ds.b	OBJ_SIZE

	.even

sndsave0::		ds.l	MAX_VOICES		;save sample pitch when paused
voicestatus::		ds.b	MAX_VOICES
sndtype::			ds.b	MAX_VOICES		;sound number for each voice
snd_cnt::			ds.b	MAX_VOICES		;count number of frames that each sound is on
	.even

seed::			ds.l 6				;6 seeds for random numbers

joyedge::			ds.l	1				;used by readpad for input
joycur::			ds.l	1				;used by readpad for input

joyedge2::		ds.l	1				;controller 2, used for cheating
joycur2::			ds.l	1				;controller 2, used for cheating
sampnum::			ds.w	1				;sample number that is played by pressing * key on controller 2

joyold::			ds.l	1				;saves previous joycur
joyhold::			ds.w	1				;counts how long joypad is held up or down

firebut::			ds.l	1				;value to use for btst.l on joyedge or joycur to check for shooting bullets
bombbut::			ds.l	1				;value to use for btst.l on joyedge or joycur to check for dropping bombs
specbut::			ds.l	1				;value to use for btst.l on joyedge or joycur to check for firing special weapon

t_count::			ds.w	1				;title screen animation counter

curship::			ds.w	1				;which data for player ship is being displayed

level::			ds.w	1				;level number
levelx2::			ds.w	1				;level number * 2
levelx4::			ds.w	1				;level number * 4
levelx64::		ds.w	1				;level number * 64
curbktile::		ds.w	1				;background tile on left of screen
oldbktile::		ds.w	1				;curbktile before scrolling occurs

scrlspd::			ds.w	1				;scrolling speed for background tiles
scrlspdf::		ds.w	1				;scrolling speed for foreground objects
odomback::		ds.w	1				;odometer for background
odomfrnt::		ds.w	1				;odometer for foreground
odomend::			ds.w	1				;limit for odomback
oldfront::		ds.w	1				;odomfrnt / 64
firstbuf::		ds.b	1				;tile object header on left side of screen
lastbuf::			ds.b	1				;tile object header on right side of screen
backxpos::		ds.w	1				;xpos for left background tile

endlvdel::		ds.w	1				;counter for after boss is destroyed, delays end of level until END_LEVEL_DELAY

score::			ds.l	1				;score in hex
oldscore::		ds.l	1				;keeps track of score changing

bulnum::			ds.w	1				;count bullets during shot collision detection
bomb_power::		ds.w	1				;power level of player bombs

spec_type::		ds.w	1				;for special weapon O_DESC
spec_tot::		ds.w	MAX_SPEC_WEAPONS	;availability of each special weapon

spec_hit::		ds.w	1				;the last enemy that was hit by the tracer weapon
spec_dir::		ds.b	1				;direction for special weapon
spec_tgt::		ds.b	1				;target for tracer
boltflip::		ds.b	1				;1 if beam between bolt pieces is horizontally flipped
ms_excnt::		ds.b	1				;for missile explosion, counter for when to change ms_exstp
ms_exstp::		ds.b	1				;animation step counter for missile explosion
	.even
ms_rlimit::		ds.w	1				;xpos where missile explodes
maglimit::		ds.w	1				;xpos where magnet slows down
beamtime::		ds.w	1				;time limit for beam
flshtime::		ds.w	1				;time limit for flash
ringstep::		ds.w	1				;animation step for ring special weapon
ringcnt::			ds.w	1				;number of circles to do
shldtime::		ds.w	1				;time limit for shield
tracstep::		ds.w	1				;anim step for tracer

max_g_en::		ds.w	1				;highest enemy number that can be used as a ground enemy for current level
cur_en::			ds.w	1				;offset for elist tables
en_lim::			ds.w	TOTAL_ENEMIES*4	;values from en_limit table
en_type::			ds.w	TOTAL_ENEMIES		;saves enemy type (use when enemy becomes explosion to see what enemy it was before it exploded)
en_health::		ds.w	TOTAL_ENEMIES		;amount of damage each enemy can take before dying
en_formx::		ds.w	TOTAL_ENEMIES		;X position of center point for pattern formula
en_formy::		ds.w	TOTAL_ENEMIES		;Y position of center point for pattern formula
en_rad::			ds.w	TOTAL_ENEMIES		;radius for pattern formula
en_theta::		ds.w	TOTAL_ENEMIES		;circling speed for pattern formula
en_formc::		ds.w	TOTAL_ENEMIES		;counter for pattern formula
en_frmlm::		ds.w	TOTAL_ENEMIES		;limit for en_formc (2048 / theta)
en_newrd::		ds.w	TOTAL_ENEMIES		;new value for en_rad
en_usept::		ds.b	TOTAL_ENEMIES		;1 if enemy should use pattern formula
exp_step::		ds.b	TOTAL_ENEMIES		;explosion animation step for each enemy
exp_count::		ds.b	TOTAL_ENEMIES		;counter for explosion step for each enemy
dir_to_plr::		ds.b	TOTAL_ENEMIES		;approximate direction from enemy to player
enemydir::		ds.b	TOTAL_ENEMIES		;one for each enemy object
dirtomag::		ds.b	TOTAL_ENEMIES		;direction from enemy to magnet special weapon
en_action::		ds.b	TOTAL_ENEMIES		;what each enemy is doing
en_an_step::		ds.b	TOTAL_ENEMIES		;current animation step
en_an_chg::		ds.b	TOTAL_ENEMIES		;counter for when to change en_an_step
en_an_time::		ds.b	TOTAL_ENEMIES		;limit for en_an_chg
atk_chnc::		ds.b	TOTAL_ENEMIES		;chance of attacking at beginning of animation cycle
en_fired::		ds.b	TOTAL_ENEMIES		;1 after enemy has fired, gets reset for most enemies
en_speed::		ds.b	TOTAL_ENEMIES		;one for each enemy object
en_mvcnt::		ds.b	TOTAL_ENEMIES		;counts how many times each enemy has moved
en_mvlmt::		ds.b	TOTAL_ENEMIES		;limit for en_mvcnt
en_altmv::		ds.b	TOTAL_ENEMIES		;use alternate moving animation if 1
in_form::			ds.b	TOTAL_ENEMIES		;formation number if enemy is in a formation, $FF if not
en_sh_dir::		ds.b	MAX_ENEMY_SHOTS	;direction for each enemy shot
en_sh_speed::		ds.b	MAX_ENEMY_SHOTS	;speed for each enemy shot
en_sh_cnt::		ds.b	MAX_ENEMY_SHOTS	;animation counter for each enemy shot
en_sh_anm::		ds.b	MAX_ENEMY_SHOTS	;animation step for each enemy shot
en_sh_tg::		ds.b	MAX_ENEMY_SHOTS	;1 if enemy uses a target
	.even
sh_targx::		ds.w	MAX_ENEMY_SHOTS	;X target for each enemy shot
sh_targy::		ds.w	MAX_ENEMY_SHOTS	;Y target for each enemy shot

exp_stps::		ds.b	MAX_BULLETS		;explosion animation step for each bullet
exp_cnts::		ds.b	MAX_BULLETS		;counter for explosion step for each bullet
exp_stpb::		ds.b	1				;explosion animation step for bomb
exp_cntb::		ds.b	1				;counter for explosion step for bomb

gamemode::		ds.b	1				;title, select, game, congrats, etc
finished::		ds.b	TOTAL_WORLDS+1		;1 byte for each pair of space and planet levels, 1 if both levels have been completed
lvlsdone::		ds.b	1				;number of levels that have been completed

pause_flag::		ds.b	1				;1 when game is paused
cont_del::		ds.b	1				;delay before you can continue so you see the game over sign
cont_cnt::		ds.b	1				;counter for switching between game over and continue signs
cont_sign::		ds.b	1				;0 for game over sign, 1 for continue sign
gameover::		ds.b	1				;1 when game has ended
levstatus::		ds.b	1				;0 during level, 1 at end
levflag::			ds.b	1				;1 when level should change at end of loop
bossmade::		ds.b	1				;1 when boss character has been created in current level
active_enemies::	ds.b	1				;current number of active enemies
limitflag::		ds.b	1				;1 when object moves past its limits
	.even
limitall::							;label so the 4 limit bytes can be cleared as a long
limittop::		ds.b	1				;1 when object hits its top limit
limitbot::		ds.b	1				;1 when object hits its bottom limit
limitlf::			ds.b	1				;1 when object hits its left limit
limitrt::			ds.b	1				;1 when object hits its right limit

newtilfl::		ds.b	1				;flag is set when a new tile scrolls on screen

flagcnt::			ds.b	1				;animation counter for station flag
flagstp::			ds.b	1				;animation step for station flag

lives::			ds.b	1				;current number of lives for player
plrflash::		ds.b	1				;timer for player flashing after exploding
levdelay::		ds.b	1				;delay before you can fire at the start of a level
shot_delay::		ds.b	1				;limit firing rate when holding down controller button
spec_delay::		ds.b	1				;limit firing rate when holding down controller button
score_dec::		ds.b	SCORE_DIGITS		;decimal score digits

pwr_dir::			ds.b	1				;direction for active powerup

bulpower::		ds.b	1				;power level for player shots

p_expstp::		ds.b	1				;player explosion animation step
p_expcnt::		ds.b	1				;when to change player explosion animation step

bomb_an_step::		ds.b	1				;bomb animation step for hpos and vpos tables

;cutr_dir::		ds.b	1				;current direction for cutter
cutshdel::		ds.b	1				;delay between cutter shots
;cdirtime::		ds.b	1				;delay between change of direction for cutter
	.even
cutrtime::		ds.w	1				;cutter time limit
cutrfrmc::		ds.w	1				;count moves around circle
cutrfrmx::		ds.w	1				;x position of center of circle
cutrfrmy::		ds.w	1				;y position of center of circle
cutrrad::			ds.w	1				;radius of circle
cutrthet::		ds.w	1				;speed around circle

;level selection screen stuff
selection::		ds.b	1				;$FF if cursor is not over a planet, planet number if over a planet

intcount::		ds.b	1				;interrupt counter
pal_ntsc::		ds.b	1				;0 if NTSC, 1 if PAL
gpucode::			ds.b	1				;BUILD if build code is in GPU RAM, DECOMP if dejag code is in GPU RAM

	.even
chtcode::			ds.l	2				;holds numbers that are used to turn on cheat mode
chtflag::			ds.b	1				;1 if cheat mode is on

	.text

looptable::		dc.l	titleloop,selloop,gameloop,congloop

tilebufs::		dc.l	tile00,tile01,tile02,tile03,tile04,tile05,tile06,tile07
				dc.l	tile08,tile09,tile10,tile11,tile12,tile13,tile14,tile15
				dc.l	tile16,tile17,tile18,tile19,tile20,tile21

boss_tbl::		dc.l	mkboss00,mkboss01	;create boss enemies for level 1
				dc.l	mkboss02,mkboss03	;create boss enemies for level 2
				dc.l	mkboss04,mkboss05	;create boss enemies for level 3
				dc.l	mkboss06,mkboss07	;create boss enemies for level 4
				dc.l	mkboss08,mkboss09	;create boss enemies for last level
				dc.l	mkboss10
boss_adj::		dc.l	adboss00,adboss01	;adjust positions of boss enemies for level 1
				dc.l	adboss02,adboss03	;adjust positions of boss enemies for level 2
				dc.l	adboss04,adboss05	;adjust positions of boss enemies for level 3
				dc.l	adboss06,adboss07	;adjust positions of boss enemies for level 4
				dc.l	adboss08,adboss09	;adjust positions of boss enemy for last level
				dc.l	adboss10

od_end1::			dc.w	ODOM_END1		;space  level 1	where scrolling stops
				dc.w	ODOM_END1		;planet level 1
				dc.w	ODOM_END1		;space  level 2
				dc.w	ODOM_END1		;planet level 2
				dc.w	ODOM_END1		;space  level 3
				dc.w	ODOM_END1		;planet level 3
				dc.w	ODOM_END1		;space  level 4
				dc.w	ODOM_END1		;planet level 4
				dc.w	ODOM_END1		;last space level
				dc.w	ODOM_END1		;last level
				dc.w	ODOM_END1		;bonus level
od_end2::			dc.w	ODOM_END2		;space  level 1	where fast scrolling stops, level ends
				dc.w	ODOM_END1		;planet level 1
				dc.w	ODOM_END2		;space  level 2
				dc.w	ODOM_END1		;planet level 2
				dc.w	ODOM_END2		;space  level 3
				dc.w	ODOM_END1		;planet level 3
				dc.w	ODOM_END2		;space  level 4
				dc.w	ODOM_END1		;planet level 4
				dc.w	ODOM_END1		;last space level
				dc.w	ODOM_END1		;last level
				dc.w	ODOM_END2		;bonus level


shipdata::
	dc.l		player00,player01,player02,player03,player04
shlddata::
	dc.l		shield00,shield01,shield02,shield03,shield04

cutrshps::
;addresses of compressed data for cutter ship for each level
	dc.l		cutr4,cutr4				;desert
	dc.l		cutr2,cutr2				;cave
	dc.l		cutr0,cutr0				;air level
	dc.l		cutr1,cutr1				;swamp
	dc.l		cutr3,cutr3				;city
	dc.l		cutr0
cutrmsks::
;addresses of mask data for cutter ship for each level
	dc.l		cutr4_m,cutr4_m			;desert
	dc.l		cutr2_m,cutr2_m			;cave
	dc.l		cutr0_m,cutr0_m			;air level
	dc.l		cutr1_m,cutr1_m			;swamp
	dc.l		cutr3_m,cutr3_m			;city
	dc.l		cutr0_m

spds_h::
;horizontal speed for each direction
	dc.w		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0		;speed 0
	dc.w		  0,  1,  1,  1,  1,  1,  1,  1,  0, -1, -1, -1, -1, -1, -1, -1		;speed 1
	dc.w		  0,  1,  1,  2,  2,  2,  1,  1,  0, -1, -1, -2, -2, -2, -1, -1		;speed 2
	dc.w		  0,  1,  2,  3,  3,  3,  2,  1,  0, -1, -2, -3, -3, -3, -2, -1		;speed 3
	dc.w		  0,  2,  3,  3,  4,  3,  3,  2,  0, -2, -3, -3, -4, -3, -3, -2		;speed 4
	dc.w		  0,  2,  3,  4,  5,  4,  3,  2,  0, -2, -3, -4, -5, -4, -3, -2		;speed 5
	dc.w		  0,  2,  4,  5,  6,  5,  4,  2,  0, -2, -4, -5, -6, -5, -4, -2		;speed 6
	dc.w		  0,  3,  5,  6,  7,  6,  5,  3,  0, -3, -5, -6, -7, -6, -5, -3		;speed 7
	dc.w		  0,  3,  6,  7,  8,  7,  6,  3,  0, -3, -6, -7, -8, -7, -6, -3		;speed 8
	dc.w		  0,  3,  6,  8,  9,  8,  6,  3,  0, -3, -6, -8, -9, -8, -6, -3		;speed 9
	dc.w		  0,  4,  7,  9, 10,  9,  7,  4,  0, -4, -7, -9,-10, -9, -7, -4		;speed 10
	dc.w		  0,  4,  7, 10, 11, 10,  7,  4,  0, -4, -7,-10,-11,-10, -7, -4		;speed 11
	dc.w		  0,  5,  8, 10, 12, 10,  8,  5,  0, -5, -8,-10,-12,-10, -8, -5		;speed 12
;special speeds
	dc.w		  1,  2,  2,  3,  3,  3,  2,  2, -1, -2, -2, -3, -3, -3, -2, -2		;speed 13 (speed 3)
	dc.w		  2,  2,  3,  4,  4,  4,  3,  2, -2, -2, -3, -4, -4, -4, -3, -2		;speed 14 (speed 4)
	dc.w		  3,  3,  4,  5,  5,  5,  4,  3, -3, -3, -4, -5, -5, -5, -4, -3		;speed 15 (speed 5)
spds_v::
;vertical speed for each direction
	dc.w		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0		;speed 0
	dc.w		 -1, -1, -1, -1,  0,  1,  1,  1,  1,  1,  1,  1,  0, -1, -1, -1		;speed 1
	dc.w		 -2, -2, -1, -1,  0,  1,  1,  2,  2,  2,  1,  1,  0, -1, -1, -2		;speed 2
	dc.w		 -3, -3, -2, -1,  0,  1,  2,  3,  3,  3,  2,  1,  0, -1, -2, -3		;speed 3
	dc.w		 -4, -3, -3, -2,  0,  2,  3,  3,  4,  3,  3,  2,  0, -2, -3, -3		;speed 4
	dc.w		 -5, -4, -3, -2,  0,  2,  3,  4,  5,  4,  3,  2,  0, -2, -3, -4		;speed 5
	dc.w		 -6, -5, -4, -2,  0,  2,  3,  5,  6,  5,  4,  2,  0, -2, -4, -5		;speed 6
	dc.w		 -7, -6, -5, -3,  0,  3,  5,  6,  7,  6,  5,  3,  0, -3, -5, -6		;speed 7
	dc.w		 -8, -7, -6, -3,  0,  3,  6,  7,  8,  7,  6,  3,  0, -3, -6, -7		;speed 8
	dc.w		 -9, -8, -6, -3,  0,  3,  6,  8,  9,  8,  6,  3,  0, -3, -6, -8		;speed 9
	dc.w		-10, -9, -7, -4,  0,  4,  7,  9, 10,  9,  7,  4,  0, -4, -7, -9		;speed 10
	dc.w		-11,-10, -7, -4,  0,  4,  7, 10, 11, 10,  7,  4,  0, -4, -7,-10		;speed 11
	dc.w		-12,-10, -8, -5,  0,  5,  8, 10, 12, 10,  8,  5,  0, -5, -8,-10		;speed 12
;special speeds
	dc.w		 -3, -2, -2, -1,  0,  1,  2,  2,  3,  2,  2,  1,  0, -1, -2, -2		;speed 13 (speed 3)
	dc.w		 -4, -3, -2, -1,  0,  1,  2,  3,  4,  3,  2,  1,  0, -1, -2, -3		;speed 14 (speed 4)
	dc.w		 -5, -3, -2, -1,  0,  1,  2,  3,  5,  3,  2,  1,  0, -1, -2, -3		;speed 15 (speed 5)

num_addr::		dc.l		num0,num1,num2,num3,num4,num5,num6,num7,num8,num9

;EXP_A	equ	0		;explosion A		(16 x 16)
;EXP_B	equ	1		;explosion B		(32 x 24)
;EXP_C	equ	2		;explosion C		(48 x 40)
;EXP_D	equ	3		;explosion D		(80 x 64)
;EXP_E	equ	4		;explosion E		(80 x 64 used for missile)
;PILL_EXP	equ	5		;pillbug explosion	(32 x 24)
;SEYM_EXP	equ	6		;seymour explosion	(48 x 64)
;EXP_F	equ	7		;scaled explosion	(200 x 160)
exp_data::											;8 steps for each type of explosion
expa_dta::
	dc.l		exp_a0,exp_a1,exp_a2,exp_a3,0,0,0,0
expb_dta::
	dc.l		exp_b0,exp_b1,exp_b2,exp_b3,exp_b4,exp_b5,exp_b6,exp_b7
expc_dta::
	dc.l		exp_c0,exp_c1,exp_c2,exp_c3,exp_c4,exp_c5,exp_c6,exp_c7
expd_dta::
plr_exdt::
	dc.l		exp_d0,exp_d1,exp_d2,exp_d3,exp_d4,exp_d5,exp_d6,exp_d7
expe_dta::
	dc.l		exp_d0,exp_d1,exp_d2,exp_d3,exp_d4,exp_d5,exp_d6,exp_d7
;pillbug
	dc.l		pillexp0,pillexp1,pillexp2,0,0,0,0,0
;seymour
	dc.l		seymexp0,seymexp1,seymexp2,seymexp3,0,0,0,0
expf_dta::
	dc.l		exp_d0,exp_d1,exp_d2,exp_d3,exp_d4,exp_d5,exp_d6,exp_d7

exp_ht::
	dc.w		12,14,16,14,0,0,0,0			;explosion A
	dc.w		16,17,21,20,22,24,22,23		;explosion B
	dc.w		27,29,32,36,38,40,39,40		;explosion C
	dc.w		44,46,49,58,61,62,64,64		;explosion D
	dc.w		44,46,49,58,61,62,64,64		;explosion E
	dc.w		24,24,24,24,24,24,24,24		;pillbug explosion
	dc.w		64,64,64,64,64,64,64,64		;seymour explosion
	dc.w		44,46,49,58,61,62,64,64		;explosion F

exp_otyp:												;explosion dwidth, iwidth
	dc.b		0		;explosion A
	dc.b		0		;explosion B
	dc.b		0		;explosion C
	dc.b		0		;explosion D
	dc.b		0		;explosion E
	dc.b		0		;pillbug explosion
	dc.b		0		;seymour explosion
	dc.b		1		;explosion F
exp_dw::												;explosion dwidth, iwidth
	dc.w		4		;explosion A
	dc.w		8		;explosion B
	dc.w		12		;explosion C
	dc.w		20		;explosion D
	dc.w		20		;explosion E
	dc.w		8		;pillbug explosion
	dc.w		12		;seymour explosion
	dc.w		20		;explosion F
exp_stp::												;max anim steps for each type of explosion
	dc.b		4		;explosion A
	dc.b		8		;explosion B
	dc.b		8		;explosion C
	dc.b		8		;explosion D
	dc.b		8		;explosion E
	dc.b		3		;pillbug explosion
	dc.b		4		;seymour explosion
	dc.b		8		;explosion F
exp_chg::												;when to change exp_step for each type of explosion
	dc.b		3		;explosion A
	dc.b		3		;explosion B
	dc.b		3		;explosion C
	dc.b		3		;explosion D
	dc.b		3		;explosion E
	dc.b		7		;pillbug explosion
	dc.b		4		;seymour explosion
	dc.b		6		;explosion F
exp_scl::												;explosion scale size
	dc.l		$00202020	;explosion A
	dc.l		$00202020	;explosion B
	dc.l		$00202020	;explosion C
	dc.l		$00202020	;explosion D
	dc.l		$00202020	;explosion E
	dc.l		$00202020	;pillbug explosion
	dc.l		$00202020	;seymour explosion
	dc.l		$00505050	;explosion F

exp_snd::
	dc.b		EXPLOS0_SND	;explosion A
	dc.b		EXPLOS0_SND	;explosion B
	dc.b		EXPLOS1_SND	;explosion C
	dc.b		EXPLOS1_SND	;explosion D
	dc.b		EXPLOS1_SND	;explosion E
	dc.b		EXPLOS2_SND	;pillbug explosion
	dc.b		EXPLOS1_SND	;seymour explosion
	dc.b		EXPLOS1_SND	;explosion F

	.even

;********************************************************
;TABLES FOR ENEMIES
;********************************************************
en_chg_times::
;time limit when animation step changes for each enemy
;dying, appearing, moving, attacking
	dc.b		 0, 0, 7, 6			;pillbug
	dc.b		 0, 0, 7, 7			;seymour
	dc.b		 0, 0, 5, 2			;turborat
	dc.b		 1, 1, 6, 6			;batskull
	dc.b		 0, 0, 6, 0			;big purple rock
	dc.b		 0, 0, 5, 0			;med purple rock
	dc.b		 0, 0, 4, 0			;sml purple rock
	dc.b		 0, 0, 6, 0			;big rock
	dc.b		 0, 0, 5, 0			;med rock
	dc.b		 0, 0, 4, 0			;small rock
	dc.b		 0, 0, 6, 0			;big crystal
	dc.b		 0, 0, 3, 0			;med crystal A
	dc.b		 0, 0, 3, 0			;med crystal B
	dc.b		 0, 0, 5, 0			;big star
	dc.b		 0, 0, 3, 0			;med star
	dc.b		 0, 0, 4, 4			;spinner
	dc.b		 0, 0, 6, 4			;small scorpion
	dc.b		 0, 0,11, 5			;big scorpion
	dc.b		 0, 0, 6, 6			;buggy
	dc.b		 0, 0, 6, 5			;cube
	dc.b		 0, 0, 6, 6			;sphere
	dc.b		 0, 0, 6, 6			;tri whole
	dc.b		 0, 0, 6, 6			;tri 3 pieces
	dc.b		 0, 0, 6, 6			;tri 2 pieces
	dc.b		 0, 0, 6, 6			;tri 1 piece
	dc.b		 0, 0, 5, 0			;bat
	dc.b		 0, 0, 5, 0			;big burple
	dc.b		 0, 0, 4, 0			;sml burple
	dc.b		 0, 0, 5, 0			;big bubble
	dc.b		 0, 0, 4, 0			;sml bubble
	dc.b		 0, 0, 5, 0			;big pebble
	dc.b		 0, 0, 4, 0			;med pebble
	dc.b		 0, 0, 3, 0			;sml pebble
	dc.b		 0, 0, 5, 4			;firebug
	dc.b		 0, 0, 5, 5			;hummingbird
	dc.b		 0, 6, 4, 4			;vulture
	dc.b		 0, 0, 4, 4			;flower
	dc.b		 0, 0, 5, 5			;gundino
	dc.b		 0, 0, 5, 5			;firefly
	dc.b		 0, 0, 5, 0			;small spider
	dc.b		 0, 0, 5, 0			;big spider
	dc.b		 0, 0, 6, 6			;kilrun
	dc.b		 3, 0, 7, 7			;sadmask
	dc.b		 0, 0, 4, 3			;fish taxi
	dc.b		 0, 0, 5, 5			;baby
	dc.b		 0, 0, 5, 5			;small dino
	dc.b		 0, 0, 7, 7			;robot
	dc.b		 0, 5, 3, 3			;snake
	dc.b		 0, 0, 6, 6			;glowbug
	dc.b		 0, 0, 8, 0			;big blue eye
	dc.b		 0, 0, 8, 0			;big green eye
	dc.b		 0, 0, 7, 0			;small blue eye
	dc.b		 0, 0, 7, 0			;small green eye
	dc.b		 0, 0, 6, 6			;dragon
	dc.b		 0, 0, 9, 9			;desert robot top
	dc.b		 0, 0, 9, 9			;desert robot bottom
	dc.b		 0, 0, 6, 6			;air robot boss
	dc.b		 0, 0, 6, 3			;cave robot boss
	dc.b		 0, 0, 7, 7			;wrd robot body
	dc.b		 0, 0, 6, 6			;wrd robot tail
	dc.b		 0, 0,10,10			;wrd robot r arm
	dc.b		 0, 0,10,10			;wrd robot l arm
	dc.b		 0, 0, 6, 6			;city robot body
	dc.b		 0, 0, 5, 5			;city robot head
	dc.b		 0, 0, 7, 7			;serpent body
	dc.b		 0, 0, 7, 7			;serpent right wing
	dc.b		 0, 0, 7, 7			;serpent left wing
	dc.b		 0, 0, 4, 4			;quetzal body
	dc.b		 0, 0, 4, 4			;quetzal back arm
	dc.b		 0, 0, 4, 4			;quetzal front arm
	dc.b		 0, 0, 4, 4			;quetzal tail
	dc.b		 0, 0,99, 0			;skull ribs
	dc.b		 0, 0,12, 6			;skull arm
	dc.b		 0, 0, 8, 8			;skull head
	dc.b		 0, 0, 8, 8			;skull neck
	dc.b		 0, 0, 8, 8			;skull back horn
	dc.b		 0, 0, 8, 8			;skull front horn
	dc.b		 0, 0, 8, 8			;skull nose horn
	dc.b		 0, 0, 7, 0			;oddit cloud
	dc.b		 0, 0, 7, 7			;oddit
	dc.b		 0, 0,20, 6			;mud man
	dc.b		 4, 1, 8, 7			;spore
	dc.b		 0, 0,10, 6			;fern
	dc.b		 0, 0, 5, 5			;big dino
	dc.b		 0, 0, 5, 5			;slug
	dc.b		 0, 0, 5, 0			;ball
	dc.b		 0, 0,99, 0			;big block
	dc.b		 0, 0,99, 0			;med block
	dc.b		 0, 0,99, 0			;sml block
	dc.b		 0, 0,99, 3			;geyser
	dc.b		 0, 0,99, 0			;poppy0
	dc.b		 0, 0,99, 0			;poppy1
	dc.b		 0, 0,99, 0			;poppy2
	dc.b		 0, 0,99, 0			;tower
	dc.b		 0, 0, 5, 0			;elec
	dc.b		 0, 0,99, 0			;mingbot
	dc.b		 0, 0,99, 0			;falling rock
	dc.b		 0, 0,99, 0			;large ring
	dc.b		 0, 0,99, 0			;med ring
	dc.b		 0, 0,99, 0			;small ring
en_steps::
;animation steps for each action for each enemy
;dying, appearing, moving, attacking
	dc.b		 0, 0, 4,15			;pillbug
	dc.b		 0, 0, 4, 7			;seymour
	dc.b		 0, 0, 8,11			;turborat
	dc.b		 4, 4, 4, 8			;batskull
	dc.b		 0, 0,14, 0			;big purple rock
	dc.b		 0, 0,14, 0			;med purple rock
	dc.b		 0, 0,14, 0			;sml purple rock
	dc.b		 0, 0,16, 0			;big rock
	dc.b		 0, 0,16, 0			;med rock
	dc.b		 0, 0,16, 0			;small rock
	dc.b		 0, 0, 8, 0			;big crystal
	dc.b		 0, 0,16, 0			;med crystal A
	dc.b		 0, 0,16, 0			;med crystal B
	dc.b		 0, 0, 4, 0			;big star
	dc.b		 0, 0, 4, 0			;med star
	dc.b		 0, 0, 8, 8			;spinner
	dc.b		 0, 0, 4, 7			;small scorpion
	dc.b		 0, 0, 2, 5			;big scorpion
	dc.b		 0, 0, 8, 4			;buggy
	dc.b		 0, 0,16, 9			;cube
	dc.b		 0, 0,12,16			;sphere
	dc.b		 0, 0, 4, 4			;tri whole
	dc.b		 0, 0, 4, 4			;tri 3 pieces
	dc.b		 0, 0, 4, 4			;tri 2 pieces
	dc.b		 0, 0, 4, 4			;tri 1 piece
	dc.b		 0, 0,28, 0			;bat				;moving animation uses both moving animation tables
	dc.b		 0, 0,16, 0			;big burple
	dc.b		 0, 0,16, 0			;sml burple
	dc.b		 0, 0,16, 0			;big bubble
	dc.b		 0, 0,16, 0			;sml bubble
	dc.b		 0, 0,16, 0			;big pebble
	dc.b		 0, 0,16, 0			;med pebble
	dc.b		 0, 0,16, 0			;sml pebble
	dc.b		 0, 0,10, 9			;firebug
	dc.b		 0, 0, 7, 4			;hummingbird
	dc.b		 0,12,11, 9			;vulture
	dc.b		 0, 0, 4, 8			;flower
	dc.b		 0, 0, 4, 7			;gundino
	dc.b		 0, 0, 4, 3			;firefly
	dc.b		 0, 0, 6, 0			;small spider
	dc.b		 0, 0, 6, 0			;big spider
	dc.b		 0, 0, 4, 9			;kilrun
	dc.b		 4, 0, 4,12			;sadmask
	dc.b		 0, 0,12,12			;fish taxi
	dc.b		 0, 0, 7, 6			;baby
	dc.b		 0, 0, 8, 8			;small dino
	dc.b		 0, 0, 5, 5			;robot
	dc.b		 0, 7,30,30			;snake
	dc.b		 0, 0,14,14			;glowbug
	dc.b		 0, 0,14, 0			;big blue eye
	dc.b		 0, 0,14, 0			;big green eye
	dc.b		 0, 0,14, 0			;small blue eye
	dc.b		 0, 0,14, 0			;small green eye
	dc.b		 0, 0,10,10			;dragon
	dc.b		 0, 0, 4, 8			;desert robot boss
	dc.b		 0, 0, 4, 8			;desert robot bottom
	dc.b		 0, 0, 8, 8			;air robot boss
	dc.b		 0, 0, 8,18			;cave robot boss
	dc.b		 0, 0, 6, 6			;wrd robot body
	dc.b		 0, 0,11,11			;wrd robot tail
	dc.b		 0, 0, 4, 4			;wrd robot r arm
	dc.b		 0, 0, 8, 8			;wrd robot l arm
	dc.b		 0, 0, 4,16			;city robot body
	dc.b		 0, 0, 4, 9			;city robot head
	dc.b		 0, 0, 8, 9			;serpent body
	dc.b		 0, 0, 8, 9			;serpent right wing
	dc.b		 0, 0, 8, 9			;serpent left wing
	dc.b		 0, 0,16,16			;quetzal body
	dc.b		 0, 0,16,16			;quetzal back arm
	dc.b		 0, 0,16,16			;quetzal front arm
	dc.b		 0, 0,16,16			;quetzal tail
	dc.b		 0, 0, 1, 0			;skull ribs
	dc.b		 0, 0, 1, 6			;skull arm
	dc.b		 0, 0, 1,16			;skull head
	dc.b		 0, 0, 1,16			;skull neck
	dc.b		 0, 0, 1,16			;skull back horn
	dc.b		 0, 0, 1,16			;skull front horn
	dc.b		 0, 0, 1,16			;skull nose horn
	dc.b		 0, 0, 4, 0			;oddit cloud
	dc.b		 0, 0,12,12			;oddit
	dc.b		 0, 0, 1, 9			;mud man
	dc.b		 4, 0, 3, 8			;spore
	dc.b		 0, 0, 4, 8			;fern
	dc.b		 0, 0, 8, 8			;big dino
	dc.b		 0, 0, 6, 6			;slug
	dc.b		 0, 0, 1, 0			;ball
	dc.b		 0, 0, 1, 0			;big block
	dc.b		 0, 0, 1, 0			;med block
	dc.b		 0, 0, 1, 0			;sml block
	dc.b		 0, 0, 1,19			;geyser
	dc.b		 0, 0, 1, 0			;poppy0
	dc.b		 0, 0, 1, 0			;poppy1
	dc.b		 0, 0, 1, 0			;poppy2
	dc.b		 0, 0, 1, 0			;tower
	dc.b		 0, 0, 4, 0			;elec
	dc.b		 0, 0, 1, 0			;mingbot
	dc.b		 0, 0, 1, 0			;falling rock
	dc.b		 0, 0, 1, 0			;large ring
	dc.b		 0, 0, 1, 0			;med ring
	dc.b		 0, 0, 1, 0			;small ring

en_actdw::
;dwidth and iwidth for each enemy action
;dying, appearing, moving, attacking
	dc.b		 4, 4, 4, 4	;pillbug
	dc.b		12,12,12,12	;seymour
	dc.b		16,16,16,16	;turborat
	dc.b		 8, 8, 8, 8	;batskull
	dc.b		16,16,16,16	;big purple rock
	dc.b		 8, 8, 8, 8	;med purple rock
	dc.b		 4, 4, 4, 4	;sml purple rock
	dc.b		12,12,12,12	;big rock
	dc.b		 8, 8, 8, 8	;med rock
	dc.b		 4, 4, 4, 4	;small rock
	dc.b		16,16,16,16	;big crystal
	dc.b		 8, 8, 8, 8	;med crystal A
	dc.b		 8, 8, 8, 8	;med crystal B
	dc.b		16,16,16,16	;big star
	dc.b		 8, 8, 8, 8	;med star
	dc.b		12,12,12,12	;spinner
	dc.b		 8, 8, 8, 8	;small scorpion
	dc.b		48,48,48,48	;big scorpion
	dc.b		12,12,12,12	;buggy
	dc.b		12,12,12,12	;cube spin forward
	dc.b		12,12,12,12	;sphere
	dc.b		12,12,12,12	;tri whole
	dc.b		12,12,12,12	;tri 3 pieces
	dc.b		12,12,12,12	;tri 2 pieces
	dc.b		12,12,12,12	;tri 1 piece
	dc.b		16,16,16,16	;bat
	dc.b		16,16,16,16	;big burple
	dc.b		 8, 8, 8, 8	;sml burple
	dc.b		16,16,16,16	;big bubble
	dc.b		 8, 8, 8, 8	;sml bubble
	dc.b		16,16,16,16	;big pebble
	dc.b		12,12,12,12	;med pebble
	dc.b		 4, 4, 4, 4	;sml pebble
	dc.b		12,12,12,12	;firebug
	dc.b		 8, 8, 8, 8	;hummingbird
	dc.b		16,16,16,16	;vulture
	dc.b		 4, 4, 4, 4	;flower
	dc.b		 8, 8, 8, 8	;gundino
	dc.b		 8, 8, 8, 8	;firefly
	dc.b		12,12,12,12	;small spider
	dc.b		24,24,24,24	;big spider
	dc.b		12,12,12,12	;kilrun
	dc.b		12,12,12,12	;sadmask
	dc.b		16,16,16,16	;fish taxi
	dc.b		32,32,32,32	;baby
	dc.b		16,16,16,16	;small dino
	dc.b		40,40,40,40	;robot
	dc.b		24, 8,24,24	;snake
	dc.b		12,12,12,12	;glowbug
	dc.b		16,16,16,16	;big blue eye
	dc.b		16,16,16,16	;big green eye
	dc.b		12,12,12,12	;small blue eye
	dc.b		12,12,12,12	;small green eye
	dc.b		20,20,20,20	;dragon
	dc.b		48,48,48,48	;desert robot boss
	dc.b		 8, 8, 8, 8	;desert robot bottom
	dc.b		40,40,40,40	;air robot boss
	dc.b		48,48,48,40	;cave robot boss
	dc.b		40,40,40,40	;wrd robot body
	dc.b		20,20,20,20	;wrd robot tail
	dc.b		20,20,20,20	;wrd robot r arm
	dc.b		32,32,32,32	;wrd robot l arm
	dc.b		32,32,32,32	;city robot body
	dc.b		12,12,12,12	;city robot head
	dc.b		56,56,56,56	;serpent body
	dc.b		40,40,40,40	;serpent right wing
	dc.b		40,40,40,40	;serpent left wing
	dc.b		48,48,48,48	;quetzal body
	dc.b		20,20,20,20	;quetzal back arm
	dc.b		20,20,20,20	;quetzal front arm
	dc.b		24,24,24,24	;quetzal tail
	dc.b		24,24,24,24	;skull ribs
	dc.b		32,32,32,32	;skull arm
	dc.b		20,20,20,20	;skull head
	dc.b		12,12,12,12	;skull neck
	dc.b		16,16,16,16	;skull back horn
	dc.b		 8, 8, 8, 8	;skull front horn
	dc.b		 8, 8, 8, 8	;skull nose horn
	dc.b		28,28,28,28	;oddit cloud
	dc.b		28,28,28,28	;oddit
	dc.b		20,20,20,20	;mud man
	dc.b		16,16,16,16	;spore
	dc.b		 8, 8, 8, 8	;fern
	dc.b		48,48,48,48	;big dino
	dc.b		12,12,12,12	;slug
	dc.b		16,16,16,16	;ball
	dc.b		64,64,64,64	;big block
	dc.b		48,48,48,48	;med block
	dc.b		32,32,32,32	;sml block
	dc.b		12,12,12,12	;geyser
	dc.b		 8, 8, 8, 8	;poppy0
	dc.b		 4, 4, 4, 4	;poppy1
	dc.b		 8, 8, 8, 8	;poppy2
	dc.b		16,16,16,16	;tower
	dc.b		48,48,48,48	;elec
	dc.b		32,32,32,32	;mingbot
	dc.b		12,12,12,12	;falling rock
	dc.b		20,20,20,20	;large ring
	dc.b		16,16,16,16	;med ring
	dc.b		 8, 8, 8, 8	;small ring

en_xstart::
;this is only used for ground enemies to get their starting X position
	dc.w		SCRN_RIGHT		;pillbug
	dc.w		SCRN_RIGHT		;seymour
	dc.w		SCRN_RIGHT		;turborat
	dc.w		SCRN_RIGHT		;batskull
	dc.w		SCRN_RIGHT		;big purple rock
	dc.w		SCRN_RIGHT		;med purple rock
	dc.w		SCRN_RIGHT		;sml purple rock
	dc.w		SCRN_RIGHT		;big rock
	dc.w		SCRN_RIGHT		;med rock
	dc.w		SCRN_RIGHT		;small rock
	dc.w		SCRN_RIGHT		;big crystal
	dc.w		SCRN_RIGHT		;med crystal A
	dc.w		SCRN_RIGHT		;med crystal B
	dc.w		SCRN_RIGHT		;big star
	dc.w		SCRN_RIGHT		;med star
	dc.w		SCRN_RIGHT		;spinner
	dc.w		SCRN_RIGHT		;small scorpion
	dc.w		SCRN_RIGHT		;big scorpion
	dc.w		SCRN_RIGHT		;buggy
	dc.w		SCRN_RIGHT		;cube
	dc.w		SCRN_RIGHT		;sphere
	dc.w		SCRN_RIGHT		;tri whole
	dc.w		SCRN_RIGHT		;tri 3 pieces
	dc.w		SCRN_RIGHT		;tri 2 pieces
	dc.w		SCRN_RIGHT		;tri 1 piece
	dc.w		SCRN_RIGHT		;bat
	dc.w		SCRN_RIGHT		;big burple
	dc.w		SCRN_RIGHT		;sml burple
	dc.w		SCRN_RIGHT		;big bubble
	dc.w		SCRN_RIGHT		;sml bubble
	dc.w		SCRN_RIGHT		;big pebble
	dc.w		SCRN_RIGHT		;med pebble
	dc.w		SCRN_RIGHT		;sml pebble
	dc.w		SCRN_RIGHT		;firebug
	dc.w		SCRN_RIGHT		;hummingbird
	dc.w		SCRN_RIGHT		;vulture
	dc.w		SCRN_RIGHT		;flower
	dc.w		SCRN_RIGHT		;gundino
	dc.w		SCRN_RIGHT		;firefly
	dc.w		SCRN_RIGHT		;small spider
	dc.w		SCRN_RIGHT		;big spider
	dc.w		SCRN_RIGHT		;kilrun
	dc.w		SCRN_RIGHT		;sadmask
	dc.w		SCRN_RIGHT		;fish taxi
	dc.w		SCRN_RIGHT		;baby
	dc.w		SCRN_RIGHT		;small dino
	dc.w		SCRN_RIGHT		;robot
	dc.w		SCRN_RIGHT		;snake
	dc.w		SCRN_RIGHT		;glowbug
	dc.w		SCRN_RIGHT		;big blue eye
	dc.w		SCRN_RIGHT		;big green eye
	dc.w		SCRN_RIGHT		;small blue eye
	dc.w		SCRN_RIGHT		;small green eye
	dc.w		SCRN_RIGHT		;dragon
	dc.w		SCRN_RIGHT		;desert robot boss
	dc.w		SCRN_RIGHT		;desert robot bottom
	dc.w		SCRN_RIGHT		;air robot boss
	dc.w		SCRN_RIGHT		;cave robot boss
	dc.w		SCRN_RIGHT		;wrd robot body
	dc.w		SCRN_RIGHT		;wrd robot tail
	dc.w		SCRN_RIGHT		;wrd robot r arm
	dc.w		SCRN_RIGHT		;wrd robot l arm
	dc.w		SCRN_RIGHT		;city robot body
	dc.w		SCRN_RIGHT		;city robot head
	dc.w		SCRN_RIGHT		;serpent body
	dc.w		SCRN_RIGHT		;serpent right wing
	dc.w		SCRN_RIGHT		;serpent left wing
	dc.w		SCRN_RIGHT		;quetzal body
	dc.w		SCRN_RIGHT		;quetzal back arm
	dc.w		SCRN_RIGHT		;quetzal front arm
	dc.w		SCRN_RIGHT		;quetzal tail
	dc.w		SCRN_RIGHT		;skull ribs
	dc.w		SCRN_RIGHT		;skull arm
	dc.w		SCRN_RIGHT		;skull head
	dc.w		SCRN_RIGHT		;skull neck
	dc.w		SCRN_RIGHT		;skull back horn
	dc.w		SCRN_RIGHT		;skull front horn
	dc.w		SCRN_RIGHT		;skull nose horn
	dc.w		SCRN_RIGHT		;oddit cloud
	dc.w		SCRN_RIGHT		;oddit
	dc.w		SCRN_RIGHT		;mud man
	dc.w		SCRN_RIGHT		;spore
	dc.w		SCRN_RIGHT		;fern
	dc.w		SCRN_RIGHT		;big dino
	dc.w		SCRN_RIGHT		;slug
	dc.w		SCRN_RIGHT		;ball
	dc.w		SCRN_RIGHT		;big block
	dc.w		SCRN_RIGHT		;med block
	dc.w		SCRN_RIGHT		;sml block
	dc.w		SCRN_RIGHT		;geyser
	dc.w		SCRN_RIGHT		;poppy0
	dc.w		SCRN_RIGHT		;poppy1
	dc.w		SCRN_RIGHT		;poppy2
	dc.w		SCRN_RIGHT		;tower
	dc.w		SCRN_RIGHT+100		;elec
	dc.w		SCRN_RIGHT		;mingbot
	dc.w		SCRN_RIGHT		;falling rock
	dc.w		SCRN_RIGHT		;large ring
	dc.w		SCRN_RIGHT		;med ring
	dc.w		SCRN_RIGHT		;small ring

en_ystart::
;FOR AIR ENEMIES
;first number is minimum ypos
;second number is the maximum ypos
;starting ypos is the first number + (random number & 2nd number)
;FOR GROUND ENEMIES
;first number is ypos for object at bottom of screen
;second number is the maximum amount to move it up from the bottom position
;starting ypos is the first number - (random number & 2nd number)
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;pillbug
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;seymour
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;turborat
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;batskull
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big purple rock
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;med purple rock
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;sml purple rock
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big rock
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;med rock
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;small rock
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big crystal
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;med crystal A
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;med crystal B
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big star
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;med star
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;spinner
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;small scorpion
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big scorpion
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;buggy
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;cube
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;sphere
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;tri whole
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;tri 3 pieces
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;tri 2 pieces
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;tri 1 piece
	dc.w		SCRN_TOP,SCRN_TOP+100		;bat
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big burple
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;sml burple
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big bubble
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;sml bubble
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big pebble
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;med pebble
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;sml pebble
	dc.w		SCRN_TOP,SCRN_BOTTOM-80		;firebug
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;hummingbird
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;vulture
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;flower
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;gundino
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;firefly
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;small spider
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big spider
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;kilrun
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;sadmask
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;fish taxi
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;baby
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;small dino
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;robot
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;snake
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;glowbug
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big blue eye
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;big green eye
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;small blue eye
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;small green eye
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;dragon
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;desert robot boss
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;desert robot bottom
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;air robot boss
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;cave robot boss
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;wrd robot body
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;wrd robot tail
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;wrd robot r arm
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;wrd robot l arm
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;city robot body
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;city robot head
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;serpent body
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;serpent right wing
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;serpent left wing
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;quetzal body
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;quetzal back arm
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;quetzal front arm
	dc.w		SCRN_TOP,SCRN_BOTTOM-100		;quetzal tail
	dc.w		SCRN_BOTTOM-60,0			;skull ribs
	dc.w		SCRN_BOTTOM-60,255			;skull arm
	dc.w		SCRN_BOTTOM-60,255			;skull head
	dc.w		SCRN_BOTTOM-60,255			;skull neck
	dc.w		SCRN_BOTTOM-60,255			;skull back horn
	dc.w		SCRN_BOTTOM-60,255			;skull front horn
	dc.w		SCRN_BOTTOM-60,255			;skull nose horn
	dc.w		SCRN_TOP+40,0				;oddit cloud
	dc.w		SCRN_TOP+40,0				;oddit
	dc.w		SCRN_TOP+20,0				;mud man
	dc.w		SCRN_BOTTOM-98,15			;spore
	dc.w		SCRN_BOTTOM-62,31			;fern
	dc.w		SCRN_BOTTOM-304,31			;big dino
	dc.w		SCRN_BOTTOM-150,63			;slug
	dc.w		SCRN_TOP+120,127			;ball
	dc.w		SCRN_BOTTOM-200,255			;big block
	dc.w		SCRN_BOTTOM-200,255			;med block
	dc.w		SCRN_BOTTOM-140,255			;sml block
	dc.w		SCRN_BOTTOM-45,15			;geyser
	dc.w		SCRN_BOTTOM-128,127			;poppy0
	dc.w		SCRN_BOTTOM-96,127			;poppy1
	dc.w		SCRN_BOTTOM-160,127			;poppy2
	dc.w		SCRN_BOTTOM-320,0			;tower
	dc.w		SCRN_BOTTOM-310,0			;elec
	dc.w		SCRN_BOTTOM-200,0			;mingbot
	dc.w		SCRN_TOP-18,31				;falling rock
	dc.w		SCRN_TOP,255				;large ring
	dc.w		SCRN_TOP,255				;med ring
	dc.w		SCRN_TOP,255				;small ring
en_pt_table::
;points awarded for destroying each type of enemy
;these points are multiplied by 10 in the actual score
	dc.l		19					;pillbug
	dc.l		250					;seymour
	dc.l		200					;turborat
	dc.l		45					;batskull
	dc.l		20					;big purple rock
	dc.l		40					;med purple rock
	dc.l		60					;sml purple rock
	dc.l		30					;big rock
	dc.l		50					;med rock
	dc.l		100					;small rock
	dc.l		50					;big crystal
	dc.l		80					;med crystal A
	dc.l		80					;med crystal B
	dc.l		100					;big star
	dc.l		200					;med star
	dc.l		20					;spinner
	dc.l		41					;small scorpion
	dc.l		80					;big scorpion
	dc.l		33					;buggy
	dc.l		50					;cube
	dc.l		50					;sphere
	dc.l		30					;tri whole
	dc.l		30					;tri 3 pieces
	dc.l		30					;tri 2 pieces
	dc.l		30					;tri 1 piece
	dc.l		46					;bat
	dc.l		21					;big burple
	dc.l		34					;sml burple
	dc.l		20					;big bubble
	dc.l		20					;sml bubble
	dc.l		20					;big pebble
	dc.l		20					;med pebble
	dc.l		20					;sml pebble
	dc.l		30					;firebug
	dc.l		30					;hummingbird
	dc.l		30					;vulture
	dc.l		20					;flower
	dc.l		20					;gundino
	dc.l		20					;firefly
	dc.l		20					;small spider
	dc.l		20					;big spider
	dc.l		20					;kilrun
	dc.l		20					;sadmask
	dc.l		13					;fish taxi
	dc.l		111					;baby
	dc.l		6					;small dino
	dc.l		100					;robot
	dc.l		60					;snake
	dc.l		10					;glowbug
	dc.l		10					;big blue eye
	dc.l		10					;big green eye
	dc.l		10					;small blue eye
	dc.l		10					;small green eye
	dc.l		100					;dragon
	dc.l		5000					;desert robot boss
	dc.l		1000					;desert robot bottom
	dc.l		4000					;air robot boss
	dc.l		3000					;cave robot boss
	dc.l		6000					;wrd robot body
	dc.l		2000					;wrd robot tail
	dc.l		1000					;wrd robot r arm
	dc.l		1000					;wrd robot l arm
	dc.l		30000				;city robot body
	dc.l		10000				;city robot head
	dc.l		5000					;serpent body
	dc.l		3000					;serpent right wing
	dc.l		3000					;serpent left wing
	dc.l		6000					;quetzal body
	dc.l		2000					;quetzal back arm
	dc.l		2000					;quetzal front arm
	dc.l		4000					;quetzal tail
	dc.l		5000					;skull ribs
	dc.l		3000					;skull arm
	dc.l		8000					;skull head
	dc.l		1000					;skull neck
	dc.l		500					;skull back horn
	dc.l		400					;skull front horn
	dc.l		300					;skull nose horn
	dc.l		0					;oddit cloud
	dc.l		50000				;oddit
	dc.l		5000					;mud man
	dc.l		500					;spore
	dc.l		37					;fern
	dc.l		100					;big dino
	dc.l		17					;slug
	dc.l		40					;ball
	dc.l		0					;big block
	dc.l		0					;med block
	dc.l		0					;sml block
	dc.l		0					;geyser
	dc.l		10					;poppy0
	dc.l		8					;poppy1
	dc.l		15					;poppy2
	dc.l		0					;tower
	dc.l		0					;elec
	dc.l		1000					;mingbot
	dc.l		20					;falling rock
	dc.l		0					;large ring
	dc.l		0					;med ring
	dc.l		0					;small ring

health_table::
;starting health value for each enemy
	dc.w		1					;pillbug
	dc.w		8					;seymour
	dc.w		2					;turborat
	dc.w		2					;batskull
	dc.w		6					;big purple rock
	dc.w		3					;med purple rock
	dc.w		1					;sml purple rock
	dc.w		8					;big rock
	dc.w		4					;med rock
	dc.w		1					;small rock
	dc.w		9					;big crystal
	dc.w		1					;med crystal A
	dc.w		1					;med crystal B
	dc.w		8					;big star
	dc.w		4					;med star
	dc.w		2					;spinner
	dc.w		1					;small scorpion
	dc.w		80					;big scorpion
	dc.w		2					;buggy
	dc.w		8					;cube
	dc.w		4					;sphere
	dc.w		2					;tri whole
	dc.w		1					;tri 3 pieces
	dc.w		1					;tri 2 pieces
	dc.w		1					;tri 1 piece
	dc.w		4					;bat
	dc.w		7					;big burple
	dc.w		3					;sml burple
	dc.w		5					;big bubble
	dc.w		2					;sml bubble
	dc.w		6					;big pebble
	dc.w		4					;med pebble
	dc.w		1					;sml pebble
	dc.w		2					;firebug
	dc.w		1					;hummingbird
	dc.w		5					;vulture
	dc.w		1					;flower
	dc.w		2					;gundino
	dc.w		1					;firefly
	dc.w		1					;small spider
	dc.w		8					;big spider
	dc.w		6					;kilrun
	dc.w		5					;sadmask
	dc.w		4					;fish taxi
	dc.w		25					;baby
	dc.w		1					;small dino
	dc.w		70					;robot
	dc.w		5					;snake
	dc.w		2					;glowbug
	dc.w		6					;big blue eye
	dc.w		6					;big green eye
	dc.w		2					;small blue eye
	dc.w		2					;small green eye
	dc.w		18					;dragon
	dc.w		1366					;desert robot top
	dc.w		180					;desert robot bottom
	dc.w		1430					;air robot boss
	dc.w		1550					;cave robot boss
	dc.w		1300					;wrd robot body
	dc.w		400					;wrd robot tail
	dc.w		200					;wrd robot r arm
	dc.w		250					;wrd robot l arm
	dc.w		2000					;city robot body
	dc.w		500					;city robot head
	dc.w		1400					;serpent body
	dc.w		290					;serpent right wing
	dc.w		340					;serpent left wing
	dc.w		1500					;quetzal body
	dc.w		80					;quetzal back arm
	dc.w		99					;quetzal front arm
	dc.w		300					;quetzal tail
	dc.w		$FFFF				;skull ribs
	dc.w		150					;skull arm
	dc.w		1300					;skull head
	dc.w		$FFFF				;skull neck
	dc.w		210					;skull back horn
	dc.w		303					;skull front horn
	dc.w		49					;skull nose horn
	dc.w		$FFFF				;oddit cloud
	dc.w		5000					;oddit
	dc.w		1800					;mud man
	dc.w		11					;spore
	dc.w		1					;fern
	dc.w		46					;big dino
	dc.w		3					;slug
	dc.w		29					;ball
	dc.w		$FFFF				;big block
	dc.w		$FFFF				;med block
	dc.w		$FFFF				;sml block
	dc.w		$FFFF				;geyser
	dc.w		2					;poppy0
	dc.w		1					;poppy1
	dc.w		3					;poppy2
	dc.w		$FFFF				;tower
	dc.w		$FFFF				;elec
	dc.w		70					;mingbot
	dc.w		3					;falling rock
	dc.w		$FFFF				;large ring
	dc.w		$FFFF				;med ring
	dc.w		$FFFF				;small ring

en_dead_table::
;if first byte is:
;$FF - enemy does not split into new enemies
;$FE - enemy releases powerup
;$FD - enemy has dying animation
;any enemy number - the four bytes are used as a long
;up to four new enemies are created
	dc.b		$FF,$FF,$FF,$FF				;pillbug
	dc.b		$FF,$FF,$FF,$FF				;seymour
	dc.b		$FF,$FF,$FF,$FF				;turborat
	dc.b		$FE,$FF,$FF,$FF				;batskull
	dc.b		PROCKM,PROCKM,$FF,$FF			;big purple rock
	dc.b		PROCKS,PROCKS,$FF,$FF			;med purple rock
	dc.b		$FF,$FF,$FF,$FF				;sml purple rock
	dc.b		MEDROCK,MEDROCK,$FF,$FF			;big rock
	dc.b		SMLROCK,SMLROCK,$FF,$FF			;med rock
	dc.b		$FF,$FF,$FF,$FF				;small rock
	dc.b		MDCRYSA,MDCRYSB,$FF,$FF			;big crystal
	dc.b		$FF,$FF,$FF,$FF				;med crystal A
	dc.b		$FF,$FF,$FF,$FF				;med crystal B
	dc.b		MSTAR,MSTAR,$FF,$FF				;big star
	dc.b		$FF,$FF,$FF,$FF				;med star
	dc.b		$FF,$FF,$FF,$FF				;spinner
	dc.b		$FF,$FF,$FF,$FF				;small scorpion
	dc.b		SCORPSML,SCORPSML,SCORPSML,$FF	;big scorpion
	dc.b		$FE,$FF,$FF,$FF				;buggy
	dc.b		$FE,$FF,$FF,$FF				;cube
	dc.b		$FF,$FF,$FF,$FF				;sphere
	dc.b		$FF,$FF,$FF,$FF				;tri whole
	dc.b		$FF,$FF,$FF,$FF				;tri 3 pieces
	dc.b		$FF,$FF,$FF,$FF				;tri 2 pieces
	dc.b		$FF,$FF,$FF,$FF				;tri 1 piece
	dc.b		$FF,$FF,$FF,$FF				;bat
	dc.b		BURPLES,BURPLES,$FF,$FF			;big burple
	dc.b		$FF,$FF,$FF,$FF				;sml burple
	dc.b		BUBBLES,BUBBLES,$FF,$FF			;big bubble
	dc.b		$FF,$FF,$FF,$FF				;sml bubble
	dc.b		PEBBLEM,PEBBLEM,$FF,$FF			;big pebble
	dc.b		PEBBLES,PEBBLES,$FF,$FF			;med pebble
	dc.b		$FF,$FF,$FF,$FF				;sml pebble
	dc.b		$FF,$FF,$FF,$FF				;firebug
	dc.b		$FF,$FF,$FF,$FF				;hummingbird
	dc.b		$FF,$FF,$FF,$FF				;vulture
	dc.b		$FF,$FF,$FF,$FF				;flower
	dc.b		$FF,$FF,$FF,$FF				;gundino
	dc.b		$FF,$FF,$FF,$FF				;firefly
	dc.b		$FF,$FF,$FF,$FF				;small spider
	dc.b		SPIDERSM,SPIDERSM,$FF,$FF		;big spider
	dc.b		$FF,$FF,$FF,$FF				;kilrun
	dc.b		$FD,$FF,$FF,$FF				;sadmask
	dc.b		$FE,$FE,$FF,$FF				;fish taxi
	dc.b		$FF,$FF,$FF,$FF				;baby
	dc.b		$FF,$FF,$FF,$FF				;small dino
	dc.b		$FF,$FF,$FF,$FF				;robot
	dc.b		$FF,$FF,$FF,$FF				;snake
	dc.b		$FF,$FF,$FF,$FF				;glowbug
	dc.b		EYESMBL,EYESMBL,EYESMBL,EYESMBL	;big blue eye
	dc.b		EYESMGR,EYESMGR,EYESMBL,EYESMBL	;big green eye
	dc.b		$FF,$FF,$FF,$FF				;small blue eye
	dc.b		$FF,$FF,$FF,$FF				;small green eye
	dc.b		$FF,$FF,$FF,$FF				;dragon
	dc.b		$FF,$FF,$FF,$FF				;desert robot top
	dc.b		$FF,$FF,$FF,$FF				;desert robot bottom
	dc.b		$FF,$FF,$FF,$FF				;air robot boss
	dc.b		$FF,$FF,$FF,$FF				;cave robot boss
	dc.b		$FF,$FF,$FF,$FF				;wrd robot body
	dc.b		$FF,$FF,$FF,$FF				;wrd robot tail
	dc.b		$FF,$FF,$FF,$FF				;wrd robot r arm
	dc.b		$FF,$FF,$FF,$FF				;wrd robot l arm
	dc.b		$FF,$FF,$FF,$FF				;city robot body
	dc.b		$FF,$FF,$FF,$FF				;city robot head
	dc.b		$FF,$FF,$FF,$FF				;serpent body
	dc.b		$FF,$FF,$FF,$FF				;serpent right wing
	dc.b		$FF,$FF,$FF,$FF				;serpent left wing
	dc.b		$FF,$FF,$FF,$FF				;quetzal body
	dc.b		$FF,$FF,$FF,$FF				;quetzal back arm
	dc.b		$FF,$FF,$FF,$FF				;quetzal front arm
	dc.b		$FF,$FF,$FF,$FF				;quetzal tail
	dc.b		$FF,$FF,$FF,$FF				;skull ribs
	dc.b		$FF,$FF,$FF,$FF				;skull arm
	dc.b		$FF,$FF,$FF,$FF				;skull head
	dc.b		$FF,$FF,$FF,$FF				;skull neck
	dc.b		$FF,$FF,$FF,$FF				;skull back horn
	dc.b		$FF,$FF,$FF,$FF				;skull front horn
	dc.b		$FF,$FF,$FF,$FF				;skull nose horn
	dc.b		$FF,$FF,$FF,$FF				;oddit cloud
	dc.b		$FF,$FF,$FF,$FF				;oddit
	dc.b		$FF,$FF,$FF,$FF				;mud man
	dc.b		$FD,$FF,$FF,$FF				;spore
	dc.b		$FF,$FF,$FF,$FF				;fern
	dc.b		$FF,$FF,$FF,$FF				;big dino
	dc.b		$FE,$FF,$FF,$FF				;slug
	dc.b		$FF,$FF,$FF,$FF				;ball
	dc.b		$FF,$FF,$FF,$FF				;big block
	dc.b		$FF,$FF,$FF,$FF				;med block
	dc.b		$FF,$FF,$FF,$FF				;sml block
	dc.b		$FF,$FF,$FF,$FF				;geyser
	dc.b		$FF,$FF,$FF,$FF				;poppy0
	dc.b		$FE,$FF,$FF,$FF				;poppy1
	dc.b		TURBORAT,TURBORAT,TURBORAT,$FF	;poppy2
	dc.b		$FF,$FF,$FF,$FF				;tower
	dc.b		$FF,$FF,$FF,$FF				;elec
	dc.b		$FF,$FF,$FF,$FF				;mingbot
	dc.b		$FF,$FF,$FF,$FF				;falling rock
	dc.b		$FF,$FF,$FF,$FF				;large ring
	dc.b		$FF,$FF,$FF,$FF				;med ring
	dc.b		$FF,$FF,$FF,$FF				;small ring

en_expl::
;explosion type for each enemy, gets or'd with $FF00
	dc.b		PILL_EXP				;pillbug
	dc.b		SEYM_EXP				;seymour
	dc.b		EXP_C				;turborat
	dc.b		EXP_B				;batskull
	dc.b		EXP_D				;big purple rock
	dc.b		EXP_C				;med purple rock
	dc.b		EXP_B				;sml purple rock
	dc.b		EXP_C				;big rock
	dc.b		EXP_B				;med rock
	dc.b		EXP_A				;small rock
	dc.b		EXP_D				;big crystal
	dc.b		EXP_B				;med crystal A
	dc.b		EXP_B				;med crystal B
	dc.b		EXP_D				;big star
	dc.b		EXP_C				;med star
	dc.b		EXP_B				;spinner
	dc.b		EXP_B				;small scorpion
	dc.b		EXP_D				;big scorpion
	dc.b		EXP_C				;buggy
	dc.b		EXP_C				;cube
	dc.b		EXP_C				;sphere
	dc.b		EXP_C				;tri whole
	dc.b		EXP_C				;tri 3 pieces
	dc.b		EXP_C				;tri 2 pieces
	dc.b		EXP_C				;tri 1 piece
	dc.b		EXP_C				;bat
	dc.b		EXP_C				;big burple
	dc.b		EXP_C				;sml burple
	dc.b		EXP_C				;big bubble
	dc.b		EXP_C				;sml bubble
	dc.b		EXP_C				;big pebble
	dc.b		EXP_C				;med pebble
	dc.b		EXP_A				;sml pebble
	dc.b		EXP_C				;firebug
	dc.b		EXP_B				;hummingbird
	dc.b		EXP_C				;vulture
	dc.b		EXP_A				;flower
	dc.b		EXP_B				;gundino
	dc.b		EXP_B				;firefly
	dc.b		EXP_C				;small spider
	dc.b		EXP_D				;big spider
	dc.b		EXP_C				;kilrun
	dc.b		EXP_C				;sadmask
	dc.b		EXP_C				;fish taxi
	dc.b		EXP_D				;baby
	dc.b		EXP_C				;small dino
	dc.b		EXP_D				;robot
	dc.b		EXP_C				;snake
	dc.b		EXP_C				;glowbug
	dc.b		EXP_C				;big blue eye
	dc.b		EXP_C				;big green eye
	dc.b		EXP_C				;small blue eye
	dc.b		EXP_C				;small green eye
	dc.b		EXP_D				;dragon
	dc.b		EXP_F				;desert robot boss
	dc.b		EXP_C				;desert robot bottom
	dc.b		EXP_F				;air robot boss
	dc.b		EXP_F				;cave robot boss
	dc.b		EXP_F				;wrd robot body
	dc.b		EXP_D				;wrd robot tail
	dc.b		EXP_D				;wrd robot r arm
	dc.b		EXP_D				;wrd robot l arm
	dc.b		EXP_F				;city robot body
	dc.b		EXP_C				;city robot head
	dc.b		EXP_F				;serpent body
	dc.b		EXP_D				;serpent right wing
	dc.b		EXP_D				;serpent left wing
	dc.b		EXP_F				;quetzal body
	dc.b		EXP_C				;quetzal back arm
	dc.b		EXP_C				;quetzal front arm
	dc.b		EXP_D				;quetzal tail
	dc.b		EXP_C				;skull ribs
	dc.b		EXP_D				;skull arm
	dc.b		EXP_F				;skull head
	dc.b		EXP_C				;skull neck
	dc.b		EXP_C				;skull back horn
	dc.b		EXP_C				;skull front horn
	dc.b		EXP_B				;skull nose horn
	dc.b		EXP_D				;oddit cloud
	dc.b		EXP_F				;oddit
	dc.b		EXP_F				;mud man
	dc.b		EXP_D				;spore
	dc.b		EXP_B				;fern
	dc.b		EXP_D				;big dino
	dc.b		EXP_C				;slug
	dc.b		EXP_D				;ball
	dc.b		0					;big block
	dc.b		0					;med block
	dc.b		0					;sml block
	dc.b		0					;geyser
	dc.b		EXP_C				;poppy0
	dc.b		EXP_B				;poppy1
	dc.b		EXP_C				;poppy2
	dc.b		0					;tower
	dc.b		0					;elec
	dc.b		EXP_D				;mingbot
	dc.b		EXP_C				;falling rock
	dc.b		0					;large ring
	dc.b		0					;med ring
	dc.b		0					;small ring
	.even
en_ex_pos::
;add first number to enemy hpos when explosion starts
;add second number to enemy ypos when explosion starts
	dc.w		 -4, -8				;pillbug		16 x 16, exp 24 x 24	pillexp
	dc.w		 -4,-12				;seymour		48 x 52, exp 48 x 64	seymexp
	dc.w		  8, 10				;turborat		64 x 50, exp 48 x 40	C
	dc.w		  0,  5				;batskull		32 x 29, exp 32 x 24	B
	dc.w		 -8,-14				;b prp rk		64 x 50, exp 80 x 64	D
	dc.w		 -8,-14				;m prp rk		32 x 26, exp 48 x 40	C
	dc.w		  0, -3				;s prp rk		16 x 13, exp 16 x 16	B
	dc.w		  0,  7				;big rock		48 x 47, exp 48 x 40	C
	dc.w		  0, -1				;med rock		32 x 23, exp 32 x 24	B
	dc.w		  0, -5				;small rock	16 x 11, exp 16 x 16	A
	dc.w		 -8,  0				;big cryst	64 x 64, exp 80 x 64	D
	dc.w		  0, -1				;med cryst A	32 x 23, exp 32 x 24	B
	dc.w		  0, -1				;med cryst B	32 x 23, exp 32 x 24	B
	dc.w		 -8, -1				;big star		64 x 63, exp 80 x 64	D
	dc.w		 -8, -9				;med star		32 x 31, exp 48 x 40	C
	dc.w		  8, -7				;spinner		48 x 17, exp 32 x 24	B
	dc.w		  0, -8				;small scorp	32 x 16, exp 32 x 24	B
	dc.w		 56, 34				;big scorpion	192x 98, exp 80 x 64	D
	dc.w		  0,-13				;buggy		48 x 27, exp 48 x 40	C
	dc.w		  0, -1				;cube		48 x 39, exp 48 x 40	C
	dc.w		  0, -3				;sphere		48 x 37, exp 48 x 40	C
	dc.w		  0, -9				;tri whole	48 x 31, exp 48 x 40	C
	dc.w		  0, -9				;tri 3 pieces	48 x 31, exp 48 x 40	C
	dc.w		  0, -9				;tri 2 pieces	48 x 31, exp 48 x 40	C
	dc.w		  0, -9				;tri 1 piece	48 x 31, exp 48 x 40	C
	dc.w		  8, -8				;bat			64 x 32, exp 48 x 40	C
	dc.w		  8,  0				;big burple	64 x 40, exp 48 x 40	C
	dc.w		 -8,-20				;sml burple	32 x 20, exp 48 x 40	C
	dc.w		  8, -1				;big bubble	64 x 39, exp 48 x 40	C
	dc.w		 -8,-21				;sml bubble	32 x 19, exp 48 x 40	C
	dc.w		  8,  2				;big pebble	64 x 42, exp 48 x 40	C
	dc.w		  0,-16				;med pebble	48 x 24, exp 48 x 40	C
	dc.w		  0, -4				;sml pebble	16 x 12, exp 16 x 16	A
	dc.w		  0, 32				;firebug		48 x 55, exp 48 x 40	C
	dc.w		  0,  0				;hummingbird	32 x 24, exp 32 x 24	B
	dc.w		  8,  0				;vulture		64 x 47, exp 48 x 40	C
	dc.w		  0,  0				;flower		16 x 16, exp 16 x 16	A
	dc.w		  0, -2				;gundino		32 x 22, exp 32 x 24	B
	dc.w		  0, -3				;firefly		32 x 21, exp 32 x 24	B
	dc.w		  0,-12				;small spider	48 x 28, exp 48 x 40	C
	dc.w		  8, -1				;big spider	96 x 63, exp 80 x 64	D
	dc.w		  0,  7				;kilrun		48 x 47, exp 48 x 40	C
	dc.w		  0,  8				;sadmask		48 x 48, exp 48 x 40	C
	dc.w		  8,  2				;fish taxi	64 x 42, exp 48 x 40	C
	dc.w		 24, 25				;baby		128x 89, exp 80 x 64	D
	dc.w		  0,-20				;small dino	64 x 32, exp 48 x 40	C
	dc.w		 40, 32				;robot		160x 96, exp 80 x 64	D
	dc.w		 10,-10				;snake		96 x 11, exp 48 x 40	C
	dc.w		  0, -2				;glowbug		48 x 38, exp 48 x 40	C
	dc.w		  8, 12				;big blue eye	64 x 52, exp 48 x 40	C
	dc.w		  8, 12				;big green eye	64 x 52, exp 48 x 40	C
	dc.w		  8, -2				;sml blue eye	48 x 38, exp 48 x 40	C
	dc.w		  8, -2				;sml green eye	48 x 38, exp 48 x 40	C
	dc.w		  0,  0				;dragon		80 x 56, exp 80 x 64	D
	dc.w		 -8,-21				;des rbt top	192x139, exp 200x160	F
	dc.w		 -8, 24				;desert rbt b	32 x 64, exp 48 x 40	C
	dc.w		-20,-20				;air rbt boss	160x140, exp 200x160	F
	dc.w		 -8,  2				;cave rbt boss 192x162, exp 200x160	F
	dc.w		-20,-31				;wrd rbt body	160x129, exp 200x160	F
	dc.w		  0,-11				;wrd rbt tail	80 x 53, exp 80 x 64	D
	dc.w		  0,  3				;wrd rbt rarm	80 x 67, exp 80 x 64	D
	dc.w		 24, 22				;wrd rbt larm	128x 86, exp 80 x 64	D
	dc.w		-36, 14				;city rbt body	128x174, exp 200x160	F
	dc.w		  0,	 0				;city rbt head	48 x 40, exp 48 x 40	C
	dc.w		 12,-105				;serpent body	224x 63, exp 200x168	F
	dc.w		 40,  0				;serpent rw	160x 64, exp 80 x 64	D
	dc.w		 40,  3				;serpent lw	160x 67, exp 80 x 64	D
	dc.w		 -8,-80				;quetzal body	192x 80, exp 200x160	F
	dc.w		 16,-22				;quetzal b arm	80 x 18, exp 48 x 40	C
	dc.w		 16,-21				;quetzal f arm	80 x 19, exp 48 x 40	C
	dc.w		  8, 12				;quetzal tail	96 x 91, exp 80 x 64	D
	dc.w		  8,-24				;skull ribs	96 x 40, exp 80 x 64	D
	dc.w		  0, 16				;skull arm	80 x 80, exp 80 x 64	D
	dc.w		-60,-100				;skull head	80 x 44, exp 200x160	F
	dc.w		  0,-10				;skull neck	48 x 30, exp 48 x 40	C
	dc.w		  8,  4				;skull hornb	64 x 44, exp 48 x 40	C
	dc.w		 -8, -1				;skull hornf	32 x 39, exp 48 x 40	C
	dc.w		  0,  8				;skull hornn	32 x 32, exp 32 x 24	B
	dc.w		 16,109				;oddit cloud	112x173, exp 80 x 64	D
	dc.w		-44, 40				;oddit		112x200, exp 200x160	F
	dc.w		  0, 40				;mud man							F
	dc.w		 -8,-16				;spore		64 x 48, exp 80 x 64	D
	dc.w		  0,  4				;fern		32 x 28, exp 32 x 24	B
	dc.w		 56, 32				;big dino		192x 96, exp 80 x 64	D
	dc.w		  0,-21				;slug		48 x 19, exp 48 x 40	C
	dc.w		 -8,-16				;ball		64 x 48, exp 80 x 64	D
	dc.w		  0,  0				;big block						none
	dc.w		  0,  0				;med block						none
	dc.w		  0,  0				;sml block						none
	dc.w		  0,  0				;geyser							none
	dc.w		 -8, 17				;poppy0		32 x 57, exp 48 x 40	C
	dc.w		 -8, 24				;poppy1		16 x 48, exp 32 x 24	B
	dc.w		 -8, 34				;poppy2		32 x 74, exp 48 x 40	C
	dc.w		  0,  0				;tower							none
	dc.w		  0,  0				;elec							none
	dc.w		 24, 32				;mingbot		128x 96, exp 80 x 64	D
	dc.w		 16,  8				;falling rock	80 x 48, exp 48 x 40	C
	dc.w		  0,  0				;large ring						none
	dc.w		  0,  0				;med ring							none
	dc.w		  0,  0				;small ring						none
en_appear_flag::
;1 if enemy has animation for appearing
	dc.b		0					;pillbug
	dc.b		0					;seymour
	dc.b		0					;turborat
	dc.b		0					;batskull
	dc.b		0					;big purple rock
	dc.b		0					;med purple rock
	dc.b		0					;sml purple rock
	dc.b		0					;big rock
	dc.b		0					;med rock
	dc.b		0					;small rock
	dc.b		0					;big crystal
	dc.b		0					;med crystal A
	dc.b		0					;med crystal B
	dc.b		0					;big star
	dc.b		0					;med star
	dc.b		0					;spinner
	dc.b		0					;small scorpion
	dc.b		0					;big scorpion
	dc.b		0					;buggy
	dc.b		0					;cube
	dc.b		0					;sphere
	dc.b		0					;tri whole
	dc.b		0					;tri 3 pieces
	dc.b		0					;tri 2 pieces
	dc.b		0					;tri 1 piece
	dc.b		0					;bat
	dc.b		0					;big burple
	dc.b		0					;sml burple
	dc.b		0					;big bubble
	dc.b		0					;sml bubble
	dc.b		0					;big pebble
	dc.b		0					;med pebble
	dc.b		0					;sml pebble
	dc.b		0					;firebug
	dc.b		0					;hummingbird
	dc.b		1					;vulture
	dc.b		0					;flower
	dc.b		0					;gundino
	dc.b		0					;firefly
	dc.b		0					;small spider
	dc.b		0					;big spider
	dc.b		0					;kilrun
	dc.b		0					;sadmask
	dc.b		0					;fish taxi
	dc.b		0					;baby
	dc.b		0					;small dino
	dc.b		0					;robot
	dc.b		1					;snake
	dc.b		0					;glowbug
	dc.b		0					;big blue eye
	dc.b		0					;big green eye
	dc.b		0					;small blue eye
	dc.b		0					;small green eye
	dc.b		0					;dragon
	dc.b		0					;desert robot boss
	dc.b		0					;desert robot bottom
	dc.b		0					;air robot boss
	dc.b		0					;cave robot boss
	dc.b		0					;wrd robot body
	dc.b		0					;wrd robot tail
	dc.b		0					;wrd robot r arm
	dc.b		0					;wrd robot l arm
	dc.b		0					;city robot body
	dc.b		0					;city robot head
	dc.b		0					;serpent body
	dc.b		0					;serpent right wing
	dc.b		0					;serpent left wing
	dc.b		0					;quetzal body
	dc.b		0					;quetzal back arm
	dc.b		0					;quetzal front arm
	dc.b		0					;quetzal tail
	dc.b		0					;skull ribs
	dc.b		0					;skull arm
	dc.b		0					;skull head
	dc.b		0					;skull neck
	dc.b		0					;skull back horn
	dc.b		0					;skull front horn
	dc.b		0					;skull nose horn
	dc.b		0					;oddit cloud
	dc.b		0					;oddit
	dc.b		0					;mud man
	dc.b		0					;spore
	dc.b		0					;fern
	dc.b		0					;big dino
	dc.b		0					;slug
	dc.b		0					;ball
	dc.b		0					;big block
	dc.b		0					;med block
	dc.b		0					;sml block
	dc.b		0					;geyser
	dc.b		0					;poppy0
	dc.b		0					;poppy1
	dc.b		0					;poppy2
	dc.b		0					;tower
	dc.b		0					;elec
	dc.b		0					;mingbot
	dc.b		0					;falling rock
	dc.b		0					;large ring
	dc.b		0					;med ring
	dc.b		0					;small ring

	.even
en_shtch::
;when an enemy fires a shot, change to this type of enemy
	dc.w		PILLBUG				;pillbug
	dc.w		SEYMOUR				;seymour
	dc.w		TURBORAT				;turborat
	dc.w		BATSKULL				;batskull
	dc.w		PROCKB				;big purple rock
	dc.w		PROCKM				;med purple rock
	dc.w		PROCKS				;sml purple rock
	dc.w		BIGROCK				;big rock
	dc.w		MEDROCK				;med rock
	dc.w		SMLROCK				;sml rock
	dc.w		BIGCRYS				;big crystal
	dc.w		MDCRYSA				;med crystal A
	dc.w		MDCRYSB				;med crystal B
	dc.w		BSTAR				;big star
	dc.w		MSTAR				;med star
	dc.w		SPINNER				;spinner
	dc.w		SCORPSML				;small scorpion
	dc.w		SCORPBIG				;big scorpion
	dc.w		BUGGY				;buggy
	dc.w		CUBE					;cube
	dc.w		SPHERE				;sphere
	dc.w		TRI_3				;tri whole		changes to tri 3
	dc.w		TRI_2				;tri 3 pieces		changes to tri 2
	dc.w		TRI_1				;tri 2 pieces		changes to tri 1
	dc.w		TRI_1				;tri 1 piece
	dc.w		BAT					;bat
	dc.w		BURPLEB				;big burple
	dc.w		BURPLES				;sml burple
	dc.w		BUBBLEB				;big bubble
	dc.w		BUBBLES				;sml bubble
	dc.w		PEBBLEB				;big pebble
	dc.w		PEBBLEM				;med pebble
	dc.w		PEBBLES				;sml pebble
	dc.w		FBUG					;firebug
	dc.w		HUMM					;hummingbird
	dc.w		VULT					;vulture
	dc.w		FLOWER				;flower
	dc.w		GUNDINO				;gundino
	dc.w		FIREFLY				;firefly
	dc.w		SPIDERSM				;small spider
	dc.w		SPIDERBG				;big spider
	dc.w		KILRUN				;kilrun
	dc.w		SADMASK				;sadmask
	dc.w		FISHTX				;fish taxi
	dc.w		BABY					;baby
	dc.w		DINO_SM				;small dino
	dc.w		ROBOT				;robot
	dc.w		SNAKE				;snake
	dc.w		GLOWBUG				;glowbug
	dc.w		EYELGBL				;big blue eye
	dc.w		EYELGGR				;big green eye
	dc.w		EYESMBL				;small blue eye
	dc.w		EYESMGR				;small green eye
	dc.w		DRAGON				;dragon
	dc.w		DESRBTT				;desert robot boss
	dc.w		DESRBTB				;desert robot bottom
	dc.w		AIRROBOT				;air robot boss
	dc.w		CVROBOT				;cave robot boss
	dc.w		WRDBODY				;wrd robot body
	dc.w		WRDTAIL				;wrd robot tail
	dc.w		WRDRARM				;wrd robot r arm
	dc.w		WRDLARM				;wrd robot l arm
	dc.w		CITYBOD				;city robot body
	dc.w		CITYHD				;city robot head
	dc.w		SERPBODY				;serpent body
	dc.w		SERPWNGR 				;serpent right wing
	dc.w		SERPWNGL				;serpent left wing
	dc.w		QUETBODY				;quetzal body
	dc.w		QUETARMB				;quetzal back arm
	dc.w		QUETARMF				;quetzal front arm
	dc.w		QUETTAIL				;quetzal tail
	dc.w		SKULLRIB				;skull ribs
	dc.w		SKULLARM				;skull arm
	dc.w		SKULLHD				;skull head
	dc.w		SKULLNECK				;skull neck
	dc.w		SKULLHB				;skull back horn
	dc.w		SKULLHF				;skull front horn
	dc.w		SKULLHN				;skull nose horn
	dc.w		ODDITCLD				;oddit cloud
	dc.w		ODDIT				;oddit
	dc.w		MUDMAN				;mud man
	dc.w		SPORE				;spore
	dc.w		FERN					;fern
	dc.w		DINO					;big dino
	dc.w		SLUG					;slug
	dc.w		BALL					;ball
	dc.w		BLOCKB				;big block
	dc.w		BLOCKM				;med block
	dc.w		BLOCKS				;sml block
	dc.w		GEYSER				;geyser
	dc.w		POPPY0				;poppy0
	dc.w		POPPY1				;poppy1
	dc.w		POPPY2				;poppy2
	dc.w		TOWER				;tower
	dc.w		ELEC					;elec
	dc.w		MINGBOT				;mingbot
	dc.w		FALLROCK				;falling rock
	dc.w		RINGL0				;large ring
	dc.w		RINGM0				;med ring
	dc.w		RINGS0				;small ring

shstart::
;which attack anim steps to start shots ($FF for no shot)
	dc.b		$FF,$FF,$FF,$FF		;pillbug
	dc.b		  3,$FF,$FF,$FF		;seymour
	dc.b		  5,$FF,$FF,$FF		;turborat
	dc.b		  4,$FF,$FF,$FF		;batskull
	dc.b		$FF,$FF,$FF,$FF		;big purple rock
	dc.b		$FF,$FF,$FF,$FF		;med purple rock
	dc.b		$FF,$FF,$FF,$FF		;sml purple rock
	dc.b		$FF,$FF,$FF,$FF		;big rock
	dc.b		$FF,$FF,$FF,$FF		;med rock
	dc.b		$FF,$FF,$FF,$FF		;small rock
	dc.b		$FF,$FF,$FF,$FF		;big crystal
	dc.b		$FF,$FF,$FF,$FF		;med crystal A
	dc.b		$FF,$FF,$FF,$FF		;med crystal B
	dc.b		$FF,$FF,$FF,$FF		;big star
	dc.b		$FF,$FF,$FF,$FF		;med star
	dc.b		$FF,$FF,$FF,$FF		;spinner
	dc.b		  1,$FF,$FF,$FF		;small scorpion
	dc.b		  3,$FF,$FF,$FF		;big scorpion
	dc.b		  3,$FF,$FF,$FF		;buggy
	dc.b		  2,$FF,$FF,$FF		;cube
	dc.b		  4,  7, 10, 13		;sphere
	dc.b		  3,$FF,$FF,$FF		;tri whole
	dc.b		  3,$FF,$FF,$FF		;tri 3 pieces
	dc.b		  3,$FF,$FF,$FF		;tri 2 pieces
	dc.b		$FF,$FF,$FF,$FF		;tri 1 piece
	dc.b		$FF,$FF,$FF,$FF		;bat
	dc.b		$FF,$FF,$FF,$FF		;big burple
	dc.b		$FF,$FF,$FF,$FF		;sml burple
	dc.b		$FF,$FF,$FF,$FF		;big bubble
	dc.b		$FF,$FF,$FF,$FF		;sml bubble
	dc.b		$FF,$FF,$FF,$FF		;big pebble
	dc.b		$FF,$FF,$FF,$FF		;med pebble
	dc.b		$FF,$FF,$FF,$FF		;sml pebble
	dc.b		  4,$FF,$FF,$FF		;firebug
	dc.b		  2,$FF,$FF,$FF		;hummingbird
	dc.b		  4,$FF,$FF,$FF		;vulture
	dc.b		$FF,$FF,$FF,$FF		;flower
	dc.b		  2,$FF,$FF,$FF		;gundino
	dc.b		  2,$FF,$FF,$FF		;firefly
	dc.b		$FF,$FF,$FF,$FF		;small spider
	dc.b		$FF,$FF,$FF,$FF		;big spider
	dc.b		  4,$FF,$FF,$FF		;kilrun
	dc.b		  1,$FF,$FF,$FF		;sadmask
	dc.b		  6,$FF,$FF,$FF		;fish taxi
	dc.b		  3,$FF,$FF,$FF		;baby
	dc.b		$FF,$FF,$FF,$FF		;small dino
	dc.b		$FF,$FF,$FF,$FF		;robot
	dc.b		$FF,$FF,$FF,$FF		;snake
	dc.b		$FF,$FF,$FF,$FF		;glowbug
	dc.b		$FF,$FF,$FF,$FF		;big blue eye
	dc.b		$FF,$FF,$FF,$FF		;big green eye
	dc.b		$FF,$FF,$FF,$FF		;small blue eye
	dc.b		$FF,$FF,$FF,$FF		;small green eye
	dc.b		  2,  8,$FF,$FF		;dragon
	dc.b		  1,  4,  7,$FF		;desert robot boss
	dc.b		$FF,$FF,$FF,$FF		;desert robot bottom
	dc.b		  3,$FF,$FF,$FF		;air robot boss
	dc.b		  4, 13,$FF,$FF		;cave robot boss
	dc.b		$FF,$FF,$FF,$FF		;wrd robot body
	dc.b		  7,$FF,$FF,$FF		;wrd robot tail
	dc.b		  3,$FF,$FF,$FF		;wrd robot r arm
	dc.b		  9,$FF,$FF,$FF		;wrd robot l arm
	dc.b		  3,  7, 11, 15		;city robot body
	dc.b		  3,$FF,$FF,$FF		;city robot head
	dc.b		  5,$FF,$FF,$FF		;serpent body
	dc.b		$FF,$FF,$FF,$FF		;serpent right wing
	dc.b		$FF,$FF,$FF,$FF		;serpent left wing
	dc.b		  1, 10,$FF,$FF		;quetzal body
	dc.b		$FF,$FF,$FF,$FF		;quetzal back arm
	dc.b		$FF,$FF,$FF,$FF		;quetzal front arm
	dc.b		$FF,$FF,$FF,$FF		;quetzal tail
	dc.b		$FF,$FF,$FF,$FF		;skull ribs
	dc.b		$FF,$FF,$FF,$FF		;skull arm
	dc.b		  4,  7, 11, 15		;skull head
	dc.b		$FF,$FF,$FF,$FF		;skull neck
	dc.b		 10, 12,$FF,$FF		;skull back horn
	dc.b		  2,  4,$FF,$FF		;skull front horn
	dc.b		  6,  8,$FF,$FF		;skull nose horn
	dc.b		$FF,$FF,$FF,$FF		;oddit cloud
	dc.b		  2,  5,  8, 11		;oddit
	dc.b		  5,$FF,$FF,$FF		;mud man
	dc.b		  3,$FF,$FF,$FF		;spore
	dc.b		  2,$FF,$FF,$FF		;fern
	dc.b		  4,$FF,$FF,$FF		;big dino
	dc.b		  3,$FF,$FF,$FF		;slug
	dc.b		$FF,$FF,$FF,$FF		;ball
	dc.b		$FF,$FF,$FF,$FF		;big block
	dc.b		$FF,$FF,$FF,$FF		;med block
	dc.b		$FF,$FF,$FF,$FF		;sml block
	dc.b		$FF,$FF,$FF,$FF		;geyser
	dc.b		$FF,$FF,$FF,$FF		;poppy0
	dc.b		$FF,$FF,$FF,$FF		;poppy1
	dc.b		$FF,$FF,$FF,$FF		;poppy2
	dc.b		$FF,$FF,$FF,$FF		;tower
	dc.b		$FF,$FF,$FF,$FF		;elec
	dc.b		$FF,$FF,$FF,$FF		;mingbot
	dc.b		$FF,$FF,$FF,$FF		;falling rock
	dc.b		$FF,$FF,$FF,$FF		;large ring
	dc.b		$FF,$FF,$FF,$FF		;med ring
	dc.b		$FF,$FF,$FF,$FF		;small ring

atktable::
;random chance of attacking at beginning of new animation cycle for each type of enemy
;a number from this table goes into atk_chnc, if a random byte is less than this number, enemy attacks
;0 means enemy never attacks, high number means enemy attacks often
	dc.b		 77,108,137,171			;pillbug
	dc.b		 50, 70, 90,103			;seymour
	dc.b		 25, 62, 85,101			;turborat
	dc.b		171,111,132,142			;batskull
	dc.b		  0,  0,  0,  0			;big purple rock
	dc.b		  0,  0,  0,  0			;med purple rock
	dc.b		  0,  0,  0,  0			;sml purple rock
	dc.b		  0,  0,  0,  0			;big rock
	dc.b		  0,  0,  0,  0			;med rock
	dc.b		  0,  0,  0,  0			;small rock
	dc.b		  0,  0,  0,  0			;big crystal
	dc.b		  0,  0,  0,  0			;med crystal A
	dc.b		  0,  0,  0,  0			;med crystal B
	dc.b		  0,  0,  0,  0			;big star
	dc.b		  0,  0,  0,  0			;med star
	dc.b		 11, 31, 57, 97			;spinner
	dc.b		 89,111,131,151			;small scorpion
	dc.b		100,170,190,220			;big scorpion
	dc.b		 50, 80,100,111			;buggy
	dc.b		167,189,212,223			;cube
	dc.b		100,133,154,183			;sphere
	dc.b		 50, 61, 72, 83			;tri whole
	dc.b		110,121,122,133			;tri 3 pieces
	dc.b		140,141,142,143			;tri 2 pieces
	dc.b		  0,  0,  0,  0			;tri 1 piece
	dc.b		  0,  0,  0,  0			;bat
	dc.b		  0,  0,  0,  0			;big burple
	dc.b		  0,  0,  0,  0			;sml burple
	dc.b		  0,  0,  0,  0			;big bubble
	dc.b		  0,  0,  0,  0			;sml bubble
	dc.b		  0,  0,  0,  0			;big pebble
	dc.b		  0,  0,  0,  0			;med pebble
	dc.b		  0,  0,  0,  0			;sml pebble
	dc.b		 40, 61, 83,109			;firebug
	dc.b		100,130,148,170			;hummingbird
	dc.b		 19, 56, 93,133			;vulture
	dc.b		110,150,180,224			;flower
	dc.b		 90,112,145,175			;gundino
	dc.b		 95,120,155,175			;firefly
	dc.b		  0,  0,  0,  0			;small spider
	dc.b		  0,  0,  0,  0			;big spider
	dc.b		111,150,175,205			;kilrun
	dc.b		 77,119,139,159			;sadmask
	dc.b		104,127,145,199			;fish taxi
	dc.b		 78,130,154,185			;baby
	dc.b		  0,  0,  0,  0			;small dino
	dc.b		 61, 63, 68, 69			;robot
	dc.b		141,157,169,186			;snake
	dc.b		121,139,163,181			;glowbug
	dc.b		  0,  0,  0,  0			;big blue eye
	dc.b		  0,  0,  0,  0			;big green eye
	dc.b		  0,  0,  0,  0			;small blue eye
	dc.b		  0,  0,  0,  0			;small green eye
	dc.b		 80, 85, 91,123			;dragon
	dc.b		180,180,180,180			;desert robot boss
	dc.b		  0,  0,  0,  0			;desert robot bottom
	dc.b		230,230,230,230			;air robot boss
	dc.b		200,200,200,200			;cave robot boss
	dc.b		181,181,181,181			;wrd robot body
	dc.b		219,219,222,222			;wrd robot tail
	dc.b		230,230,230,230			;wrd robot r arm
	dc.b		205,204,203,202			;wrd robot l arm
	dc.b		120,125,125,122			;city robot body
	dc.b		210,216,218,212			;city robot head
	dc.b		217,218,219,220			;serpent body
	dc.b		  0,  0,  0,  0			;serpent right wing
	dc.b		  0,  0,  0,  0			;serpent left wing
	dc.b		221,221,221,221			;quetzal body
	dc.b		  0,  0,  0,  0			;quetzal back arm
	dc.b		  0,  0,  0,  0			;quetzal front arm
	dc.b		  0,  0,  0,  0			;quetzal tail
	dc.b		  0,  0,  0,  0			;skull ribs
	dc.b		153,153,153,153			;skull arm
	dc.b		110,118,115,116			;skull head
	dc.b		  0,  0,  0,  0			;skull neck
	dc.b		  0,  0,  0,  0			;skull back horn
	dc.b		  0,  0,  0,  0			;skull front horn
	dc.b		  0,  0,  0,  0			;skull nose horn
	dc.b		  0,  0,  0,  0			;oddit cloud
	dc.b		253,253,253,253			;oddit
	dc.b		246,246,246,246			;mud man
	dc.b		 49, 69, 99, 78			;spore
	dc.b		 77,111,141,175			;fern
	dc.b		230,211,218,215			;big dino
	dc.b		 89, 94, 99,121			;slug
	dc.b		  0,  0,  0,  0			;ball
	dc.b		  0,  0,  0,  0			;big block
	dc.b		  0,  0,  0,  0			;med block
	dc.b		  0,  0,  0,  0			;sml block
	dc.b		 87,110,131,162			;geyser
	dc.b		  0,  0,  0,  0			;poppy0
	dc.b		  0,  0,  0,  0			;poppy1
	dc.b		  0,  0,  0,  0			;poppy2
	dc.b		  0,  0,  0,  0			;tower
	dc.b		  0,  0,  0,  0			;elec
	dc.b		  0,  0,  0,  0			;mingbot
	dc.b		  0,  0,  0,  0			;falling rock
	dc.b		  0,  0,  0,  0			;large ring
	dc.b		  0,  0,  0,  0			;med ring
	dc.b		  0,  0,  0,  0			;small ring
en_moves::
;1 if enemy tracks player
;first number is when not attacking
;second number is when attacking
;third number is 0 if enemy should not move to the right while tracking, 1 if it should move to the right
;fourth number is 1 if enemy should move while scroll speed is 0 (game over, etc)
	dc.b		0,1,1,1					;pillbug
	dc.b		0,1,0,1					;seymour
	dc.b		0,1,1,1					;turborat
	dc.b		0,1,0,1					;batskull
	dc.b		0,0,0,1					;big purple rock
	dc.b		0,0,0,1					;med purple rock
	dc.b		0,0,0,1					;sml purple rock
	dc.b		0,0,0,1					;big rock
	dc.b		0,0,0,1					;med rock
	dc.b		0,0,0,1					;small rock
	dc.b		0,0,0,1					;big crystal
	dc.b		0,0,0,1					;med crystal A
	dc.b		0,0,0,1					;med crystal B
	dc.b		0,0,0,1					;big star
	dc.b		0,0,0,1					;med star
	dc.b		0,1,1,1					;spinner
	dc.b		0,1,0,1					;small scorpion
	dc.b		1,1,1,1					;big scorpion
	dc.b		0,1,0,1					;buggy
	dc.b		0,1,1,1					;cube
	dc.b		1,1,1,1					;sphere
	dc.b		1,1,1,1					;tri whole
	dc.b		1,1,1,1					;tri 3 pieces
	dc.b		1,1,1,1					;tri 2 pieces
	dc.b		1,1,1,1					;tri 1 piece
	dc.b		0,0,0,1					;bat
	dc.b		0,1,1,1					;big burple
	dc.b		0,1,1,1					;sml burple
	dc.b		0,1,1,1					;big bubble
	dc.b		1,1,1,1					;sml bubble
	dc.b		0,0,0,1					;big pebble
	dc.b		0,0,0,1					;med pebble
	dc.b		0,0,0,1					;sml pebble
	dc.b		1,1,0,1					;firebug
	dc.b		0,1,1,1					;hummingbird
	dc.b		1,1,1,1					;vulture
	dc.b		0,0,0,1					;flower
	dc.b		0,0,0,1					;gundino
	dc.b		0,0,0,1					;firefly
	dc.b		0,0,0,1					;small spider
	dc.b		0,0,0,1					;big spider
	dc.b		0,0,0,1					;kilrun
	dc.b		0,0,0,1					;sadmask
	dc.b		1,0,1,1					;fish taxi
	dc.b		1,1,1,1					;baby
	dc.b		0,0,0,1					;small dino
	dc.b		1,1,1,1					;robot
	dc.b		0,1,0,1					;snake
	dc.b		0,1,0,1					;glowbug
	dc.b		0,0,0,1					;big blue eye
	dc.b		0,0,0,1					;big green eye
	dc.b		0,0,0,1					;small blue eye
	dc.b		0,0,0,1					;small green eye
	dc.b		1,1,1,1					;dragon
	dc.b		1,0,1,0					;desert robot boss
	dc.b		0,0,0,0					;desert robot bottom
	dc.b		0,1,1,0					;air robot boss
	dc.b		1,0,1,0					;cave robot boss
	dc.b		1,0,1,0					;wrd robot body
	dc.b		0,0,0,0					;wrd robot tail
	dc.b		0,0,0,0					;wrd robot r arm
	dc.b		0,0,0,0					;wrd robot l arm
	dc.b		1,0,1,0					;city robot body
	dc.b		0,0,0,0					;city robot head
	dc.b		1,0,1,0					;serpent body
	dc.b		0,0,0,0					;serpent right wing
	dc.b		0,0,0,0					;serpent left wing
	dc.b		1,0,1,0					;quetzal body
	dc.b		0,0,0,0					;quetzal back arm
	dc.b		0,0,0,0					;quetzal front arm
	dc.b		0,0,0,0					;quetzal tail
	dc.b		0,0,0,0					;skull ribs
	dc.b		0,0,0,0					;skull arm
	dc.b		0,0,0,0					;skull head
	dc.b		0,0,0,0					;skull neck
	dc.b		0,0,0,0					;skull back horn
	dc.b		0,0,0,0					;skull front horn
	dc.b		0,0,0,0					;skull nose horn
	dc.b		0,0,0,0					;oddit cloud
	dc.b		0,0,0,0					;oddit
	dc.b		0,0,0,0					;mud man
	dc.b		0,0,0,0					;spore
	dc.b		0,0,0,0					;fern
	dc.b		0,0,0,1					;big dino
	dc.b		0,0,0,1					;slug
	dc.b		0,0,0,0					;ball
	dc.b		0,0,0,0					;big block
	dc.b		0,0,0,0					;med block
	dc.b		0,0,0,0					;sml block
	dc.b		0,0,0,0					;geyser
	dc.b		0,0,0,0					;poppy0
	dc.b		0,0,0,0					;poppy1
	dc.b		0,0,0,0					;poppy2
	dc.b		0,0,0,0					;tower
	dc.b		0,0,0,0					;elec
	dc.b		0,0,0,0					;mingbot
	dc.b		0,0,0,0					;falling rock
	dc.b		0,0,0,0					;large ring
	dc.b		0,0,0,0					;med ring
	dc.b		0,0,0,0					;small ring

track_xy::
;add first number to enemy xpos to get the X position that enemy aims for when tracking
;add second number to enemy ypos to get the Y position that enemy aims for when tracking
	dc.w		  8,	 4			;pillbug
	dc.w		160,  8			;seymour
	dc.w		132,	10			;turborat
	dc.w		100,	 4			;batskull
	dc.w		  0,  0			;big purple rock
	dc.w		  0,  0			;med purple rock
	dc.w		  0,  0			;sml purple rock
	dc.w		  0,	 0			;big rock
	dc.w		  0,	 0			;med rock
	dc.w		  0,	 0			;small rock
	dc.w		  0,  0			;big crystal
	dc.w		  0,  0			;med crystal A
	dc.w		  0,  0			;med crystal B
	dc.w		  0,  0			;big star
	dc.w		  0,  0			;med star
	dc.w		  3,  2			;spinner
	dc.w		  2,  2			;small scorpion
	dc.w		221,-44			;big scorpion
	dc.w		  6, 10			;buggy
	dc.w		200,  8			;cube
	dc.w		222, 12			;sphere
	dc.w		180,  2			;tri whole
	dc.w		  8,  4			;tri 3 pieces
	dc.w		  8,  4			;tri 2 pieces
	dc.w		  8,  4			;tri 1 piece
	dc.w		 14,  8			;bat
	dc.w		 26, 14			;big burple
	dc.w		 24,	10			;sml burple
	dc.w		 28,	 8			;big bubble
	dc.w		 22,	 8			;sml bubble
	dc.w		  0,	 0			;big pebble
	dc.w		  0,	 0			;med pebble
	dc.w		  0,	 0			;sml pebble
	dc.w		150,-36			;firebug
	dc.w		180, 12			;hummingbird
	dc.w		190, 16			;vulture
	dc.w		 14,  6			;flower
	dc.w		180, 10			;gundino
	dc.w		-100, 8			;firefly
	dc.w		  8,  6			;small spider
	dc.w		 10,-10			;big spider
	dc.w		191,-10			;kilrun
	dc.w		 12, 16			;sadmask
	dc.w		222,-28			;fish taxi
	dc.w		220,  8			;baby
	dc.w		 68, 10			;small dino
	dc.w		160,-40			;robot
	dc.w		 56,-18			;snake
	dc.w		 20, 10			;glowbug
	dc.w		 80, 20			;big blue eye
	dc.w		 80, 20			;big green eye
	dc.w		 80, 20			;small blue eye
	dc.w		 80, 20			;small green eye
	dc.w		180, 18			;dragon
	dc.w		118,-70			;desert robot boss
	dc.w		  0,  0			;desert robot bottom
	dc.w		170,-100			;air robot boss
	dc.w		190,-120			;cave robot boss
	dc.w		176,-100			;wrd robot body
	dc.w		  8, 16			;wrd robot tail
	dc.w		  8, 16			;wrd robot r arm
	dc.w		  8, 18			;wrd robot l arm
	dc.w		180,-50			;city robot body
	dc.w		180,-50			;city robot head
	dc.w		202,-22			;serpent body
	dc.w		  0,  0			;serpent right wing
	dc.w		  0,  0			;serpent left wing
	dc.w		198,-32			;quetzal body
	dc.w		  0,  0			;quetzal back arm
	dc.w		  0,  0			;quetzal front arm
	dc.w		  0,  0			;quetzal tail
	dc.w		  0,  0			;skull ribs
	dc.w		 50,-12			;skull arm
	dc.w		  2, 16			;skull head
	dc.w		  0,  0			;skull neck
	dc.w		 66, 30			;skull back horn
	dc.w		 29,  4			;skull front horn
	dc.w		 34,  8			;skull nose horn
	dc.w		  0,  0			;oddit cloud
	dc.w		 26, 20			;oddit
	dc.w		 10, 10			;mud man
	dc.w		  4,	10			;spore
	dc.w		 22,	28			;fern
	dc.w		 22, 28			;big dino
	dc.w		  0,  0			;slug
	dc.w		  0,  0			;ball
	dc.w		  0,  0			;big block
	dc.w		  0,  0			;med block
	dc.w		  0,  0			;sml block
	dc.w		 24, 40			;geyser
	dc.w		 23, 40			;poppy0
	dc.w		 22, 40			;poppy1
	dc.w		 23, 40			;poppy2
	dc.w		  0,  0			;tower
	dc.w		  0,  0			;elec
	dc.w		 22, 40			;mingbot
	dc.w		 80,  8			;falling rock
	dc.w		  0,  0			;large ring
	dc.w		  0,  0			;med ring
	dc.w		  0,  0			;small ring

en_mvlim::
;how many moves to do before changing direction
;$FF if limit should be ignored
	dc.b		$FF					;pillbug
	dc.b		$FF					;seymour
	dc.b		100					;turborat
	dc.b		$FF					;batskull
	dc.b		$FF					;big purple rock
	dc.b		$FF					;med purple rock
	dc.b		$FF					;sml purple rock
	dc.b		$FF					;big rock
	dc.b		$FF					;med rock
	dc.b		$FF					;small rock
	dc.b		$FF					;big crystal
	dc.b		$FF					;med crystal A
	dc.b		$FF					;med crystal B
	dc.b		$FF					;big star
	dc.b		$FF					;med star
	dc.b		70					;spinner
	dc.b		91					;small scorpion
	dc.b		$FF					;big scorpion
	dc.b		$FF					;buggy
	dc.b		$FF					;cube
	dc.b		$FF					;sphere
	dc.b		$FF					;tri whole
	dc.b		$FF					;tri 3 pieces
	dc.b		$FF					;tri 2 pieces
	dc.b		$FF					;tri 1 piece
	dc.b		$FF					;bat
	dc.b		$FF					;big burple
	dc.b		$FF					;sml burple
	dc.b		$FF					;big bubble
	dc.b		$FF					;sml bubble
	dc.b		$FF					;big pebble
	dc.b		$FF					;med pebble
	dc.b		$FF					;sml pebble
	dc.b		$FF					;firebug
	dc.b		$FF					;hummingbird
	dc.b		$FF					;vulture
	dc.b		$FF					;flower
	dc.b		$FF					;gundino
	dc.b		$FF					;firefly
	dc.b		32					;small spider
	dc.b		64					;big spider
	dc.b		$FF					;kilrun
	dc.b		$FF					;sadmask
	dc.b		$FF					;fish taxi
	dc.b		68					;baby
	dc.b		$FF					;small dino
	dc.b		70					;robot
	dc.b		$FF					;snake
	dc.b		$FF					;glowbug
	dc.b		55					;big blue eye
	dc.b		66					;big green eye
	dc.b		43					;small blue eye
	dc.b		41					;small green eye
	dc.b		57					;dragon
	dc.b		$FF					;desert robot boss
	dc.b		$FF					;desert robot bottom
	dc.b		$FF					;air robot boss
	dc.b		$FF					;cave robot boss
	dc.b		$FF					;wrd robot body
	dc.b		$FF					;wrd robot tail
	dc.b		$FF					;wrd robot r arm
	dc.b		$FF					;wrd robot l arm
	dc.b		$FF					;city robot body
	dc.b		$FF					;city robot head
	dc.b		$FF					;serpent body
	dc.b		$FF					;serpent right wing
	dc.b		$FF					;serpent left wing
	dc.b		$FF					;quetzal body
	dc.b		$FF					;quetzal back arm
	dc.b		$FF					;quetzal front arm
	dc.b		$FF					;quetzal tail
	dc.b		$FF					;skull ribs
	dc.b		$FF					;skull arm
	dc.b		$FF					;skull head
	dc.b		$FF					;skull neck
	dc.b		$FF					;skull back horn
	dc.b		$FF					;skull front horn
	dc.b		$FF					;skull nose horn
	dc.b		$FF					;oddit cloud
	dc.b		$FF					;oddit
	dc.b		$FF					;mud man
	dc.b		$FF					;spore
	dc.b		$FF					;fern
	dc.b		$FF					;big dino
	dc.b		$FF					;slug
	dc.b		$FF					;ball
	dc.b		$FF					;big block
	dc.b		$FF					;med block
	dc.b		$FF					;sml block
	dc.b		$FF					;geyser
	dc.b		$FF					;poppy0
	dc.b		$FF					;poppy1
	dc.b		$FF					;poppy2
	dc.b		$FF					;tower
	dc.b		$FF					;elec
	dc.b		$FF					;mingbot
	dc.b		$FF					;falling rock
	dc.b		$FF					;large ring
	dc.b		$FF					;med ring
	dc.b		$FF					;small ring

dir_chg_table::
;what enemy does when it reaches the edge of the screen
;0 = move off screen and disappear
;1 = change to random direction
;2 = change to random direction, set new move limits
;3 = change to opposite direction
;4 = stop
;5 = change to random direction, get new speed
	dc.b		0					;pillbug
	dc.b		0					;seymour
	dc.b		0					;turborat
	dc.b		0					;batskull
	dc.b		0					;big purple rock
	dc.b		0					;med purple rock
	dc.b		0					;sml purple rock
	dc.b		0					;big rock
	dc.b		0					;med rock
	dc.b		0					;small rock
	dc.b		0					;big crystal
	dc.b		0					;med crystal A
	dc.b		0					;med crystal B
	dc.b		0					;big star
	dc.b		0					;med star
	dc.b		0					;spinner
	dc.b		0					;small scorpion
	dc.b		1					;big scorpion
	dc.b		0					;buggy
	dc.b		5					;cube
	dc.b		5					;sphere
	dc.b		0					;tri whole
	dc.b		0					;tri 3 pieces
	dc.b		0					;tri 2 pieces
	dc.b		0					;tri 1 piece
	dc.b		0					;bat
	dc.b		0					;big burple
	dc.b		0					;sml burple
	dc.b		0					;big bubble
	dc.b		0					;sml bubble
	dc.b		0					;big pebble
	dc.b		0					;med pebble
	dc.b		0					;sml pebble
	dc.b		0					;firebug
	dc.b		0					;hummingbird
	dc.b		0					;vulture
	dc.b		0					;flower
	dc.b		0					;gundino
	dc.b		0					;firefly
	dc.b		0					;small spider
	dc.b		0					;big spider
	dc.b		0					;kilrun
	dc.b		0					;sadmask
	dc.b		0					;fish taxi
	dc.b		1					;baby
	dc.b		0					;small dino
	dc.b		1					;robot
	dc.b		0					;snake
	dc.b		0					;glowbug
	dc.b		0					;big blue eye
	dc.b		0					;big green eye
	dc.b		0					;small blue eye
	dc.b		0					;small green eye
	dc.b		1					;dragon
	dc.b		5					;desert robot boss
	dc.b		0					;desert robot bottom
	dc.b		5					;air robot boss
	dc.b		5					;cave robot boss
	dc.b		5					;wrd robot body
	dc.b		5					;wrd robot tail
	dc.b		5					;wrd robot r arm
	dc.b		5					;wrd robot l arm
	dc.b		5					;city robot body
	dc.b		5					;city robot head
	dc.b		5					;serpent body
	dc.b		5					;serpent right wing
	dc.b		5					;serpent left wing
	dc.b		5					;quetzal body
	dc.b		5					;quetzal back arm
	dc.b		5					;quetzal front arm
	dc.b		5					;quetzal tail
	dc.b		4					;skull ribs
	dc.b		4					;skull arm
	dc.b		4					;skull head
	dc.b		4					;skull neck
	dc.b		4					;skull back horn
	dc.b		4					;skull front horn
	dc.b		4					;skull nose horn
	dc.b		4					;oddit cloud
	dc.b		4					;oddit
	dc.b		4					;mud man
	dc.b		0					;spore
	dc.b		0					;fern
	dc.b		0					;big dino
	dc.b		0					;slug
	dc.b		3					;ball
	dc.b		0					;big block
	dc.b		0					;med block
	dc.b		0					;sml block
	dc.b		0					;geyser
	dc.b		0					;poppy0
	dc.b		0					;poppy1
	dc.b		0					;poppy2
	dc.b		0					;tower
	dc.b		0					;elec
	dc.b		0					;mingbot
	dc.b		0					;falling rock
	dc.b		0					;large ring
	dc.b		0					;med ring
	dc.b		0					;small ring

en_lf_lim::
;1 if enemy should be turned off when it reaches its left limit
	dc.b		1					;pillbug
	dc.b		1					;seymour
	dc.b		1					;turborat
	dc.b		1					;batskull
	dc.b		1					;big purple rock
	dc.b		1					;med purple rock
	dc.b		1					;sml purple rock
	dc.b		1					;big rock
	dc.b		1					;med rock
	dc.b		1					;small rock
	dc.b		1					;big crystal
	dc.b		1					;med crystal A
	dc.b		1					;med crystal B
	dc.b		1					;big star
	dc.b		1					;med star
	dc.b		1					;spinner
	dc.b		1					;small scorpion
	dc.b		0					;big scorpion
	dc.b		1					;buggy
	dc.b		0					;cube
	dc.b		0					;sphere
	dc.b		1					;tri whole
	dc.b		1					;tri 3 pieces
	dc.b		1					;tri 2 pieces
	dc.b		1					;tri 1 piece
	dc.b		1					;bat
	dc.b		1					;big burple
	dc.b		1					;sml burple
	dc.b		1					;big bubble
	dc.b		1					;sml bubble
	dc.b		1					;big pebble
	dc.b		1					;med pebble
	dc.b		1					;sml pebble
	dc.b		1					;firebug
	dc.b		1					;hummingbird
	dc.b		1					;vulture
	dc.b		1					;flower
	dc.b		1					;gundino
	dc.b		1					;firefly
	dc.b		1					;small spider
	dc.b		0					;big spider
	dc.b		1					;kilrun
	dc.b		1					;sadmask
	dc.b		1					;fish taxi
	dc.b		1					;baby
	dc.b		1					;small dino
	dc.b		0					;robot
	dc.b		1					;snake
	dc.b		1					;glowbug
	dc.b		1					;big blue eye
	dc.b		1					;big green eye
	dc.b		1					;small blue eye
	dc.b		1					;small green eye
	dc.b		0					;dragon
	dc.b		0					;desert robot boss
	dc.b		0					;desert robot bottom
	dc.b		0					;air robot boss
	dc.b		0					;cave robot boss
	dc.b		0					;wrd robot body
	dc.b		0					;wrd robot tail
	dc.b		0					;wrd robot r arm
	dc.b		0					;wrd robot l arm
	dc.b		0					;city robot body
	dc.b		0					;city robot head
	dc.b		0					;serpent body
	dc.b		0					;serpent right wing
	dc.b		0					;serpent left wing
	dc.b		0					;quetzal body
	dc.b		0					;quetzal back arm
	dc.b		0					;quetzal front arm
	dc.b		0					;quetzal tail
	dc.b		0					;skull ribs
	dc.b		0					;skull arm
	dc.b		0					;skull head
	dc.b		0					;skull neck
	dc.b		0					;skull back horn
	dc.b		0					;skull front horn
	dc.b		0					;skull nose horn
	dc.b		0					;oddit cloud
	dc.b		0					;oddit
	dc.b		0					;mud man
	dc.b		1					;spore
	dc.b		1					;fern
	dc.b		1					;big dino
	dc.b		1					;slug
	dc.b		1					;ball
	dc.b		1					;big block
	dc.b		1					;med block
	dc.b		1					;sml block
	dc.b		1					;geyser
	dc.b		1					;poppy0
	dc.b		1					;poppy1
	dc.b		1					;poppy2
	dc.b		1					;tower
	dc.b		1					;elec
	dc.b		1					;mingbot
	dc.b		1					;falling rock
	dc.b		1					;large ring
	dc.b		1					;med ring
	dc.b		1					;small ring

en_tractg::
;1 if enemy can be a target for the tracer weapon
	dc.b		1					;pillbug
	dc.b		1					;seymour
	dc.b		1					;turborat
	dc.b		1					;batskull
	dc.b		1					;big purple rock
	dc.b		1					;med purple rock
	dc.b		1					;sml purple rock
	dc.b		1					;big rock
	dc.b		1					;med rock
	dc.b		1					;small rock
	dc.b		1					;big crystal
	dc.b		1					;med crystal A
	dc.b		1					;med crystal B
	dc.b		1					;big star
	dc.b		1					;med star
	dc.b		1					;spinner
	dc.b		1					;small scorpion
	dc.b		1					;big scorpion
	dc.b		1					;buggy
	dc.b		1					;cube
	dc.b		1					;sphere
	dc.b		1					;tri whole
	dc.b		1					;tri 3 pieces
	dc.b		1					;tri 2 pieces
	dc.b		1					;tri 1 piece
	dc.b		1					;bat
	dc.b		1					;big burple
	dc.b		1					;sml burple
	dc.b		1					;big bubble
	dc.b		1					;sml bubble
	dc.b		1					;big pebble
	dc.b		1					;med pebble
	dc.b		1					;sml pebble
	dc.b		1					;firebug
	dc.b		1					;hummingbird
	dc.b		1					;vulture
	dc.b		1					;flower
	dc.b		1					;gundino
	dc.b		1					;firefly
	dc.b		1					;small spider
	dc.b		1					;big spider
	dc.b		1					;kilrun
	dc.b		1					;sadmask
	dc.b		1					;fish taxi
	dc.b		1					;baby
	dc.b		1					;small dino
	dc.b		1					;robot
	dc.b		1					;snake
	dc.b		1					;glowbug
	dc.b		1					;big blue eye
	dc.b		1					;big green eye
	dc.b		1					;small blue eye
	dc.b		1					;small green eye
	dc.b		1					;dragon
	dc.b		1					;desert robot top
	dc.b		0					;desert robot bottom
	dc.b		1					;air robot boss
	dc.b		1					;cave robot boss
	dc.b		1					;wrd robot body
	dc.b		0					;wrd robot tail
	dc.b		0					;wrd robot r arm
	dc.b		0					;wrd robot l arm
	dc.b		1					;city robot body
	dc.b		0					;city robot head
	dc.b		1					;serpent body
	dc.b		0					;serpent right wing
	dc.b		0					;serpent left wing
	dc.b		1					;quetzal body
	dc.b		0					;quetzal back arm
	dc.b		0					;quetzal front arm
	dc.b		0					;quetzal tail
	dc.b		0					;skull ribs
	dc.b		0					;skull arm
	dc.b		1					;skull head
	dc.b		0					;skull neck
	dc.b		0					;skull back horn
	dc.b		0					;skull front horn
	dc.b		0					;skull nose horn
	dc.b		0					;oddit cloud
	dc.b		1					;oddit
	dc.b		1					;mud man
	dc.b		1					;spore
	dc.b		1					;fern
	dc.b		1					;big dino
	dc.b		1					;slug
	dc.b		1					;ball
	dc.b		0					;big block
	dc.b		0					;med block
	dc.b		0					;sml block
	dc.b		0					;geyser
	dc.b		1					;poppy0
	dc.b		1					;poppy1
	dc.b		1					;poppy2
	dc.b		0					;tower
	dc.b		0					;elec
	dc.b		1					;mingbot
	dc.b		0					;falling rock
	dc.b		0					;large ring
	dc.b		0					;med ring
	dc.b		0					;small ring
	.even
en_alt_table::
;possible settings for en_altmv (enemy uses alternate moving animation if 1)
;one of the two bytes is chosen randomly when enemy is created
	dc.b		0,0					;pillbug
	dc.b		0,0					;seymour
	dc.b		0,0					;turborat
	dc.b		0,0					;batskull
	dc.b		0,1					;big purple rock
	dc.b		0,1					;med purple rock
	dc.b		0,1					;sml purple rock
	dc.b		0,1					;big rock
	dc.b		0,1					;med rock
	dc.b		0,1					;small rock
	dc.b		0,1					;big crystal
	dc.b		0,1					;med crystal A
	dc.b		0,1					;med crystal B
	dc.b		0,1					;big star
	dc.b		0,1					;med star
	dc.b		0,0					;spinner
	dc.b		0,0					;small scorpion
	dc.b		0,0					;big scorpion
	dc.b		0,0					;buggy
	dc.b		0,1					;cube
	dc.b		0,0					;sphere
	dc.b		0,0					;tri whole
	dc.b		0,0					;tri 3 pieces
	dc.b		0,0					;tri 2 pieces
	dc.b		0,0					;tri 1 piece
	dc.b		0,0					;bat
	dc.b		0,1					;big burple
	dc.b		0,1					;sml burple
	dc.b		0,1					;big bubble
	dc.b		0,1					;sml bubble
	dc.b		0,1					;big pebble
	dc.b		0,1					;med pebble
	dc.b		0,1					;sml pebble
	dc.b		0,0					;firebug
	dc.b		0,0					;hummingbird
	dc.b		0,0					;vulture
	dc.b		0,0					;flower
	dc.b		0,0					;gundino
	dc.b		0,0					;firefly
	dc.b		0,0					;small spider
	dc.b		0,0					;big spider
	dc.b		0,0					;kilrun
	dc.b		0,0					;sadmask
	dc.b		0,0					;fish taxi
	dc.b		0,0					;baby
	dc.b		0,0					;small dino
	dc.b		0,0					;robot
	dc.b		0,0					;snake
	dc.b		0,0					;glowbug
	dc.b		0,0					;big blue eye
	dc.b		0,0					;big green eye
	dc.b		0,0					;small blue eye
	dc.b		0,0					;small green eye
	dc.b		0,0					;dragon
	dc.b		0,0					;desert robot boss
	dc.b		0,0					;desert robot bottom
	dc.b		0,0					;air robot boss
	dc.b		0,0					;cave robot boss
	dc.b		0,0					;wrd robot body
	dc.b		0,0					;wrd robot tail
	dc.b		0,0					;wrd robot r arm
	dc.b		0,0					;wrd robot l arm
	dc.b		0,0					;city robot body
	dc.b		0,0					;city robot head
	dc.b		0,0					;serpent body
	dc.b		0,0					;serpent right wing
	dc.b		0,0					;serpent left wing
	dc.b		0,0					;quetzal body
	dc.b		0,0					;quetzal back arm
	dc.b		0,0					;quetzal front arm
	dc.b		0,0					;quetzal tail
	dc.b		0,0					;skull ribs
	dc.b		0,0					;skull arm
	dc.b		0,0					;skull head
	dc.b		0,0					;skull neck
	dc.b		0,0					;skull back horn
	dc.b		0,0					;skull front horn
	dc.b		0,0					;skull nose horn
	dc.b		0,0					;oddit cloud
	dc.b		0,0					;oddit
	dc.b		0,0					;mud man
	dc.b		0,0					;spore
	dc.b		0,0					;fern
	dc.b		0,0					;big dino
	dc.b		0,0					;slug
	dc.b		0,0					;ball
	dc.b		0,1					;big block
	dc.b		0,0					;med block
	dc.b		0,1					;sml block
	dc.b		0,0					;geyser
	dc.b		0,0					;poppy0
	dc.b		0,0					;poppy1
	dc.b		0,0					;poppy2
	dc.b		0,0					;tower
	dc.b		0,0					;elec
	dc.b		0,0					;mingbot
	dc.b		0,0					;falling rock
	dc.b		0,0					;large ring
	dc.b		0,0					;med ring
	dc.b		0,0					;small ring

en_spd_table::
;8 possible speeds for each type of enemy
	dc.b		1,2,1,1,1,1,1,2			;pillbug
	dc.b		1,2,1,1,2,1,1,2			;seymour			(formation speed)
	dc.b		1,1,2,2,3,3,4,4			;turborat
	dc.b		1,1,2,1,2,1,1,2			;batskull
	dc.b		1,2,2,1,3,3,2,1			;big purple rock
	dc.b		2,2,3,1,2,3,4,3			;med purple rock
	dc.b		2,1,3,4,2,5,3,4			;sml purple rock
	dc.b		1,2,2,1,3,3,2,1			;big rock
	dc.b		2,2,3,1,3,4,3,2			;med rock
	dc.b		1,2,3,4,3,4,2,5			;small rock
	dc.b		1,2,1,2,1,2,1,3			;big crystal
	dc.b		2,2,3,2,4,3,2,1			;med crystal A
	dc.b		2,1,4,2,3,2,3,3			;med crystal B
	dc.b		1,1,2,1,3,1,2,1			;big star
	dc.b		2,1,2,1,2,2,3,2			;med star
	dc.b		2,1,1,1,2,1,2,1			;spinner
	dc.b		2,1,2,2,2,2,3,1			;small scorpion
	dc.b		1,1,2,1,2,1,2,1			;big scorpion
	dc.b		1,2,1,3,2,1,1,2			;buggy			(formation speed)
	dc.b		1,2,1,2,2,1,1,1			;cube
	dc.b		1,2,1,1,2,1,2,1			;sphere
	dc.b		2,2,2,3,3,3,4,4			;tri whole
	dc.b		2,2,2,3,3,3,4,4			;tri 3 pieces
	dc.b		2,2,2,3,3,3,4,4			;tri 2 pieces
	dc.b		2,2,2,3,3,3,4,4			;tri 1 piece
	dc.b		1,1,1,1,1,2,2,1			;bat
	dc.b		1,2,1,2,1,1,2,1			;big burple
	dc.b		1,1,1,2,2,1,2,2			;sml burple
	dc.b		1,2,1,2,1,1,2,1			;big bubble
	dc.b		1,1,1,1,1,1,1,1			;sml bubble
	dc.b		1,1,1,1,1,2,2,3			;big pebble
	dc.b		1,1,1,2,2,2,3,3			;med pebble
	dc.b		1,2,2,2,3,3,4,4			;sml pebble
	dc.b		1,1,1,1,2,2,2,3			;firebug
	dc.b		2,2,2,3,3,3,1,4			;hummingbird
	dc.b		1,1,1,1,1,2,2,2			;vulture
	dc.b		1,1,1,1,1,1,1,1			;flower
	dc.b		1,1,1,1,1,1,2,2			;gundino
	dc.b		1,1,1,1,2,2,2,2			;firefly
	dc.b		1,1,1,1,2,2,3,2			;small spider
	dc.b		1,1,2,1,2,1,1,1			;big spider
	dc.b		1,1,1,1,1,1,2,2			;kilrun
	dc.b		1,1,1,1,1,1,1,2			;sadmask
	dc.b		1,1,1,2,1,1,1,2			;fish taxi
	dc.b		1,1,1,1,1,2,2,2			;baby
	dc.b		2,2,1,2,3,3,2,4			;small dino
	dc.b		1,1,1,1,1,1,1,1			;robot
	dc.b		1,1,1,1,1,1,2,1			;snake
	dc.b		1,1,1,1,2,2,2,3			;glowbug
	dc.b		1,1,1,1,1,1,2,2			;big blue eye
	dc.b		1,1,1,1,1,1,2,2			;big green eye
	dc.b		1,2,2,2,3,3,3,4			;small blue eye
	dc.b		1,2,2,2,3,3,3,4			;small green eye
	dc.b		1,1,1,2,2,1,1,2			;dragon
	dc.b		2,2,3,2,3,2,3,4			;desert robot boss
	dc.b		0,0,0,0,0,0,0,0			;desert robot bottom
	dc.b		3,4,3,2,3,4,3,2			;air robot boss
	dc.b		1,2,3,2,1,3,4,2			;cave robot boss
	dc.b		2,3,1,3,3,2,2,2			;wrd robot body
	dc.b		0,0,0,0,0,0,0,0			;wrd robot tail
	dc.b		0,0,0,0,0,0,0,0			;wrd robot r arm
	dc.b		0,0,0,0,0,0,0,0			;wrd robot l arm
	dc.b		1,2,3,2,2,3,2,2			;city robot body
	dc.b		0,0,0,0,0,0,0,0			;city robot head
	dc.b		2,1,2,1,2,3,3,2			;serpent body
	dc.b		0,0,0,0,0,0,0,0			;serpent right wing
	dc.b		0,0,0,0,0,0,0,0			;serpent left wing
	dc.b		2,2,1,2,2,1,2,3			;quetzal body
	dc.b		0,0,0,0,0,0,0,0			;quetzal back arm
	dc.b		0,0,0,0,0,0,0,0			;quetzal front arm
	dc.b		0,0,0,0,0,0,0,0			;quetzal tail
	dc.b		0,0,0,0,0,0,0,0			;skull ribs
	dc.b		0,0,0,0,0,0,0,0			;skull arm
	dc.b		0,0,0,0,0,0,0,0			;skull head
	dc.b		0,0,0,0,0,0,0,0			;skull neck
	dc.b		0,0,0,0,0,0,0,0			;skull back horn
	dc.b		0,0,0,0,0,0,0,0			;skull front horn
	dc.b		0,0,0,0,0,0,0,0			;skull nose horn
	dc.b		1,1,1,1,1,1,1,1			;oddit cloud
	dc.b		0,0,0,0,0,0,0,0			;oddit
	dc.b		0,0,0,0,0,0,0,0			;mud man
	dc.b		0,0,0,0,0,0,0,0			;spore
	dc.b		0,0,0,0,0,0,0,0			;fern
	dc.b		1,1,1,1,1,1,1,1			;big dino
	dc.b		1,1,2,1,1,1,1,2			;slug
	dc.b		2,2,2,3,3,3,4,5			;ball
	dc.b		1,1,1,1,1,1,1,1			;big block
	dc.b		1,1,1,1,1,1,1,1			;med block
	dc.b		1,1,1,1,1,1,1,1			;sml block
	dc.b		0,0,0,0,0,0,0,0			;geyser
	dc.b		3,3,3,3,3,3,3,3			;poppy0			speed when floating
	dc.b		5,5,5,5,5,5,5,5			;poppy1			speed when floating
	dc.b		0,0,0,0,0,0,0,0			;poppy2
	dc.b		0,0,0,0,0,0,0,0			;tower
	dc.b		0,0,0,0,0,0,0,0			;elec
	dc.b		0,0,0,0,0,0,0,0			;mingbot
	dc.b		6,6,6,6,6,6,6,6			;falling rock		speed when falling
	dc.b		1,1,1,1,1,1,1,1			;large ring
	dc.b		1,1,1,1,1,1,1,1			;med ring
	dc.b		1,1,1,1,1,1,1,1			;small ring

en_dir_table::
;32 possible directions for each type of enemy
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;pillbug
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;seymour
	dc.b		12,13,14,13,12,11,10, 9, 9,15,12,14,13,12,11,10,10,12,12,15,14,13,12,11,10,12,12,12,15,14,13,12	;turborat
	dc.b		12,15,14,13,12,11,10, 9, 8, 0,15,14,13,12,11,10, 9,12,12,15,14,13,12,11,10, 9,12,12,15,14,13,12	;batskull
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;big purple rock
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,12,13,11,13,12,11,12,12,13,12,12,11,12,13,14,12	;med purple rock
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,12,13,11,13,12,11,12,12,13,12,12,11,12,13,14,12	;sml purple rock
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;big rock
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,12,13,11,13,12,11,12,12,13,12,12,11,12,13,14,12	;med rock
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,12,13,11,13,12,11,12,12,13,12,12,11,12,13,14,12	;small rock
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;big crystal
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,12,13,11,13,12,11,12,12,13,12,12,11,12,13,14,12	;med crystal A
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,12,13,11,13,12,11,12,12,13,12,12,11,12,13,14,12	;med crystal B
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;big star
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,12,13,11,13,12,11,12,12,13,12,12,11,12,13,14,12	;med star
	dc.b		12,12,11,12,13,11,12,12,13,12,12,12,12,12,12,13,12,12,12,12,11,12,12,12,12,11,12,13,12,11,12,12	;spinner
	dc.b		12,12,11,12,13,11,10,12,13,12,12,12,12,10,12,13,12,12,12,12,11,12,14,12,12,11,12,13,12,11,14,12	;small scorpion
	dc.b		12,12,11,12,13,11,10,12,13,12,12,12,12,10,12,13,12,12,12,12,11,12,14,12,12,11,12,13,12,11,14,12	;big scorpion
	dc.b		12,13,14,13,12,11,10, 9, 9,15,12,14,13,12,11,10,10,12,12,15,14,13,12,11,10,12,12,12,15,14,13,12	;buggy
	dc.b		12,11,13,12,12,14,13,11,10,11,12,11,11,13,12,12,11,13,11,13,13,11,13,11,13,13,11,12,11,13,14,13	;cube
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;sphere
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;tri whole
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;tri 3 pieces
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;tri 2 pieces
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;tri 1 piece
	dc.b		 8, 8, 8,12, 8,12,13, 8, 9,10,10, 8,11,12,12,11,12,11,10,10, 9, 8, 8,13, 9,11,10,11,11,10, 8, 8	;bat
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;big burple
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;sml burple
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;big bubble
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;sml bubble
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;big pebble
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;med pebble
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;sml pebble
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;firebug
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;hummingbird
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;vulture
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;flower
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;gundino
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;firefly
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;small spider
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;big spider
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;kilrun
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;sadmask
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;fish taxi
	dc.b		12,11,13,14,15,14,13,11,10,11,10,11,11,13,14,15,11,13,11,13,13,11,13,11,13,13,11,11,11,13,14,13	;baby
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,11,11,11,13,13,13,11,11,13,13,10,14,12	;small dino
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;robot
	dc.b		12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,14,14,14,14,14,15,15,10,10, 9, 9, 8, 0,12,12	;snake
	dc.b		12,11,13,12,12,12,13,11,12,11,12,11,12,13,12,12,11,13,11,13,13,12,13,11,13,13,11,12,12,13,12,13	;glowbug
	dc.b		10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9	;big blue eye
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;big green eye
	dc.b		 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3	;small blue eye
	dc.b		 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7	;small green eye
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;dragon
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;desert robot boss
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;desert robot bottom
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;air robot boss
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;cave robot boss
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;wrd robot body
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;wrd robot tail
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;wrd robot r arm
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;wrd robot l arm
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;city robot body
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;city robot head
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;serpent body
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;serpent right wing
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;serpent left wing
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;quetzal body
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;quetzal back arm
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;quetzal front arm
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;quetzal tail
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;skull ribs
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;skull arm
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;skull head
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;skull neck
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;skull back horn
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;skull front horn
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;skull nose horn
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;oddit cloud
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;oddit
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;mud man
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;spore
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;fern
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;big dino
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;slug
	dc.b		 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8	;ball
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;big block
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;med block
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;sml block
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;geyser
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;poppy0
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;poppy1
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;poppy2
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;tower
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;elec
	dc.b		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15	;mingbot
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;falling rock (move left until it falls)
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;large ring
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;med ring
	dc.b		12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12	;small ring

en_pat::
;1 if enemy should use pattern to move around
	dc.b		1					;pillbug
	dc.b		1					;seymour
	dc.b		1					;turborat
	dc.b		1					;batskull
	dc.b		$FF					;big purple rock
	dc.b		$FF					;med purple rock
	dc.b		$FF					;sml purple rock
	dc.b		$FF					;big rock
	dc.b		$FF					;med rock
	dc.b		$FF					;small rock
	dc.b		$FF					;big crystal
	dc.b		$FF					;med crystal A
	dc.b		$FF					;med crystal B
	dc.b		$FF					;big star
	dc.b		$FF					;med star
	dc.b		$FF					;spinner
	dc.b		$FF					;small scorpion
	dc.b		$FF					;big scorpion
	dc.b		1					;buggy
	dc.b		$FF					;cube
	dc.b		1					;sphere
	dc.b		1					;tri whole
	dc.b		1					;tri 3 pieces
	dc.b		1					;tri 2 pieces
	dc.b		1					;tri 1 piece
	dc.b		$FF					;bat
	dc.b		$FF					;big burple
	dc.b		$FF					;sml burple
	dc.b		$FF					;big bubble
	dc.b		$FF					;sml bubble
	dc.b		$FF					;big pebble
	dc.b		$FF					;med pebble
	dc.b		$FF					;sml pebble
	dc.b		1					;firebug
	dc.b		$FF					;hummingbird
	dc.b		1					;vulture
	dc.b		$FF					;flower
	dc.b		$FF					;gundino
	dc.b		1					;firefly
	dc.b		$FF					;small spider
	dc.b		$FF					;big spider
	dc.b		$FF					;kilrun
	dc.b		$FF					;sadmask
	dc.b		$FF					;fish taxi
	dc.b		$FF					;baby
	dc.b		1					;small dino
	dc.b		$FF					;robot
	dc.b		$FF					;snake
	dc.b		$FF					;glowbug
	dc.b		$FF					;big blue eye
	dc.b		$FF					;big green eye
	dc.b		$FF					;small blue eye
	dc.b		$FF					;small green eye
	dc.b		$FF					;dragon
	dc.b		1					;desert robot boss
	dc.b		$FF					;desert robot bottom
	dc.b		1					;air robot boss
	dc.b		1					;cave robot boss
	dc.b		1					;wrd robot body
	dc.b		$FF					;wrd robot tail
	dc.b		$FF					;wrd robot r arm
	dc.b		$FF					;wrd robot l arm
	dc.b		1					;city robot body
	dc.b		$FF					;city robot head
	dc.b		1					;serpent body
	dc.b		$FF					;serpent right wing
	dc.b		$FF					;serpent left wing
	dc.b		1					;quetzal body
	dc.b		$FF					;quetzal back arm
	dc.b		$FF					;quetzal front arm
	dc.b		$FF					;quetzal tail
	dc.b		$FF					;skull ribs
	dc.b		$FF					;skull arm
	dc.b		$FF					;skull head
	dc.b		$FF					;skull neck
	dc.b		$FF					;skull back horn
	dc.b		$FF					;skull front horn
	dc.b		$FF					;skull nose horn
	dc.b		$FF					;oddit cloud
	dc.b		$FF					;oddit
	dc.b		$FF					;mud man
	dc.b		$FF					;spore
	dc.b		$FF					;fern
	dc.b		$FF					;big dino
	dc.b		$FF					;slug
	dc.b		$FF					;ball
	dc.b		$FF					;big block
	dc.b		$FF					;med block
	dc.b		$FF					;sml block
	dc.b		$FF					;geyser
	dc.b		$FF					;poppy0
	dc.b		$FF					;poppy1
	dc.b		$FF					;poppy2
	dc.b		$FF					;tower
	dc.b		$FF					;elec
	dc.b		$FF					;mingbot
	dc.b		$FF					;falling rock
	dc.b		$FF					;large ring
	dc.b		$FF					;med ring
	dc.b		$FF					;small ring
	.even
en_ptinf::
;pattern information for each type of enemy
;en_formx		starting x position (use enemy xpos if -1)
;en_formy		starting y position (use enemy ypos if -1)
;en_rad		radius
;en_theta		circling speed 
;en_formc		starting value for en_formc counter
;en_frmlm		limit for en_formc counter
;2 unused words
	dc.w		SCRN_RIGHT,	220,	66,	 2,	0,			(2048/2),		0,0			;pillbug
	dc.w		-1,			-1,	290,	 4,	(2048/4),		(2048/4),		0,0			;seymour
	dc.w		SCRN_RIGHT,	222,	140,	11,	0,			(2048/11),	0,0			;turborat
	dc.w		SCRN_RIGHT,	210,	216,	 8,	0,			(2048/8),		0,0			;batskull
	dcb.w	8,0															;big purple rock
	dcb.w	8,0															;med purple rock
	dcb.w	8,0															;sml purple rock
	dcb.w	8,0															;big rock
	dcb.w	8,0															;med rock
	dcb.w	8,0															;small rock
	dcb.w	8,0															;big crystal
	dcb.w	8,0															;med crystal A
	dcb.w	8,0															;med crystal B
	dcb.w	8,0															;big star
	dcb.w	8,0															;med star
	dcb.w	8,0															;spinner
	dcb.w	8,0															;small scorpion
	dcb.w	8,0															;big scorpion
	dc.w		SCRN_RIGHT,	232,	228,	 5,	0,			(2048/5),		0,0			;buggy
	dcb.w	8,0															;cube
	dc.w		(SCRN_RIGHT/2),252,	340,	 8,	0,			(2048/8),		0,0			;sphere
	dc.w		SCRN_RIGHT-120,250,	320,	 6,	0,			(2048/6),		0,0			;tri whole
	dc.w		SCRN_RIGHT-120,250,	320,	 6,	0,			(2048/6),		0,0			;tri 3 pieces
	dc.w		SCRN_RIGHT-120,250,	320,	 6,	0,			(2048/6),		0,0			;tri 2 pieces
	dc.w		SCRN_RIGHT-120,250,	320,	 6,	0,			(2048/6),		0,0			;tri 1 piece
	dcb.w	8,0															;bat
	dcb.w	8,0															;big burple
	dcb.w	8,0															;sml burple
	dcb.w	8,0															;big bubble
	dcb.w	8,0															;sml bubble
	dcb.w	8,0															;big pebble
	dcb.w	8,0															;med pebble
	dcb.w	8,0															;sml pebble
	dc.w		-1,			-1,	 80,	 8,	0,			(2048/8),		0,0			;firebug
	dcb.w	8,0															;hummingbird
	dc.w		-1,			-1,	 94,	 6,	0,			(2048/6),		0,0			;vulture
	dcb.w	8,0															;flower
	dcb.w	8,0															;gundino
	dc.w		SCRN_RIGHT,	226,	140,	 8,	0,			(2048/8),		0,0			;firefly
	dcb.w	8,0															;small spider
	dcb.w	8,0															;big spider
	dcb.w	8,0															;kilrun
	dcb.w	8,0															;sadmask
	dcb.w	8,0															;fish taxi
	dcb.w	8,0															;baby
	dc.w		SCRN_RIGHT,	230,	90,	 7,	(2048/7),		(2048/7),		0,0			;small dino
	dcb.w	8,0															;robot
	dcb.w	8,0															;snake
	dcb.w	8,0															;glowbug
	dcb.w	8,0															;big blue eye
	dcb.w	8,0															;big green eye
	dcb.w	8,0															;small blue eye
	dcb.w	8,0															;small green eye
	dcb.w	8,0															;dragon
	dc.w		SCRN_RIGHT+160,210,	160,	5,	0,			(2048/5),		0,0			;desert robot boss
	dcb.w	8,0															;desert robot bottom
	dc.w		SCRN_RIGHT+180,216,	180,	7,	0,			(2048/7),		0,0			;air robot
	dc.w		SCRN_RIGHT+180,172,	160,	3,	0,			(2048/3),		0,0			;cave robot
	dc.w		SCRN_RIGHT+180,220,	180,	5,	0,			(2048/5),		0,0			;wrd robot body
	dcb.w	8,0															;wrd robot tail
	dcb.w	8,0															;wrd robot r arm
	dcb.w	8,0															;wrd robot l arm
	dc.w		SCRN_RIGHT+150,170,	150,	6,	0,			(2048/6),		0,0			;city robot body
	dcb.w	8,0															;city robot head
	dc.w		SCRN_RIGHT+180,220,	180,	4,	0,			(2048/4),		0,0			;serpent body
	dcb.w	8,0															;serpent right wing
	dcb.w	8,0															;serpent left wing
	dc.w		SCRN_RIGHT+180,220,	180,	4,	0,			(2048/4),		0,0			;quetzal body
	dcb.w	8,0															;quetzal back arm
	dcb.w	8,0															;quetzal front arm
	dcb.w	8,0															;quetzal tail
	dcb.w	8,0															;skull ribs
	dcb.w	8,0															;skull arm
	dcb.w	8,0															;skull head
	dcb.w	8,0															;skull neck
	dcb.w	8,0															;skull back horn
	dcb.w	8,0															;skull front horn
	dcb.w	8,0															;skull nose horn
	dcb.w	8,0															;oddit cloud
	dcb.w	8,0															;oddit
	dcb.w	8,0															;mud man
	dcb.w	8,0															;spore
	dcb.w	8,0															;fern
	dcb.w	8,0															;big dino
	dcb.w	8,0															;slug
	dcb.w	8,0															;ball
	dcb.w	8,0															;big block
	dcb.w	8,0															;med block
	dcb.w	8,0															;sml block
	dcb.w	8,0															;geyser
	dcb.w	8,0															;poppy0
	dcb.w	8,0															;poppy1
	dcb.w	8,0															;poppy2
	dcb.w	8,0															;tower
	dcb.w	8,0															;elec
	dcb.w	8,0															;mingbot
	dcb.w	8,0															;falling rock
	dcb.w	8,0															;large ring
	dcb.w	8,0															;med ring
	dcb.w	8,0															;small ring


en_limit::
;left, right, top, bottom limits for each type of enemy
	dc.w		-16,	SCRN_RIGHT,	SCRN_TOP-32,	SCRN_BOTTOM			;pillbug
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-104,	SCRN_BOTTOM			;seymour
	dc.w		-94,	SCRN_RIGHT+100,SCRN_TOP-200,	SCRN_BOTTOM+80			;turborat
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-60,	SCRN_BOTTOM			;batskull
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-100,	SCRN_BOTTOM			;big purple rock
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-56,	SCRN_BOTTOM			;med purple rock
	dc.w		-16,	SCRN_RIGHT,	SCRN_TOP-28,	SCRN_BOTTOM			;sml purple rock
	dc.w		-48,	SCRN_RIGHT,	SCRN_TOP-94,	SCRN_BOTTOM			;big rock
	dc.w		-24,	SCRN_RIGHT,	SCRN_TOP-46,	SCRN_BOTTOM			;med rock
	dc.w		-12,	SCRN_RIGHT,	SCRN_TOP-22,	SCRN_BOTTOM			;small rock
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-128,	SCRN_BOTTOM			;big crystal
	dc.w		-24,	SCRN_RIGHT,	SCRN_TOP-46,	SCRN_BOTTOM			;med crystal A
	dc.w		-24,	SCRN_RIGHT,	SCRN_TOP-46,	SCRN_BOTTOM			;med crystal B
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-126,	SCRN_BOTTOM			;big star
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-62,	SCRN_BOTTOM			;med star
	dc.w		-36, SCRN_RIGHT,	SCRN_TOP-34,	SCRN_BOTTOM			;spinner
	dc.w		-24, SCRN_RIGHT,	SCRN_TOP-32,	SCRN_BOTTOM			;small scorpion
	dc.w		-192,SCRN_RIGHT-140,SCRN_TOP-20,	SCRN_BOTTOM-190		;big scorpion
	dc.w		-40, SCRN_RIGHT,	SCRN_TOP-54,	SCRN_BOTTOM			;buggy
	dc.w		-48,	SCRN_RIGHT,	SCRN_TOP-60,	SCRN_BOTTOM			;cube
	dc.w		-48,	SCRN_RIGHT,	SCRN_TOP-60,	SCRN_BOTTOM			;sphere
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-62,	SCRN_BOTTOM			;tri whole
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-62,	SCRN_BOTTOM			;tri 3 pieces
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-62,	SCRN_BOTTOM			;tri 2 pieces
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-62,	SCRN_BOTTOM			;tri 1 piece
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-14,	SCRN_BOTTOM			;bat
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-80,	SCRN_BOTTOM			;big burple
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-40,	SCRN_BOTTOM			;sml burple
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-78,	SCRN_BOTTOM			;big bubble
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-38,	SCRN_BOTTOM			;sml bubble
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-84,	SCRN_BOTTOM			;big pebble
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-48,	SCRN_BOTTOM			;med pebble
	dc.w		-16,	SCRN_RIGHT,	SCRN_TOP-24,	SCRN_BOTTOM			;sml pebble
	dc.w		-48,	SCRN_RIGHT,	SCRN_TOP-110,	SCRN_BOTTOM			;firebug
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-48,	SCRN_BOTTOM			;hummingbird
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-94,	SCRN_BOTTOM			;vulture
	dc.w		-16,	SCRN_RIGHT,	SCRN_TOP-32,	SCRN_BOTTOM			;flower
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-44,	SCRN_BOTTOM			;gundino
	dc.w		-24,	SCRN_RIGHT,	SCRN_TOP-42,	SCRN_BOTTOM			;firefly
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-56,	SCRN_BOTTOM			;small spider
	dc.w		-96,	SCRN_RIGHT,	SCRN_TOP-126,	SCRN_BOTTOM			;big spider
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-94,	SCRN_BOTTOM			;kilrun
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-96,	SCRN_BOTTOM			;sadmask
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-84,	SCRN_BOTTOM			;fish taxi
	dc.w		-128,SCRN_RIGHT-40,	SCRN_TOP-96,	SCRN_BOTTOM-120		;baby
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-64,	SCRN_BOTTOM			;small dino
	dc.w		  0,	SCRN_RIGHT-120,SCRN_TOP-10,	SCRN_BOTTOM-160		;robot
	dc.w		-96,	SCRN_RIGHT-40,	SCRN_TOP-108,	SCRN_BOTTOM-4			;snake
	dc.w		-48,	SCRN_RIGHT,	SCRN_TOP-76,	SCRN_BOTTOM			;glowbug
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-104,	SCRN_BOTTOM			;big blue eye
	dc.w		-64, SCRN_RIGHT,	SCRN_TOP-104,	SCRN_BOTTOM			;big green eye
	dc.w		-48, SCRN_RIGHT,	SCRN_TOP-78,	SCRN_BOTTOM			;small blue eye
	dc.w		-48, SCRN_RIGHT,	SCRN_TOP-78,	SCRN_BOTTOM			;small green eye
	dc.w		 10,	SCRN_RIGHT-80, SCRN_TOP,		SCRN_BOTTOM-120		;dragon
	dc.w		 20,	SCRN_RIGHT-170,SCRN_TOP,		SCRN_BOTTOM-160		;desert robot boss
	dc.w		 0,	SCRN_RIGHT,	0,			SCRN_BOTTOM			;desert robot bottom
	dc.w		 60,	SCRN_RIGHT-150,SCRN_TOP-20,	SCRN_BOTTOM-200		;air robot boss
	dc.w		 60,	SCRN_RIGHT-130,SCRN_TOP-80,	SCRN_BOTTOM-220		;cave robot boss
	dc.w		 12,	SCRN_RIGHT-130,SCRN_TOP-80,	SCRN_BOTTOM-140		;wrd robot body
	dc.w		  0,	SCRN_RIGHT,	SCRN_TOP-80,	SCRN_BOTTOM			;wrd robot tail
	dc.w		  0,	SCRN_RIGHT,	SCRN_TOP-100,	SCRN_BOTTOM			;wrd robot r arm
	dc.w		  0,	SCRN_RIGHT,	SCRN_TOP-100,	SCRN_BOTTOM			;wrd robot l arm
	dc.w		 70,	SCRN_RIGHT-150,SCRN_TOP-60,	SCRN_BOTTOM-230		;city robot body
	dc.w		 70,	SCRN_RIGHT,	SCRN_TOP-180,	SCRN_BOTTOM			;city robot head
	dc.w		 20, SCRN_RIGHT-212,SCRN_TOP-20,	SCRN_BOTTOM-100		;serpent body
	dc.w		 20, SCRN_RIGHT,	SCRN_TOP-20,	SCRN_BOTTOM-100		;serpent right wing
	dc.w		 20, SCRN_RIGHT,	SCRN_TOP-20,	SCRN_BOTTOM-100		;serpent left wing
	dc.w		 20, SCRN_RIGHT-156,SCRN_TOP-30,	SCRN_BOTTOM-170		;quetzal body
	dc.w		-99, SCRN_RIGHT+80,	SCRN_TOP-80,	SCRN_BOTTOM+200		;quetzal back arm
	dc.w		-99, SCRN_RIGHT+80,	SCRN_TOP-80,	SCRN_BOTTOM+200		;quetzal front arm
	dc.w		-99, SCRN_RIGHT+150,SCRN_TOP-100,	SCRN_BOTTOM+200		;quetzal tail
	dc.w		274,	SCRN_RIGHT,	0,			SCRN_BOTTOM			;skull ribs
	dc.w		274,	SCRN_RIGHT,	0,			SCRN_BOTTOM			;skull arm
	dc.w		274,	SCRN_RIGHT,	0,			SCRN_BOTTOM			;skull head
	dc.w		274,	SCRN_RIGHT,	0,			SCRN_BOTTOM			;skull neck
	dc.w		274,	SCRN_RIGHT,	0,			SCRN_BOTTOM			;skull back horn
	dc.w		274,	SCRN_RIGHT,	0,			SCRN_BOTTOM			;skull front horn
	dc.w		274,	SCRN_RIGHT,	0,			SCRN_BOTTOM			;skull nose horn
	dc.w		280,	SCRN_RIGHT,	SCRN_TOP-80,	SCRN_BOTTOM-20			;oddit cloud
	dc.w		270,	SCRN_RIGHT,	SCRN_TOP-80,	SCRN_BOTTOM-20			;oddit
	dc.w		280,	SCRN_RIGHT,	SCRN_TOP-10,	SCRN_BOTTOM-200		;mud man
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-50,	SCRN_BOTTOM			;spore
	dc.w		-24,	SCRN_RIGHT,	SCRN_TOP-50,	SCRN_BOTTOM			;fern
	dc.w		-192,SCRN_RIGHT,	SCRN_TOP-192,	SCRN_BOTTOM			;big dino
	dc.w		-48,	SCRN_RIGHT,	SCRN_TOP-38,	SCRN_BOTTOM			;slug
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP,		SCRN_BOTTOM-150		;ball
	dc.w		-256,SCRN_RIGHT,	SCRN_TOP-100,	SCRN_BOTTOM			;big block
	dc.w		-192,SCRN_RIGHT,	SCRN_TOP-100,	SCRN_BOTTOM			;med block
	dc.w		-128,SCRN_RIGHT,	SCRN_TOP-100,	SCRN_BOTTOM			;sml block
	dc.w		-48,	SCRN_RIGHT,	SCRN_TOP-100,	SCRN_BOTTOM			;geyser
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-128,	SCRN_BOTTOM			;poppy0
	dc.w		-16,	SCRN_RIGHT,	SCRN_TOP-96,	SCRN_BOTTOM			;poppy1
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-160,	SCRN_BOTTOM			;poppy2
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-320,	SCRN_BOTTOM			;tower
	dc.w		-112,SCRN_RIGHT,	SCRN_TOP-32,	SCRN_BOTTOM			;elec
	dc.w		-128,SCRN_RIGHT,	SCRN_TOP-122,	SCRN_BOTTOM			;mingbot
	dc.w		-40,	SCRN_RIGHT,	SCRN_TOP-120,	SCRN_BOTTOM			;falling rock
	dc.w		-80,	SCRN_RIGHT,	SCRN_TOP-272,	SCRN_BOTTOM			;large ring
	dc.w		-64,	SCRN_RIGHT,	SCRN_TOP-176,	SCRN_BOTTOM			;med ring
	dc.w		-32,	SCRN_RIGHT,	SCRN_TOP-128,	SCRN_BOTTOM			;small ring
en_coladd::
;add to enemy xpos to get left edge for collision detection
;add to enemy ypos to get top edge for collision detection
	dc.w		  0,	 0			;pillbug
	dc.w		  0,  0			;seymour
	dc.w		  4,	11			;turborat
	dc.w		  0,	 0			;batskull
	dc.w		  7, 10			;big purple rock
	dc.w		  3,  6			;med purple rock
	dc.w		  1,  1			;sml purple rock
	dc.w		  1,	 2			;big rock
	dc.w		  1,	 2			;med rock
	dc.w		  0,	 0			;small rock
	dc.w		  7,  2			;big crystal
	dc.w		  2,  2			;med crystal A
	dc.w		  2,  2			;med crystal B
	dc.w		  8,  4			;big star
	dc.w		  2,  2			;med star
	dc.w		  0,  0			;spinner
	dc.w		  1,  5			;small scorpion
	dc.w		 11, 86			;big scorpion
	dc.w		  1,  2			;buggy
	dc.w		  4,  2			;cube
	dc.w		 14, 12			;sphere
	dc.w		  4,  1			;tri whole
	dc.w		  3,  8			;tri 3 pieces
	dc.w		  3, 16			;tri 2 pieces
	dc.w		  2, 32			;tri 1 piece
	dc.w		  4,  3			;bat
	dc.w		  8, 14			;big burple
	dc.w		  4,	 8			;sml burple
	dc.w		  4,	 6			;big bubble
	dc.w		  2,	 4			;sml bubble
	dc.w		  2,	 5			;big pebble
	dc.w		  2,	 2			;med pebble
	dc.w		  1,	 1			;sml pebble
	dc.w		  8, 10			;firebug
	dc.w		  0,  0			;hummingbird
	dc.w		 10, 12			;vulture
	dc.w		  0,  0			;flower
	dc.w		  0,  0			;gundino
	dc.w		  0,  0			;firefly
	dc.w		  2,  2			;small spider
	dc.w		  8, 10			;big spider
	dc.w		  2,  8			;kilrun
	dc.w		  2,  6			;sadmask
	dc.w		  8, 16			;fish taxi
	dc.w		 30, 12			;baby
	dc.w		  8, 16			;small dino
	dc.w		 40, 40			;robot
	dc.w		  6,	10			;snake
	dc.w		  5, 10			;glowbug
	dc.w		  4, 12			;big blue eye
	dc.w		  4, 12			;big green eye
	dc.w		  3,  8			;small blue eye
	dc.w		  3,  8			;small green eye
	dc.w		  5, 25			;dragon
	dc.w		 18, 20			;desert robot boss
	dc.w		  7,  8			;desert robot bottom
	dc.w		 39, 80			;air robot boss
	dc.w		 45,  9			;cave robot boss
	dc.w		 56, 20			;wrd robot body
	dc.w		 12, 10			;wrd robot tail
	dc.w		 10, 10			;wrd robot r arm
	dc.w		 10, 10			;wrd robot l arm
	dc.w		 20, 16			;city robot body
	dc.w		  6, 21			;city robot head
	dc.w		 22, 60			;serpent body
	dc.w		 32, 20			;serpent right wing
	dc.w		 35, 26			;serpent left wing
	dc.w		 30, 38			;quetzal body
	dc.w		  6,  8			;quetzal back arm
	dc.w		  6,  8			;quetzal front arm
	dc.w		 10,  6			;quetzal tail
	dc.w		  4, 32			;skull ribs
	dc.w		  9,  8			;skull arm
	dc.w		 11,  7			;skull head
	dc.w		  4,  8			;skull neck
	dc.w		 16,  8			;skull back horn
	dc.w		  9,  8			;skull front horn
	dc.w		  2,  4			;skull nose horn
	dc.w		999,999			;oddit cloud
	dc.w		 20, 50			;oddit
	dc.w		 22,	10			;mud man
	dc.w		  4,	10			;spore
	dc.w		  2,	 6			;fern
	dc.w		 12, 18			;big dino
	dc.w		  2,  8			;slug
	dc.w		  2,  4			;ball
	dc.w		  8,  6			;big block
	dc.w		  8,  6			;med block
	dc.w		  8,  6			;sml block
	dc.w		 10, 10			;geyser
	dc.w		  3,  6			;poppy0
	dc.w		  2,  6			;poppy1
	dc.w		  3,  6			;poppy2
	dc.w		  0,  0			;tower
	dc.w		  4,  6			;elec
	dc.w		 12, 20			;mingbot
	dc.w		 10,  8			;falling rock
	dc.w		999,999			;large ring
	dc.w		999,999			;med ring
	dc.w		999,999			;small ring

en_collwh::
;width of each type of enemy for collision detection
;height in half lines of each enemy type for collision detection
;both can be different than the size of the enemy in pixels
	dc.w		 16,	32			;pillbug
	dc.w		 40,102			;seymour
	dc.w		 54,	79			;turborat
	dc.w		 32,	56			;batskull
	dc.w		 50, 84			;big purple rock
	dc.w		 26, 49			;med purple rock
	dc.w		 14, 24			;sml purple rock
	dc.w		 42,	80			;big rock
	dc.w		 20,	40			;med rock
	dc.w		 10,	18			;small rock
	dc.w		 51,110			;big crystal
	dc.w		 20, 41			;med crystal A
	dc.w		 20, 41			;med crystal B
	dc.w		 50,117			;big star
	dc.w		 25, 55			;med star
	dc.w		 36, 33			;spinner
	dc.w		 22, 26			;small scorpion
	dc.w		174, 80			;big scorpion
	dc.w		 38, 49			;buggy
	dc.w		 46,	73			;cube
	dc.w		 34,	56			;sphere
	dc.w		 34, 60			;tri whole
	dc.w		 35, 54			;tri 3 pieces
	dc.w		 35, 46			;tri 2 pieces
	dc.w		 35, 30			;tri 1 piece
	dc.w		 56,	56			;bat
	dc.w		 48, 52			;big burple
	dc.w		 20,	28			;sml burple
	dc.w		 64,	77			;big bubble
	dc.w		 32,	34			;sml bubble
	dc.w		 56,	76			;big pebble
	dc.w		 36,	40			;med pebble
	dc.w		 14,	20			;sml pebble
	dc.w		 36, 90			;firebug
	dc.w		 32, 48			;hummingbird
	dc.w		 46, 74			;vulture
	dc.w		 16, 16			;flower
	dc.w		 32, 22			;gundino
	dc.w		 24, 21			;firefly
	dc.w		 34, 52			;small spider
	dc.w		 80,106			;big spider
	dc.w		 36, 84			;kilrun
	dc.w		 36, 85			;sadmask
	dc.w		 50, 54			;fish taxi
	dc.w		 78,152			;baby
	dc.w		 47, 36			;small dino
	dc.w		110,132			;robot
	dc.w		 44,	72			;snake
	dc.w		 40, 58			;glowbug
	dc.w		 56, 90			;big blue eye
	dc.w		 56, 90			;big green eye
	dc.w		 41, 66			;small blue eye
	dc.w		 41, 66			;small green eye
	dc.w		 68, 78			;dragon
	dc.w		162,120			;desert robot boss
	dc.w		 19,118			;desert robot bottom
	dc.w		110,100			;air robot boss
	dc.w		 96,300			;cave robot boss
	dc.w		118,230			;wrd robot body
	dc.w		 60, 98			;wrd robot tail
	dc.w		 60,118			;wrd robot r arm
	dc.w		108,150			;wrd robot l arm
	dc.w		100,320			;city robot body
	dc.w		 37, 61			;city robot head
	dc.w		188, 40			;serpent body
	dc.w		117,120			;serpent right wing
	dc.w		108, 96			;serpent left wing
	dc.w		120,100			;quetzal body
	dc.w		 64, 28			;quetzal back arm
	dc.w		 64, 28			;quetzal front arm
	dc.w		 80,110			;quetzal tail
	dc.w		 90, 30			;skull ribs
	dc.w		 94, 53			;skull arm
	dc.w		 66, 94			;skull head
	dc.w		 38, 40			;skull neck
	dc.w		 40, 54			;skull back horn
	dc.w		 34, 44			;skull front horn
	dc.w		 27, 34			;skull nose horn
	dc.w		  0,  0			;oddit cloud
	dc.w		 82,346			;oddit
	dc.w		 90,390			;mud man
	dc.w		 56,	82			;spore
	dc.w		 20,	48			;fern
	dc.w		140,162			;big dino
	dc.w		 48, 22			;slug
	dc.w		 57, 88			;ball
	dc.w		242,260			;big block
	dc.w		176,200			;med block
	dc.w		114,116			;sml block
	dc.w		 30, 30			;geyser
	dc.w		 26,116			;poppy0
	dc.w		 12, 84			;poppy1
	dc.w		 26,148			;poppy2
	dc.w		  0,  0			;tower
	dc.w		180, 24			;elec
	dc.w		108,156			;mingbot
	dc.w		 26,142			;falling rock
	dc.w		  0,  0			;large ring
	dc.w		  0,  0			;med ring
	dc.w		  0,  0			;small ring

en_ht_dw::
;height for object O_HEIGHT
;O_DWIDTH and O_IWIDTH for each type of enemy
	dc.w		16,	 4			;pillbug
	dc.w		52,	12			;seymour
	dc.w		50,	16			;turborat
	dc.w		29,	 8			;batskull
	dc.w		50,	16			;big purple rock
	dc.w		27,	 8			;med purple rock
	dc.w		13,	 4			;sml purple rock
	dc.w		47,	12			;big rock
	dc.w		23,	 8			;med rock
	dc.w		11,	 4			;small rock
	dc.w		64,	16			;big crystal
	dc.w		23,	 8			;med crystal A
	dc.w		23,	 8			;med crystal B
	dc.w		63,	16			;big star
	dc.w		31,	 8			;med star
	dc.w		17,  12			;spinner
	dc.w		16,   8			;small scorpion
	dc.w		98,  48			;big scorpion
	dc.w		27,  12			;buggy
	dc.w		39,	12			;cube spin forward
	dc.w		37,	12			;sphere
	dc.w		31,	12			;tri whole
	dc.w		31,	12			;tri 3 pieces
	dc.w		31,	12			;tri 2 pieces
	dc.w		31,	12			;tri 1 piece
	dc.w		32,	16			;bat
	dc.w		40,	16			;big burple
	dc.w		20,	 8			;sml burple
	dc.w		39,	16			;big bubble
	dc.w		19,	 8			;sml bubble
	dc.w		42,	16			;big pebble
	dc.w		24,	12			;med pebble
	dc.w		12,	 4			;sml pebble
	dc.w		55,	12			;firebug
	dc.w		21,	 8			;hummingbird
	dc.w		47,	16			;vulture
	dc.w		16,	 4			;flower
	dc.w		22,	 8			;gundino
	dc.w		21,	 8			;firefly
	dc.w		28,	12			;small spider
	dc.w		63,	24			;big spider
	dc.w		47,	12			;kilrun
	dc.w		48,	12			;sadmask
	dc.w		42,	16			;fish taxi
	dc.w		89,  32			;baby
	dc.w		32,	16			;small dino
	dc.w		96,	40			;robot
	dc.w		11,	24			;snake
	dc.w		38,	12			;glowbug
	dc.w		52,	16			;big blue eye
	dc.w		52,	16			;big green eye
	dc.w		39,	12			;small blue eye
	dc.w		39,	12			;small green eye
	dc.w		56,  20			;dragon
	dc.w		82,	48			;desert robot boss
	dc.w		64,	 8			;desert robot bottom
	dc.w		147, 40			;air robot boss
	dc.w		162, 48			;cave robot boss
	dc.w		129,	40			;wrd robot body
	dc.w		53,	20			;wrd robot tail
	dc.w		67,	20			;wrd robot r arm
	dc.w		86,	32			;wrd robot l arm
	dc.w		174,	32			;city robot body
	dc.w		40,	12			;city robot head
	dc.w		63,  58			;serpent body
	dc.w		67,  40			;serpent right wing
	dc.w		64,  40			;serpent left wing
	dc.w		80,	48			;quetzal body
	dc.w		18,	20			;quetzal back arm
	dc.w		19,	20			;quetzal front arm
	dc.w		91,	24			;quetzal tail
	dc.w		40,	24			;skull ribs
	dc.w		22,	32			;skull arm
	dc.w		44,	20			;skull head
	dc.w		30,	12			;skull neck
	dc.w		44,	16			;skull back horn
	dc.w		39,	 8			;skull front horn
	dc.w		21,	 8			;skull nose horn
	dc.w		173,	28			;oddit cloud
	dc.w		200,	28			;oddit
	dc.w		202,	20			;mud man
	dc.w		48,	16			;spore
	dc.w		28,	 8			;fern
	dc.w		96,	48			;big dino
	dc.w		19,  12			;slug
	dc.w		48,  16			;ball
	dc.w		144, 64			;big block
	dc.w		108,	48			;med block
	dc.w		72,	32			;sml block
	dc.w		16,	12			;geyser
	dc.w		57,   8			;poppy0
	dc.w		41,   4			;poppy1
	dc.w		74,   8			;poppy2
	dc.w		160, 16			;tower
	dc.w		16,  48			;elec
	dc.w		96,  32			;mingbot
	dc.w		80,	12			;falling rock
	dc.w		136,	20			;large ring
	dc.w		88,	16			;med ring
	dc.w		64,	8			;small ring

en_an::
;1st address is list of data addresses for each enemy
;2nd address is list of heights for each frame number (0 is height does not change)
	dc.l	e_pill,	0		;pillbug
	dc.l	e_seym,	0		;seymour
	dc.l	e_trat,	h_trat	;turborat
	dc.l	e_bskull,	0		;batskull
	dc.l	e_prockb,	0		;big purple rock
	dc.l	e_prockm,	h_prockm	;med purple rock
	dc.l	e_procks,	0		;sml purple rock
	dc.l	e_bigrok,	0		;big rock
	dc.l	e_medrok,	0		;med rock
	dc.l	e_smlrok,	0		;sml rock
	dc.l	e_bigcrs,	0		;big blue crystal
	dc.l	e_mdcrsa,	0		;med blue crystal A
	dc.l	e_mdcrsb,	0		;med blue crystal B
	dc.l	e_starb,	0		;big red star
	dc.l	e_starm,	0		;med red star
	dc.l	e_spin,	0		;spinner
	dc.l	e_scorps,	0		;small scorpion
	dc.l	e_scorpb,	0		;big scorpion
	dc.l	e_buggy,	0		;buggy
	dc.l	e_cube,	0		;cube
	dc.l	e_sphere,	h_sphere	;sphere
	dc.l	e_tri4,	0		;tri 4 pieces
	dc.l	e_tri3,	0		;tri 3 pieces
	dc.l	e_tri2,	0		;tri 2 pieces
	dc.l	e_tri1,	0		;tri 1 piece
	dc.l	e_bat,	h_bat	;bat
	dc.l	e_burplb,	h_burplb	;big burple
	dc.l	e_burpls,	h_burpls	;sml burple
	dc.l	e_bubblb,	h_bubblb	;big bubble
	dc.l	e_bubbls,	h_bubbls	;sml bubble
	dc.l	e_pebblb,	0		;big pebble
	dc.l	e_pebblm,	0		;med pebble
	dc.l	e_pebbls,	0		;sml pebble
	dc.l	e_fbug,	h_fbug	;firebug
	dc.l	e_humm,	h_humm	;hummingbird
	dc.l	e_vult,	h_vult	;vulture
	dc.l	e_flwr,	0		;flower
	dc.l	e_gund,	0		;gundino
	dc.l	e_ffly,	0		;firefly
	dc.l	e_spidsm,	0		;small spider
	dc.l	e_spidbg,	0		;big spider
	dc.l	e_kilrun,	h_kilrun	;kilrun
	dc.l	e_sadmsk,	h_sadmsk	;sadmask
	dc.l	e_fishtx,	h_fishtx	;fish taxi
	dc.l	e_baby,	0		;baby
	dc.l	e_dinos,	0		;small dino
	dc.l	e_robot,	h_robot	;robot
	dc.l	e_snake,	h_snake	;snake
	dc.l	e_glow,	h_glow	;glowbug
	dc.l	e_eyelgb,	0		;big blue eye
	dc.l	e_eyelgg, 0		;big green eye
	dc.l	e_eyesmb,	0		;small blue eye
	dc.l	e_eyesmg, 0		;small green eye
	dc.l	e_dragon,	h_dragon	;dragon
	dc.l	e_destop,	0		;desert robot top
	dc.l	e_desbot,	0		;desert robot bottom
	dc.l	e_airbos,	h_airbos	;air robot
	dc.l	e_cvboss,	0		;cave robot
	dc.l	e_wbossb,	0		;weird robot body
	dc.l	e_wbosst,	0		;weird robot tail
	dc.l	e_wbossr,	0		;weird robot right arm
	dc.l	e_wbossl,	0		;weird robot left arm
	dc.l	e_citybs,	0		;city robot body
	dc.l	e_cityhd,	0		;city robot head
	dc.l	e_serpbd,	0		;serpent body
	dc.l	e_serprw,	h_serprw	;serpent right wing
	dc.l	e_serplw,	h_serplw	;serpent left wing
	dc.l	e_quetbd,	0		;quetzal body
	dc.l	e_quetab,	0		;quetzal back arm
	dc.l	e_quetaf,	h_quetaf	;quetzal front arm
	dc.l	e_quettl,	h_quettl	;quetzal tail
	dc.l	e_skribs,	0		;skull ribs
	dc.l	e_skarm,	h_skarm	;skull arm
	dc.l	e_skhead,	h_skhead	;skull head
	dc.l	e_skneck,	h_skneck	;skull neck
	dc.l	e_skhrnb,	h_skhrnb	;skull back horn
	dc.l	e_skhrnf,	h_skhrnf	;skull front horn
	dc.l	e_skhrnn,	h_skhrnn	;skull nose horn
	dc.l	e_oddcld,	0		;oddit cloud
	dc.l	e_oddit,	0		;oddit
	dc.l	e_mud,	h_mud	;mud man
	dc.l	e_spore,	0		;spore
	dc.l	e_fern,	0		;fern
	dc.l	e_dino,	0		;big dino
	dc.l	e_slug,	0		;slug
	dc.l	e_ball,	0		;ball
	dc.l	e_blokb,	0		;big block
	dc.l	e_blokm,	0		;med block
	dc.l	e_bloks,	0		;sml block
	dc.l	e_geyser,	h_geyser	;geyser
	dc.l	e_poppy0,	0		;poppy0
	dc.l	e_poppy1,	0		;poppy1
	dc.l	e_poppy2,	0		;poppy2
	dc.l	e_tower,	0		;tower
	dc.l	e_elec,	0		;elec
	dc.l	e_ming,	0		;mingbot
	dc.l	e_fallrk,	0		;falling rock
	dc.l	e_ringl0,	0		;large ring
	dc.l	e_ringm0,	0		;med ring
	dc.l	e_rings0,	0		;small ring

e_pill:
	dc.l		pillbug0,pillbug1,pillbug2,pillbug3,pillbug4,pillbug5,pillbug6,pillbug7
e_seym:
	dc.l		seymor0,seymor1,seymor2,seymor3,seymor4,seymor5,seymor6
e_trat:
	dc.l		trat00,trat01,trat02,trat03,trat04,trat05,trat06,trat07
	dc.l		trat08,trat09,trat10,trat11,trat12,trat13,trat14,trat15
	dc.l		trat16,trat17,trat18
h_trat:
	dc.w		38,38,37,38,37,38,40,50,38,38,40,45,48,50,45,41,38,38,38
e_bskull:
	dc.l		bskull0,bskull1,bskull2,bskull3,bskull4,bskull5,bskull6,bskull7
e_prockb:
	dc.l		prockb00,prockb01,prockb02,prockb03,prockb04,prockb05,prockb06,prockb07
	dc.l		prockb08,prockb09,prockb10,prockb11,prockb12,prockb13
e_prockm:
	dc.l		prockm00,prockm01,prockm02,prockm03,prockm04,prockm05,prockm06,prockm07
	dc.l		prockm08,prockm09,prockm10,prockm11,prockm12,prockm13
h_prockm:
	dc.w		27,27,27,25,23,22,25,27
	dc.w		28,27,25,24,26,27
e_procks:
	dc.l		procks00,procks01,procks02,procks03,procks04,procks05,procks06,procks07
	dc.l		procks08,procks09,procks10,procks11,procks12,procks13
e_bigrok:
	dc.l		bigrok00,bigrok01,bigrok02,bigrok03,bigrok04,bigrok05,bigrok06,bigrok07
	dc.l		bigrok08,bigrok09,bigrok10,bigrok11,bigrok12,bigrok13,bigrok14,bigrok15
e_medrok:
	dc.l		medrok00,medrok01,medrok02,medrok03,medrok04,medrok05,medrok06,medrok07
	dc.l		medrok08,medrok09,medrok10,medrok11,medrok12,medrok13,medrok14,medrok15
e_smlrok:
	dc.l		smlrok00,smlrok01,smlrok02,smlrok03,smlrok04,smlrok05,smlrok06,smlrok07
	dc.l		smlrok08,smlrok09,smlrok10,smlrok11,smlrok12,smlrok13,smlrok14,smlrok15
e_bigcrs:
	dc.l		bigcrs00,bigcrs01,bigcrs02,bigcrs03,bigcrs04,bigcrs05,bigcrs06,bigcrs07
e_mdcrsa:
	dc.l		mdcrsa00,mdcrsa01,mdcrsa02,mdcrsa03,mdcrsa04,mdcrsa05,mdcrsa06,mdcrsa07
	dc.l		mdcrsa08,mdcrsa09,mdcrsa10,mdcrsa11,mdcrsa12,mdcrsa13,mdcrsa14,mdcrsa15
e_mdcrsb:
	dc.l		mdcrsb00,mdcrsb01,mdcrsb02,mdcrsb03,mdcrsb04,mdcrsb05,mdcrsb06,mdcrsb07
	dc.l		mdcrsb08,mdcrsb09,mdcrsb10,mdcrsb11,mdcrsb12,mdcrsb13,mdcrsb14,mdcrsb15
e_starb:
	dc.l		bigstar0,bigstar1,bigstar2,bigstar3
e_starm:
	dc.l		medstar0,medstar1,medstar2,medstar3
e_spin:
	dc.l		spin00,spin01,spin02,spin03,spin04,spin05,spin06,spin07
e_scorps:
	dc.l		scorp00s,scorp01s,scorp02s,scorp03s,scorp04s,scorp05s
e_scorpb:
	dc.l		scorp00b,scorp01b,scorp02b,scorp03b,scorp04b,scorp05b
e_buggy:
	dc.l		buggy0,buggy1,buggy2,buggy3,buggy4,buggy5,buggy6,buggy7
	dc.l		buggy8,buggy9,buggy10,buggy11
e_cube:
	dc.l		cube00,cube01,cube02,cube03,cube04,cube05,cube06,cube07
	dc.l		cube08,cube09,cube10,cube11,cube12,cube13,cube14,cube15
	dc.l		cube16
e_sphere:
	dc.l		sphere00,sphere01,sphere02,sphere03,sphere04,sphere05,sphere06,sphere07
	dc.l		sphere08,sphere09,sphere10,sphere11,sphere12,sphere13,sphere14,sphere15
	dc.l		sphere16,sphere17,sphere18,sphere19,sphere20,sphere21,sphere22,sphere23
	dc.l		sphere24
h_sphere:
	dc.w		29,31,32,35,36,37,36,30
	dc.w		29,29,29,29,29,29,29,29
	dc.w		29,29,29,29,29,29,29,29
	dc.w		29
e_tri4:
	dc.l		tri00,tri01,tri02,tri03
e_tri3:
	dc.l		tri04,tri05,tri06,tri07
e_tri2:
	dc.l		tri08,tri09,tri10,tri11
e_tri1:
	dc.l		tri12,tri13,tri14,tri15
e_bat:
	dc.l		bat00,bat01,bat02,bat03,bat04,bat05,bat06,bat07
	dc.l		bat08,bat09,bat10,bat11,bat12,bat13,bat14,bat15
	dc.l		bat16,bat17,bat18,bat19,bat20,bat21,bat22,bat23
	dc.l		bat24,bat25,bat26,bat27
h_bat:
	dc.w		28,29,29,31,32,30,27,28
	dc.w		26,25,24,26,27,28,29,30
	dc.w		31,31,31,30,28,28,27,22
	dc.w		23,26,26,29
e_burplb:
	dc.l		burplb00,burplb01,burplb02,burplb03,burplb04,burplb05,burplb06,burplb07
	dc.l		burplb08,burplb09,burplb10,burplb11,burplb12,burplb13,burplb14,burplb15
h_burplb:
	dc.w		40,40,40,40,37,35,34,34,34,36,37,36,37,38,40,40
e_burpls:
	dc.l		burpls00,burpls01,burpls02,burpls03,burpls04,burpls05,burpls06,burpls07
	dc.l		burpls08,burpls09,burpls10,burpls11,burpls12,burpls13,burpls14,burpls15
h_burpls:
	dc.w		20,20,20,20,19,18,17,17,17,18,19,18,19,19,20,20
e_bubblb:
	dc.l		bubblb00,bubblb01,bubblb02,bubblb03,bubblb04,bubblb05,bubblb06,bubblb07
	dc.l		bubblb08,bubblb09,bubblb10,bubblb11,bubblb12,bubblb13,bubblb14,bubblb15
h_bubblb:
	dc.w		32,32,33,33,32,35,38,39,39,39,39,39,39,37,33,32
e_bubbls:
	dc.l		bubbls00,bubbls01,bubbls02,bubbls03,bubbls04,bubbls05,bubbls06,bubbls07
	dc.l		bubbls08,bubbls09,bubbls10,bubbls11,bubbls12,bubbls13,bubbls14,bubbls15
h_bubbls:
	dc.w		16,16,17,17,16,17,19,19,19,19,19,19,19,18,17,16
e_pebblb:
	dc.l		pebblb00,pebblb01,pebblb02,pebblb03,pebblb04,pebblb05,pebblb06,pebblb07
	dc.l		pebblb08,pebblb09,pebblb10,pebblb11,pebblb12,pebblb13,pebblb14,pebblb15
e_pebblm:
	dc.l		pebblm00,pebblm01,pebblm02,pebblm03,pebblm04,pebblm05,pebblm06,pebblm07
	dc.l		pebblm08,pebblm09,pebblm10,pebblm11,pebblm12,pebblm13,pebblm14,pebblm15
e_pebbls:
	dc.l		pebbls00,pebbls01,pebbls02,pebbls03,pebbls04,pebbls05,pebbls06,pebbls07
	dc.l		pebbls08,pebbls09,pebbls10,pebbls11,pebbls12,pebbls13,pebbls14,pebbls15
e_fbug:
	dc.l		fbug00,fbug01,fbug02,fbug03,fbug04,fbug05,fbug06,fbug07
	dc.l		fbug08,fbug09,fbug10,fbug11,fbug12,fbug13,fbug14,fbug15
	dc.l		fbug16,fbug17,fbug18
h_fbug:
	dc.w		38,39,40,41,40,40,55,54,55,51,39,41,45,49,48,46,43,40,39
e_humm:
	dc.l		humm00,humm01,humm02,humm03,humm04,humm05,humm06,humm07
	dc.l		humm08,humm09
h_humm:
	dc.w		21,21,21,21,20,20,20,22,23,24
e_vult:
	dc.l		vult00,vult01,vult02,vult03,vult04,vult05,vult06,vult07,vult08,vult09,vult10,vult11,vult12,vult13,vult14,vult15
	dc.l		vult16,vult17,vult18,vult19,vult20,vult21,vult22,vult23,vult24,vult25,vult26,vult27,vult28,vult29,vult30,vult31
h_vult:
	dc.w		46,44,36,32,32,32,31,32,44,46,42,42,39,31,32,32
	dc.w		32,31,33,44,25,26,28,30,33,33,32,32,31,31,43,47
e_flwr:
	dc.l		flwr00,flwr01,flwr02,flwr03,flwr04,flwr05,flwr06
e_gund:
	dc.l		gund00,gund01,gund02,gund03,gund04,gund05,gund06
e_ffly:
	dc.l		ffly00,ffly01,ffly02,ffly03,ffly04,ffly05
e_spidsm:
	dc.l		spidsm00,spidsm01,spidsm02,spidsm03,spidsm04,spidsm05
e_spidbg:
	dc.l		spidbg00,spidbg01,spidbg02,spidbg03,spidbg04,spidbg05
e_kilrun:
	dc.l		kilrun00,kilrun01,kilrun02,kilrun03,kilrun04,kilrun05,kilrun06,kilrun07
h_kilrun:
	dc.w		46,46,46,46,46,46,47,47
e_sadmsk:
	dc.l		sadmsk00,sadmsk01,sadmsk02,sadmsk03,sadmsk04,sadmsk05,sadmsk06,sadmsk07
	dc.l		sadmsk08,sadmsk09
h_sadmsk:
	dc.w		48,47,48,47,48,48,48,48,47,33
e_fishtx:
	dc.l		fishtx00,fishtx01,fishtx02,fishtx03,fishtx04,fishtx05,fishtx06,fishtx07
	dc.l		fishtx08,fishtx09,fishtx10,fishtx11,fishtx12,fishtx13,fishtx14,fishtx15
	dc.l		fishtx16,fishtx17,fishtx18,fishtx19,fishtx20,fishtx21,fishtx22
h_fishtx:
	dc.w		36,35,34,34,34,35,36,37,40,37,36,36,36,40,40,42,42,42,42,42,40,36,36
e_baby:
	dc.l		baby00,baby01,baby02,baby03,baby04,baby05,baby06,baby07,baby08,baby09,baby10,baby11,baby12,baby13
e_dinos:
	dc.l		dinos00,dinos01,dinos02,dinos03,dinos04,dinos05,dinos06,dinos07
e_robot:
	dc.l		robot00,robot01,robot02,robot03,robot04
h_robot:
	dc.w		96,89,87,85,85
e_snake:
	dc.l		snake00,snake01,snake02,snake03,snake04,snake05,snake06,snake07,snake08,snake09,snake10,snake11,snake12,snake13,snake14,snake15
	dc.l		snake16,snake17,snake18,snake19,snake20,snake21,snake22
h_snake:
	dc.w		11,16,30,42,49,51,51,48,46,43,42,41,38,36,36,34,35,34,31,29,28,26,25
e_glow:
	dc.l		glow00,glow01,glow02,glow03,glow04,glow05,glow06,glow07
h_glow:
	dc.w		39,39,38,37,39,38,37,36
e_eyelgb:
	dc.l		eyelgbl0,eyelgbl1,eyelgbl2,eyelgbl3,eyelgbl4,eyelgbl5,eyelgbl6,eyelgbl7
e_eyelgg:
	dc.l		eyelggr0,eyelggr1,eyelggr2,eyelggr3,eyelggr4,eyelggr5,eyelggr6,eyelggr7
e_eyesmb:
	dc.l		eyesmbl0,eyesmbl1,eyesmbl2,eyesmbl3,eyesmbl4,eyesmbl5,eyesmbl6,eyesmbl7
e_eyesmg:
	dc.l		eyesmgr0,eyesmgr1,eyesmgr2,eyesmgr3,eyesmgr4,eyesmgr5,eyesmgr6,eyesmgr7
e_dragon:
	dc.l		dragon00,dragon01,dragon02,dragon03,dragon04,dragon05
h_dragon:
	dc.w		56,54,53,52,52,52
e_destop:
	dc.l		destop0,destop1,destop2
e_desbot:
	dc.l		desbot0,desbot1,desbot2
e_airbos:
	dc.l		airboss0,airboss1,airboss2,airboss3,airboss4,airboss5,airboss6,airboss7
h_airbos:
	dc.w		147,147,113,129,143,103,95,121

e_cvboss:
	dc.l		cvboss00,cvboss01,cvboss02,cvboss03,cvboss04,cvboss05,cvboss06,cvboss07
	dc.l		cvboss08,cvboss09,cvboss10,cvboss11,cvboss12,cvboss13,cvboss14
e_wbossb:
	dc.l		wboss00,wboss01,wboss02,wboss03,wboss04,wboss05
e_wbosst:
	dc.l		wboss06,wboss07,wboss08,wboss09,wboss10,wboss11
e_wbossr:
	dc.l		wboss12,wboss13,wboss14,wboss15
e_wbossl:
	dc.l		wboss16,wboss17,wboss18,wboss19,wboss20,wboss21,wboss22,wboss23
e_citybs:
	dc.l		citybs00
e_cityhd:
	dc.l		cityhd00,cityhd01,cityhd02,cityhd03,cityhd04,cityhd05,cityhd06
e_serpbd:
	dc.l		serp00,serp01,serp02,serp03,serp04,serp05,serp06,serp07
	dc.l		serp08,serp09,serp10
e_serprw:
	dc.l		serprw00,serprw01,serprw02,serprw03,serprw04,serprw05,serprw06,serprw07
	dc.l		serprw08
h_serprw:
	dc.w		67,80,81,75,75,75,75,73,63
e_serplw:
	dc.l		serplw00,serplw01,serplw02,serplw03,serplw04,serplw05,serplw06,serplw07
	dc.l		serplw08
h_serplw:
	dc.w		64,84,87,71,59,47,45,50,48
e_quetbd:
	dc.l		quetbd00,quetbd01,quetbd02,quetbd03,quetbd04,quetbd05,quetbd06,quetbd07
	dc.l		quetbd08,quetbd09,quetbd10,quetbd11,quetbd12,quetbd13,quetbd14,quetbd15
e_quetab:
	dc.l		quetab00,quetab01,quetab02,quetab03,quetab04,quetab05,quetab06,quetab07
	dc.l		quetab08,quetab09,quetab10,quetab11,quetab12,quetab13,quetab14,quetab15
e_quetaf:
	dc.l		quetaf00,quetaf01,quetaf02,quetaf03,quetaf04,quetaf05,quetaf06,quetaf07
	dc.l		quetaf08,quetaf09,quetaf10,quetaf11,quetaf12,quetaf13,quetaf14,quetaf15
h_quetaf:
	dc.w		19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,19
e_quettl:
	dc.l		quettl00,quettl01,quettl02,quettl03,quettl04,quettl05,quettl06,quettl07
	dc.l		quettl08,quettl09,quettl10,quettl11,quettl12,quettl13,quettl14,quettl15
h_quettl:
	dc.w		91,76,62,50,38,26,20,26,38,50,62,74,91,91,91,90
e_skribs:
	dc.l		skribs
e_skarm:
	dc.l		skarm00,skarm01,skarm02,skarm03,skarm04,skarm05
h_skarm:
	dc.w		22,80,88,80,40,22
e_skhead:
	dc.l		skhead00,skhead01,skhead02,skhead03,skhead04,skhead05,skhead06,skhead07
h_skhead:
	dc.w		44,59,72,65,54,50,62,77
e_skneck:
	dc.l		skneck00,skneck01,skneck02,skneck03,skneck04
h_skneck:
	dc.w		30,24,18,30,30
e_skhrnb:
	dc.l		skhrnb00,skhrnb01,skhrnb02,skhrnb03,skhrnb04,skhrnb05,skhrnb06,skhrnb07,skhrnb08
h_skhrnb:
	dc.w		44,40,36,41,34,25,36,40,37
e_skhrnf:
	dc.l		skhrnf00,skhrnf01,skhrnf02,skhrnf03,skhrnf04,skhrnf05,skhrnf06,skhrnf07,skhrnf08
h_skhrnf:
	dc.w		39,27,20,30,30,24,32,45,50
e_skhrnn:
	dc.l		skhrnn00,skhrnn01,skhrnn02,skhrnn03,skhrnn04,skhrnn05
h_skhrnn:
	dc.w		21,17,13,18,22,24
e_oddcld:
	dc.l		oddcld00,oddcld01,oddcld02,oddcld03
e_oddit:
	dc.l		oddit00,oddit01,oddit02,oddit03,oddit04,oddit05,oddit06,oddit07,oddit08,oddit09,oddit10,oddit11
e_mud:
	dc.l		mud00,mud01,mud02,mud03,mud04,mud05,mud06,mud07
h_mud:
	dc.w		202,204,203,207,204,201,207,205
e_spore:
	dc.l		spore0,spore1,spore2,spore3,spore4,spore5,spore6
e_fern:
	dc.l		fern0,fern1,fern2,fern3,fern4,fern5,fern6,fern7
e_dino:
	dc.l		dino00,dino01,dino02,dino03,dino04,dino05,dino06,dino07
e_slug:
	dc.l		slug00,slug01,slug02,slug03,slug04,slug05
e_ball:
	dc.l		ball00
e_blokb:
	dc.l		blockb00,blockb01
e_blokm:
	dc.l		blockm00
e_bloks:
	dc.l		blocks00,blocks01
e_geyser:
	dc.l		geyser00,geyser01,geyser02,geyser03,geyser04,geyser05,geyser06
h_geyser:
	dc.w		16,28,48,85,124,198,243
e_poppy0:
	dc.l		poppy00
e_poppy1:
	dc.l		poppy01
e_poppy2:
	dc.l		poppy02
e_tower:
	dc.l		tower00
e_elec:
	dc.l		elec00,elec01,elec02,elec03
e_ming:
	dc.l		ming00
e_fallrk:
	dc.l		cvrock04
e_ringl0:
	dc.l		ring00
e_ringm0:
	dc.l		ring02
e_rings0:
	dc.l		ring04

act_ofst::
;for each enemy action, skip this many bytes in the en_an_table for each enemy
;EN_DYING		 4 steps
;EN_APPEAR	12 steps
;EN_MOVING	16 steps for one direction
;			16 steps for other direction
;EN_ATTACK	32 steps
	dc.w		0					;EN_DYING
	dc.w		4					;EN_APPEAR
	dc.w		16					;EN_MOVING
	dc.w		48					;EN_ATTACK

en_an_table::
;EN_DYING		 4 steps
;EN_APPEAR	12 steps
;EN_MOVING	16 steps for one direction
;			16 steps for other direction
;EN_ATTACK	32 steps
;pillbug
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  4,  5,  6,  7,  4,  5,  6,  7,  4,  5,  6,  7,  4,  3,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;seymour
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  4,  5,  6,  5,  4,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;turborat
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;batskull
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  4,  5,  6,  7,  6,  5,  4,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big purple rock
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13,$FF,$FF
	dc.b		  0, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;med purple rock
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13,$FF,$FF
	dc.b		  0, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;sml purple rock
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13,$FF,$FF
	dc.b		  0, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;bigrockr
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;medrockr
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;smlrockr
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big crystal
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  7,  6,  5,  4,  3,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;med crystal A
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;med crystal B
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big star
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  3,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;med star
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  3,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;spinner
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;small scorpion
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  4,  5,  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big scorpion
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  5,  4,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;buggy
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  8,  9, 10, 11,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;cube spin
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  0,  1,  2,  3,  4,  5,  6,  7
	dc.b		  0,  7,  6,  5,  4,  3,  2,  1,  0,  7,  6,  5,  4,  3,  2,  1
	dc.b		  8,  9, 10, 11, 12, 13, 14, 15, 16,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;sphere
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0, 17, 18, 19, 20, 21, 22, 23, 24, 14, 15, 16,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;tri whole
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;tri 3 pieces
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;tri 2 pieces
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;tri 1 piece
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;bat
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,$FF,$FF,$FF,$FF					;part of movement animation
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big burple
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;sml burple
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big bubble
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;sml bubble
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big pebble
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;med pebble
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;sml pebble
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		  0, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;firebug
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		 10, 11, 12, 13, 14, 15, 16, 17, 18,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;hummingbird
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  7,  8,  9,  8,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;vulture
	dc.b		$FF,$FF,$FF,$FF
	dc.b		 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		 11, 12, 13, 14, 15, 16, 17, 18, 19,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;flower
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  4,  5,  6,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  2,  1,  0,  0,  0,  0,  1,  2,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;gundino
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  4,  5,  6,  5,  4,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;firefly
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  4,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;small spider
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big spider
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;kilrun
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  4,  5,  6,  7,  6,  5,  4,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;sadmask
	dc.b		  6,  7,  8,  9
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  4,  5,  2,  3,  0,  1,  2,  3,  0,  1,  2,  3,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;fish taxi
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  0,  6,  7,  8,  9, 10,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;baby
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  8,  9, 10, 11, 12, 13,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;small dino
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;robot
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;snake
	dc.b		$FF,$FF,$FF,$FF
	dc.b		 22, 21, 20, 19, 18, 17, 16,$FF,$FF,$FF,$FF,$FF
	dc.b		 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0
	dc.b		  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,$FF,$FF
	dc.b		 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0
	dc.b		  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,$FF,$FF
;glowbug
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big blue eye
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big green eye
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;small blue eye
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;small green eye
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  6,  5,  4,  3,  2,  1,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;dragon
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  4,  3,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  4,  3,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;desert robot boss
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;desert robot bottom
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  1,  0,  1,  2,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;air robot boss
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;cave robot boss
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  7,  8,  9, 10, 11, 12, 13, 14,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  7, 14, 13, 12, 11, 10,  9,  8,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  3,  2,  1,  0,  0,  0,  0,  1,  2,  3,  4,  5,  6,  6,  6,  6
	dc.b		  5,  4,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;wrd robot body
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;wrd robot tail
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  4,  3,  2,  1,  0,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  4,  3,  2,  1,  0,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;wrd robot r arm
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;wrd robot l arm
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;city robot body
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  0,  0,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;city robot head
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  0,  0,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  2,  4,  6,  6,  6,  5,  3,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;serpent body
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  8,  9, 10,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;serpent right wing
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  5,  6,  7,  8,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;serpent left wing
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  5,  6,  7,  8,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;quetzal body
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;quetzal back arm
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;quetzal front arm
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;quetzal tail
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;skull ribs
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;skull arm
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;skull head
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  0,  0,  1,  2,  3,  4,  5,  0,  0,  0,  0,  0,  6,  7,  6
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;skull neck
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  0,  0,  0,  0,  1,  2,  1,  0,  0,  0,  0,  0,  3,  4,  3
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;skull back horn
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  0,  0,  0,  0,  1,  2,  3,  0,  4,  5,  6,  0,  7,  8,  7
	dc.b		 16, 17, 18, 19, 20, 21, 22, 21, 20, 19, 18, 17,$FF,$FF,$FF,$FF
;skull front horn
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  0,  4,  5,  6,  0,  0,  0,  0,  0,  7,  8,  7
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;skull nose horn
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  0,  0,  0,  0,  1,  2,  3,  0,  0,  0,  0,  0,  4,  5,  4
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;oddit cloud
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;oddit
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;mud man
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;spore
	dc.b		  0,  4,  5,  6
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  0,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  0,  0,  0,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;fern
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  3,  4,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  5,  6,  7,  6,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big dino
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;slug
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;ball
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;big block
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;med block
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;sml block
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;geyser
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,  4,  5,  6,  5,  6,  5,  6,  5,  6,  5,  4,  3
	dc.b		  2,  1,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;poppy0
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;poppy1
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;poppy2
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;tower
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;elec
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,  1,  2,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;mingbot
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;falling rock
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;large ring
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;med ring
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;small ring
	dc.b		$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b		$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

enhitsnd::
;sound that is played when enemy is hit but not destroyed
;$FF means don't play a sound
	dc.b		BLOWUP3_SND			;pillbug
	dc.b		SMALLHIT_SND			;seymour
	dc.b		BLOWUP1_SND			;turborat
	dc.b		BLOWUP2_SND			;batskull
	dc.b		BLOWUP3_SND			;big purple rock
	dc.b		BLOWUP3_SND			;med purple rock
	dc.b		BLOWUP3_SND			;sml purple rock
	dc.b		BLOWUP3_SND			;big rock
	dc.b		BLOWUP3_SND			;med rock
	dc.b		BLOWUP3_SND			;small rock
	dc.b		BLOWUP2_SND			;big crystal
	dc.b		BLOWUP2_SND			;med crystal A
	dc.b		BLOWUP2_SND			;med crystal B
	dc.b		HITNOKIL_SND			;big star
	dc.b		HITNOKIL_SND			;med star
	dc.b		HITNOKIL_SND			;spinner
	dc.b		SMALLHIT_SND			;small scorpion
	dc.b		EXPLOS2_SND			;big scorpion
	dc.b		HITNOKIL_SND			;buggy
	dc.b		SMALLHIT_SND			;cube
	dc.b		BLOWUP3_SND			;sphere
	dc.b		BLOWUP3_SND			;tri whole
	dc.b		HITNOKIL_SND			;tri 3 pieces
	dc.b		HITNOKIL_SND			;tri 2 pieces
	dc.b		HITNOKIL_SND			;tri 1 piece
	dc.b		BLOWUP1_SND			;bat
	dc.b		SMALLHIT_SND			;big burple
	dc.b		SMALLHIT_SND			;sml burple
	dc.b		SMALLHIT_SND			;big bubble
	dc.b		SMALLHIT_SND			;sml bubble
	dc.b		BLOWUP3_SND			;big pebble
	dc.b		BLOWUP3_SND			;med pebble
	dc.b		BLOWUP3_SND			;sml pebble
	dc.b		BLOWUP1_SND			;firebug
	dc.b		SMALLHIT_SND			;hummingbird
	dc.b		BLOWUP1_SND			;vulture
	dc.b		SMALLHIT_SND			;flower
	dc.b		HITNOKIL_SND			;gundino
	dc.b		HITNOKIL_SND			;firefly
	dc.b		BLOWUP1_SND			;small spider
	dc.b		HITNOKIL_SND			;big spider
	dc.b		BLOWUP2_SND			;kilrun
	dc.b		BLOWUP1_SND			;sadmask
	dc.b		HITNOKIL_SND			;fish taxi
	dc.b		HITNOKIL_SND			;baby
	dc.b		BLOWUP3_SND			;small dino
	dc.b		BLOWUP3_SND			;robot
	dc.b		BLOWUP1_SND			;snake
	dc.b		BLOWUP3_SND			;glowbug
	dc.b		BLOWUP1_SND			;big blue eye
	dc.b		BLOWUP1_SND			;big green eye
	dc.b		BLOWUP1_SND			;small blue eye
	dc.b		BLOWUP1_SND			;small green eye
	dc.b		BLOWUP3_SND			;dragon
	dc.b		EXPLOS2_SND			;desert robot boss
	dc.b		BLOWUP3_SND			;desert robot bottom
	dc.b		HITNOKIL_SND			;air robot boss
	dc.b		EXPLOS2_SND			;cave robot boss
	dc.b		BLOWUP3_SND			;wrd robot body
	dc.b		HITNOKIL_SND			;wrd robot tail
	dc.b		HITNOKIL_SND			;wrd robot r arm
	dc.b		HITNOKIL_SND			;wrd robot l arm
	dc.b		BLOWUP3_SND			;city robot body
	dc.b		HITNOKIL_SND			;city robot head
	dc.b		HITNOKIL_SND			;serpent body
	dc.b		BLOWUP2_SND			;serpent right wing
	dc.b		BLOWUP2_SND			;serpent left wing
	dc.b		BLOWUP1_SND			;quetzal body
	dc.b		BLOWUP2_SND			;quetzal back arm
	dc.b		BLOWUP2_SND			;quetzal front arm
	dc.b		HITNOKIL_SND			;quetzal tail
	dc.b		BLOWUP3_SND			;skull ribs
	dc.b		HITNOKIL_SND			;skull arm
	dc.b		EXPLOS2_SND			;skull head
	dc.b		HITNOKIL_SND			;skull neck
	dc.b		HITNOKIL_SND			;skull back horn
	dc.b		HITNOKIL_SND			;skull front horn
	dc.b		HITNOKIL_SND			;skull nose horn
	dc.b		$FF					;oddit cloud
	dc.b		BLOWUP1_SND			;oddit
	dc.b		BLOWUP3_SND			;mud man
	dc.b		BLOWUP3_SND			;spore
	dc.b		BLOWUP1_SND			;fern
	dc.b		EXPLOS2_SND			;big dino
	dc.b		BLOWUP3_SND			;slug
	dc.b		HITNOKIL_SND			;ball
	dc.b		EXPLOS2_SND			;big block
	dc.b		EXPLOS2_SND			;med block
	dc.b		EXPLOS2_SND			;sml block
	dc.b		$FF					;geyser
	dc.b		HITNOKIL_SND			;poppy0
	dc.b		HITNOKIL_SND			;poppy1
	dc.b		HITNOKIL_SND			;poppy1
	dc.b		$FF					;tower
	dc.b		$FF					;elec
	dc.b		BLOWUP1_SND			;mingbot
	dc.b		BLOWUP3_SND			;falling rock
	dc.b		$FF					;large ring
	dc.b		$FF					;med ring
	dc.b		$FF					;small ring
enfirsnd::
;sound that is played when enemy fires a shot
;$FF means don't play a sound
	dc.b		$FF			;pillbug
	dc.b		FIRE_SND		;seymour
	dc.b		FIRE_SND		;turborat
	dc.b		FIRE_SND		;batskull
	dc.b		$FF			;big purple rock
	dc.b		$FF			;med purple rock
	dc.b		$FF			;sml purple rock
	dc.b		$FF			;big rock
	dc.b		$FF			;med rock
	dc.b		$FF			;small rock
	dc.b		$FF			;big crystal
	dc.b		$FF			;med crystal A
	dc.b		$FF			;med crystal B
	dc.b		$FF			;big star
	dc.b		$FF			;med star
	dc.b		$FF			;spinner
	dc.b		FIRE_SND		;small scorpion
	dc.b		FIRE0_SND		;big scorpion
	dc.b		FIRE_SND		;buggy
	dc.b		FIRE_SND		;cube
	dc.b		FIRE_SND		;sphere
	dc.b		$FF			;tri whole
	dc.b		$FF			;tri 3 pieces
	dc.b		$FF			;tri 2 pieces
	dc.b		$FF			;tri 1 piece
	dc.b		$FF			;bat
	dc.b		$FF			;big burple
	dc.b		$FF			;sml burple
	dc.b		$FF			;big bubble
	dc.b		$FF			;sml bubble
	dc.b		$FF			;big pebble
	dc.b		$FF			;med pebble
	dc.b		$FF			;sml pebble
	dc.b		FIRE_SND		;firebug
	dc.b		FIRE_SND		;hummingbird
	dc.b		FIRE1_SND		;vulture
	dc.b		$FF			;flower
	dc.b		FIRE_SND		;gundino
	dc.b		FIRE_SND		;firefly
	dc.b		$FF			;small spider
	dc.b		$FF			;big spider
	dc.b		FIRE_SND		;kilrun
	dc.b		FIRE_SND		;sadmask
	dc.b		FIRE_SND		;fish taxi
	dc.b		FIRE_SND		;baby
	dc.b		$FF			;small dino
	dc.b		$FF			;robot
	dc.b		$FF			;snake
	dc.b		$FF			;glowbug
	dc.b		$FF			;big blue eye
	dc.b		$FF			;big green eye
	dc.b		$FF			;small blue eye
	dc.b		$FF			;small green eye
	dc.b		FIRE_SND		;dragon
	dc.b		FIRE1_SND		;desert robot boss
	dc.b		$FF			;desert robot bottom
	dc.b		FIRE_SND		;air robot boss
	dc.b		EXPLOS2_SND	;cave robot boss
	dc.b		FIRE_SND		;wrd robot body
	dc.b		FIRE2_SND		;wrd robot tail
	dc.b		FIRE1_SND		;wrd robot r arm
	dc.b		FIRE1_SND		;wrd robot l arm
	dc.b		LAUNCH_SND	;city robot body
	dc.b		FIRE_SND		;city robot head
	dc.b		FIRE1_SND		;serpent body
	dc.b		$FF			;serpent right wing
	dc.b		$FF			;serpent left wing
	dc.b		FIRE2_SND		;quetzal body
	dc.b		$FF			;quetzal back arm
	dc.b		$FF			;quetzal front arm
	dc.b		$FF			;quetzal tail
	dc.b		$FF			;skull ribs
	dc.b		$FF			;skull arm
	dc.b		FIRE1_SND		;skull head
	dc.b		$FF			;skull neck
	dc.b		BLOWUP3_SND	;skull back horn
	dc.b		BLOWUP3_SND	;skull front horn
	dc.b		$FF			;skull nose horn
	dc.b		$FF			;oddit cloud
	dc.b		EXPLOS2_SND	;oddit
	dc.b		FIRE2_SND		;mud man
	dc.b		FIRE2_SND		;spore
	dc.b		FIRE0_SND		;fern
	dc.b		BLOWUP3_SND	;big dino
	dc.b		FIRE2_SND		;slug
	dc.b		$FF			;ball
	dc.b		$FF			;big block
	dc.b		$FF			;med block
	dc.b		$FF			;sml block
	dc.b		$FF			;geyser
	dc.b		$FF			;poppy0
	dc.b		$FF			;poppy1
	dc.b		$FF			;poppy2
	dc.b		$FF			;tower
	dc.b		$FF			;elec
	dc.b		$FF			;mingbot
	dc.b		$FF			;falling rock
	dc.b		$FF			;large ring
	dc.b		$FF			;med ring
	dc.b		$FF			;small ring

shot_types::
;pick one of these 2 types of shots at random
	dc.b		$FF,		$FF		;pillbug
	dc.b		SEYMSHOT,	SEYMSHOT	;seymour
	dc.b		TRATSHOT,	TRATSHOT	;turborat
	dc.b		BSKSHOT,	BSKSHOT	;batskull
	dc.b		$FF,		$FF		;big purple rock
	dc.b		$FF,		$FF		;med purple rock
	dc.b		$FF,		$FF		;sml purple rock
	dc.b		$FF,		$FF		;big rock
	dc.b		$FF,		$FF		;med rock
	dc.b		$FF,		$FF		;small rock
	dc.b		$FF,		$FF		;big crystal
	dc.b		$FF,		$FF		;med crystal A
	dc.b		$FF,		$FF		;med crystal B
	dc.b		$FF,		$FF		;big star
	dc.b		$FF,		$FF		;med star
	dc.b		$FF,		$FF		;spinner
	dc.b		SCRP_SHS,	SCRP_SHS	;small scorpion
	dc.b		SCRP_SHB,	SCRP_SHB	;big scorpion
	dc.b		BUG_SHOT,	BUG_SHOT	;buggy
	dc.b		CUBESHOT,	CUBESHOT	;cube
	dc.b		SPHERSH,	SPHERSH	;sphere
	dc.b		TRISH0,	TRISH0	;tri whole
	dc.b		TRISH1,	TRISH1	;tri 3 pieces
	dc.b		TRISH2,	TRISH2	;tri 2 pieces
	dc.b		$FF,		$FF		;tri 1 piece
	dc.b		$FF,		$FF		;bat
	dc.b		$FF,		$FF		;big burple
	dc.b		$FF,		$FF		;sml burple
	dc.b		$FF,		$FF		;big bubble
	dc.b		$FF,		$FF		;sml bubble
	dc.b		$FF,		$FF		;big pebble
	dc.b		$FF,		$FF		;med pebble
	dc.b		$FF,		$FF		;sml pebble
	dc.b		FBUGSHOT,	FBUGSHOT	;firebug
	dc.b		HUMMSHOT,	HUMMSHOT	;hummingbird
	dc.b		VULTSHOT,	VULTSHOT	;vulture
	dc.b		$FF,		$FF		;flower
	dc.b		GUNDSHOT,	GUNDSHOT	;gundino
	dc.b		FFLYSHOT,	FFLYSHOT	;firefly
	dc.b		$FF,		$FF		;small spider
	dc.b		$FF,		$FF		;big spider
	dc.b		KILRSHOT,	KILRSHOT	;kilrun
	dc.b		SADMSHOT,	SADMSHOT	;sadmask
	dc.b		FISHTXSH,	FISHTXSH	;fish taxi
	dc.b		BABYSHOT,	BABYSHOT	;baby
	dc.b		$FF,		$FF		;small dino
	dc.b		$FF,		$FF		;robot
	dc.b		$FF,		$FF		;snake
	dc.b		$FF,		$FF		;glowbug
	dc.b		$FF,		$FF		;big blue eye
	dc.b		$FF,		$FF		;big green eye
	dc.b		$FF,		$FF		;small blue eye
	dc.b		$FF,		$FF		;small green eye
	dc.b		DRAGSHOT,	DRAGSHOT	;dragon
	dc.b		DESRBSH0,	DESRBSH0	;desert robot boss	DESRBSH1 is used if shot goes to left
	dc.b		$FF,		$FF		;desert robot bottom
	dc.b		AIRRBSHT,	AIRRBSHT	;air robot boss
	dc.b		CVRBSH1,	CVRBSH1	;cave robot boss
	dc.b		$FF,		$FF		;wrd robot body
	dc.b		WSHOTTL,	WSHOTTL	;wrd robot tail
	dc.b		WSHOTHR,	WSHOTHR	;wrd robot r arm
	dc.b		WSHOTHL,	WSHOTHL	;wrd robot l arm
	dc.b		CTYSHMIS,	CTYSHRNG	;city robot body
	dc.b		CTYSHHD,	CTYSHHD	;city robot head
	dc.b		SERPSHOT,	SERPSHOT	;serpent body
	dc.b		$FF,		$FF		;serpent right wing
	dc.b		$FF,		$FF		;serpent left wing
	dc.b		QUETSHOT,	QUETSHOT	;quetzal body
	dc.b		$FF,		$FF		;quetzal back arm
	dc.b		$FF,		$FF		;quetzal front arm
	dc.b		$FF,		$FF		;quetzal tail
	dc.b		$FF,		$FF		;skull ribs
	dc.b		$FF,		$FF		;skull arm
	dc.b		SKULLSHH,	SKULLSHH	;skull head
	dc.b		$FF,		$FF		;skull neck
	dc.b		SKULLSHB,	SKULLSHB	;skull back horn
	dc.b		SKULLSHF,	SKULLSHF	;skull front horn
	dc.b		SKULLSHN,	SKULLSHN	;skull nose horn
	dc.b		$FF,		$FF		;oddit cloud
	dc.b		ODDITSH0,	ODDITSH1	;oddit
	dc.b		MUDSHOT,	MUDSHOT	;mud man
	dc.b		SPITSHOT,	SPITSHOT	;spore
	dc.b		FERNSHOT,	FERNSHOT	;fern
	dc.b		DINOSHOT,	DINOSHOT	;big dino
	dc.b		SLUGSHOT,	SLUGSHOT	;slug
	dc.b		$FF,		$FF		;ball
	dc.b		$FF,		$FF		;big block
	dc.b		$FF,		$FF		;med block
	dc.b		$FF,		$FF		;sml block
	dc.b		$FF,		$FF		;geyser
	dc.b		$FF,		$FF		;poppy0
	dc.b		$FF,		$FF		;poppy1
	dc.b		$FF,		$FF		;poppy2
	dc.b		$FF,		$FF		;tower
	dc.b		$FF,		$FF		;elec
	dc.b		$FF,		$FF		;mingbot
	dc.b		$FF,		$FF		;falling rock
	dc.b		$FF,		$FF		;large ring
	dc.b		$FF,		$FF		;med ring
	dc.b		$FF,		$FF		;small ring
	.even
shot_pos::
;add first number to enemy hpos to get shot xpos when shot is fired
;add second number to enemy ypos to get shot ypos when shot is fired
	dc.w		-10, 50			;batskull
	dc.w		 34, 88			;turborat
	dc.w		 26,-14			;spore
	dc.w		  4,  0			;fern
	dc.w		 -8, 20			;seymour
	dc.w		  6,	 0			;small scorpion
	dc.w		 76,	80			;big scorpion
	dc.w		 37,	30			;buggy
	dc.w		  1, 48			;cube
	dc.w		 -1, 30			;sphere
	dc.w		  4, 92			;firebug
	dc.w		  0, 12			;hummingbird
	dc.w		  1, 36			;vulture
	dc.w		 10, 10			;gundino
	dc.w		 15, 12			;firefly
	dc.w		  1, 16			;kilrun
	dc.w		 17, 48			;sadmask
	dc.w		101, 62			;desert robot boss 0
	dc.w		 99, 62			;desert robot boss 1
	dc.w		 -2, 78			;fish taxi
	dc.w		 22,104			;air robot boss
	dc.w		 28,139			;cave robot boss tube shot
	dc.w		-12, 48			;cave robot boss arm shot
	dc.w		  9,	 8			;tri top piece
	dc.w		  4,	20			;tri top middle piece
	dc.w		  0,	 0			;tri bottom middle piece
	dc.w		  1, 38			;baby
	dc.w		 10, 42			;city robot head shot
	dc.w		 18, 66			;city robot shoulder missile
	dc.w		 30,130			;city robot waist ring
	dc.w		 -8,  0			;slug
	dc.w		  4, 76			;quetzal body
	dc.w		 18, 74			;skull shot head
	dc.w		-10, 20			;skull shot back horn
	dc.w		 -7, 10			;skull shot front horn
	dc.w		 -3, 38			;skull shot nose horn
	dc.w		  2, 48			;dino shot
	dc.w		 42,156			;oddit shot 0
	dc.w		 46,220			;oddit shot 1
	dc.w		-64, 92			;mud man shot
	dc.w		  0, 42			;serpent shot
	dc.w		 -8, 36			;weird robot tail shot
	dc.w		-10, 86			;weird robot right hand shot
	dc.w		-14, 76			;weird robot left hand shot
	dc.w		 -8, 52			;dragon shot
shot_data::
;data for each type of enemy shot
;4 animation steps each
	dc.l		bskshot,bskshot,bskshot,bskshot
	dc.l		tratshot,tratshot,tratshot,tratshot
	dc.l		spit0,spit1,spit2,spit1
	dc.l		fernsht0,fernsht1,fernsht2,fernsht3
	dc.l		seyshot0,seyshot1,seyshot0,seyshot1
	dc.l		scorpsh1,scorpsh2,scorpsh3,scorpsh2
	dc.l		scorpsh0,scorpsh0,scorpsh0,scorpsh0
	dc.l		buggysh0,buggysh1,buggysh2,buggysh3
	dc.l		cubeshot,cubeshot,cubeshot,cubeshot
	dc.l		spheresh,spheresh,spheresh,spheresh
	dc.l		fbugsht0,fbugsht1,fbugsht0,fbugsht1
	dc.l		hummshot,hummshot,hummshot,hummshot
	dc.l		vultshot,vultshot,vultshot,vultshot
	dc.l		gundsht0,gundsht1,gundsht2,gundsht1
	dc.l		fflysht0,fflysht1,fflysht0,fflysht1
	dc.l		kilrunsh,kilrunsh,kilrunsh,kilrunsh
	dc.l		sadmsht0,sadmsht1,sadmsht2,sadmsht1
	dc.l		desbssh0,desbssh1,desbssh0,desbssh1
	dc.l		desbssh2,desbssh3,desbssh2,desbssh3
	dc.l		fishtxsh,fishtxsh,fishtxsh,fishtxsh
	dc.l		airboss8,airboss8,airboss8,airboss8
	dc.l		cvbssh0,cvbssh0,cvbssh0,cvbssh0
	dc.l		cvbssh1,cvbssh1,cvbssh1,cvbssh1
	dc.l		tri16,tri17,tri18,tri19
	dc.l		tri20,tri21,tri22,tri23
	dc.l		tri24,tri25,tri26,tri27
	dc.l		babyshot,babyshot,babyshot,babyshot
	dc.l		citysh00,citysh00,citysh01,citysh01
	dc.l		citysh02,citysh03,citysh02,citysh03
	dc.l		citysh04,citysh04,citysh04,citysh04
	dc.l		slugshot,slugshot,slugshot,slugshot
	dc.l		quetsht0,quetsht0,quetsht0,quetsht0
	dc.l		skullsh0,skullsh0,skullsh0,skullsh0
	dc.l		skullsh0,skullsh0,skullsh0,skullsh0
	dc.l		skullsh0,skullsh0,skullsh0,skullsh0
	dc.l		skullsh0,skullsh0,skullsh0,skullsh0
	dc.l		dinoshot,dinoshot,dinoshot,dinoshot
	dc.l		odditsh0,odditsh0,odditsh0,odditsh0
	dc.l		odditsh0,odditsh0,odditsh0,odditsh0
	dc.l		mudshot,mudshot,mudshot,mudshot
	dc.l		serpsht0,serpsht0,serpsht0,serpsht0
	dc.l		wshot01,wshot01,wshot01,wshot01
	dc.l		wshot00,wshot00,wshot00,wshot00
	dc.l		wshot00,wshot00,wshot00,wshot00
	dc.l		dragshot,dragshot,dragshot,dragshot
en_sh_width::					;for collision detection, can be different than object height
	dc.w		8				;batskull shot
	dc.w		8				;turborat shot
	dc.w		14				;spit
	dc.w		4				;fern shot
	dc.w		16				;seymour shot
	dc.w		5				;small scorpion shot
	dc.w		8				;big scorpion shot
	dc.w		7				;buggy shot
	dc.w		8				;cube shot
	dc.w		8				;sphere shot
	dc.w		16				;firebug shot
	dc.w		16				;hummingbird shot
	dc.w		24				;vulture shot
	dc.w		8				;gundino shot
	dc.w		16				;firefly shot
	dc.w		6				;kilrun shot
	dc.w		6				;sadmask shot
	dc.w		48				;desert robot boss shot 0
	dc.w		48				;desert robot boss shot 1
	dc.w		6				;fish taxi
	dc.w		16				;air robot boss
	dc.w		32				;cave robot boss tube shot
	dc.w		24				;cave robot boss arm shot
	dc.w		16				;tri top piece
	dc.w		24				;tri top middle piece
	dc.w		32				;tri bottom middle piece
	dc.w		16				;baby shot
	dc.w		32				;city robot head shot
	dc.w		24				;city robot shoulder missile
	dc.w		32				;city robot waist ring
	dc.w		24				;slug shot
	dc.w		48				;quetzal shot
	dc.w		32				;skull shot head
	dc.w		32				;skull shot back horn
	dc.w		32				;skull shot front horn
	dc.w		32				;skull shot nose horn
	dc.w		24				;dino shot
	dc.w		32				;oddit shot 0
	dc.w		32				;oddit shot 1
	dc.w		32				;mud man shot
	dc.w		48				;serpent shot
	dc.w		8				;weird robot tail shot
	dc.w		12				;weird robot right hand shot
	dc.w		12				;weird robot left hand shot
	dc.w		12				;dragon shot
en_sh_dwidth::
	dc.w		1				;batskull shot
	dc.w		1				;turborat shot
	dc.w		2				;spit
	dc.w		1				;fern shot
	dc.w		2				;seymour shot
	dc.w		1				;small scorpion shot
	dc.w		2				;big scorpion shot
	dc.w		1				;buggy shot
	dc.w		2				;cube shot
	dc.w		2				;sphere shot
	dc.w		2				;firebug shot
	dc.w		2				;hummingbird shot
	dc.w		3				;vulture shot
	dc.w		1				;gundino shot
	dc.w		2				;firefly shot
	dc.w		1				;kilrun shot
	dc.w		1				;sadmask shot
	dc.w		12				;desert robot boss shot 0
	dc.w		12				;desert robot boss shot 1
	dc.w		1				;fish taxi
	dc.w		4				;air robot boss
	dc.w		8				;cave robot boss tube shot
	dc.w		6				;cave robot boss arm shot
	dc.w		4				;tri top piece
	dc.w		8				;tri top middle piece
	dc.w		8				;tri bottom middle piece
	dc.w		4				;baby shot
	dc.w		8				;city robot head shot
	dc.w		8				;city robot shoulder missile
	dc.w		8				;city robot waist ring
	dc.w		3				;slug shot
	dc.w		12				;quetzal shot
	dc.w		8				;skull shot head
	dc.w		8				;skull shot back horn
	dc.w		8				;skull shot front horn
	dc.w		8				;skull shot nose horn
	dc.w		3				;dino shot
	dc.w		8				;oddit shot 0
	dc.w		8				;oddit shot 1
	dc.w		8				;mud man shot
	dc.w		12				;serpent shot
	dc.w		2				;weird robot tail shot
	dc.w		3				;weird robot right hand shot
	dc.w		3				;weird robot left hand shot
	dc.w		3				;dragon shot
en_sh_ht::
	dc.w		2				;batskull shot
	dc.w		1				;turborat shot
	dc.w		24				;spit
	dc.w		4				;fern shot
	dc.w		4				;seymour shot
	dc.w		7				;small scorpion shot
	dc.w		8				;big scorpion shot
	dc.w		2				;buggy shot
	dc.w		8				;cube shot
	dc.w		7				;sphere shot
	dc.w		5				;firebug shot
	dc.w		9				;hummingbird shot
	dc.w		12				;vulture shot
	dc.w		2				;gundino shot
	dc.w		8				;firefly shot
	dc.w		3				;kilrun shot
	dc.w		4				;sadmask shot
	dc.w		14				;desert robot boss shot 0
	dc.w		14				;desert robot boss shot 1
	dc.w		1				;fish taxi
	dc.w		13				;air robot boss
	dc.w		16				;cave robot boss tube shot
	dc.w		20				;cave robot boss arm shot
	dc.w		7				;tri top piece
	dc.w		11				;tri top middle piece
	dc.w		13				;tri bottom middle piece
	dc.w		13				;baby shot
	dc.w		10				;city robot head shot
	dc.w		12				;city robot shoulder missile
	dc.w		30				;city robot waist ring
	dc.w		11				;slug shot
	dc.w		16				;quetzal shot
	dc.w		8				;skull shot head
	dc.w		8				;skull shot back horn
	dc.w		8				;skull shot front horn
	dc.w		8				;skull shot nose horn
	dc.w		3				;dino shot
	dc.w		14				;oddit shot 0
	dc.w		14				;oddit shot 1
	dc.w		32				;mud man shot
	dc.w		24				;serpent shot
	dc.w		8				;weird robot tail shot
	dc.w		12				;weird robot right hand shot
	dc.w		12				;weird robot left hand shot
	dc.w		12				;dragon shot
en_sh_dp::					;pixel depth
	dc.b		3				;batskull shot
	dc.b		3				;turborat shot
	dc.b		3				;spit
	dc.b		3				;fern shot
	dc.b		3				;seymour shot
	dc.b		3				;small scorpion shot
	dc.b		4				;big scorpion shot
	dc.b		3				;buggy shot
	dc.b		4				;cube shot
	dc.b		4				;sphere shot
	dc.b		3				;firebug shot
	dc.b		3				;hummingbird shot
	dc.b		3				;vulture shot
	dc.b		3				;gundino shot
	dc.b		3				;firefly shot
	dc.b		3				;kilrun shot
	dc.b		3				;sadmask shot
	dc.b		4				;desert robot boss shot 0
	dc.b		4				;desert robot boss shot 1
	dc.b		3				;fish taxi
	dc.b		4				;air robot boss
	dc.b		4				;cave robot boss tube shot
	dc.b		4				;cave robot boss arm shot
	dc.b		4				;tri top piece
	dc.b		4				;tri top middle piece
	dc.b		4				;tri bottom middle piece
	dc.b		4				;baby shot
	dc.b		4				;city robot head shot
	dc.b		4				;city robot shoulder missile
	dc.b		4				;city robot waist ring
	dc.b		3				;slug shot
	dc.b		4				;quetzal shot
	dc.b		4				;skull shot head
	dc.b		4				;skull shot back horn
	dc.b		4				;skull shot front horn
	dc.b		4				;skull shot nose horn
	dc.b		3				;dino shot
	dc.b		4				;oddit shot 0
	dc.b		4				;oddit shot 1
	dc.b		4				;mud man shot
	dc.b		4				;serpent shot
	dc.b		4				;weird robot tail shot
	dc.b		4				;weird robot right hand shot
	dc.b		4				;weird robot left hand shot
	dc.b		4				;dragon shot
en_sh_fp::					;first pixel (pixels to skip = O_FIRSTPIX / bits per pixel)
	dc.b		8				;batskull shot
	dc.b		0				;turborat shot
	dc.b		16				;spit
	dc.b		32				;fern shot
	dc.b		0				;seymour shot
	dc.b		0				;small scorpion shot
	dc.b		0				;big scorpion shot
	dc.b		16				;buggy shot
	dc.b		0				;cube shot
	dc.b		0				;sphere shot
	dc.b		0				;firebug shot
	dc.b		24				;hummingbird shot
	dc.b		16				;vulture shot
	dc.b		0				;gundino shot
	dc.b		0				;firefly shot
	dc.b		16				;kilrun shot
	dc.b		16				;sadmask shot
	dc.b		0				;desert robot boss shot 0
	dc.b		0				;desert robot boss shot 1
	dc.b		16				;fish taxi
	dc.b		0				;air robot boss
	dc.b		0				;cave robot boss tube shot
	dc.b		0				;cave robot boss arm shot
	dc.b		0				;tri top piece
	dc.b		0				;tri top middle piece
	dc.b		0				;tri bottom middle piece
	dc.b		0				;baby shot
	dc.b		0				;city robot head shot
	dc.b		0				;city robot shoulder missile
	dc.b		0				;city robot waist ring
	dc.b		0				;slug shot
	dc.b		0				;quetzal shot
	dc.b		0				;skull shot head
	dc.b		0				;skull shot back horn
	dc.b		0				;skull shot front horn
	dc.b		0				;skull shot nose horn
	dc.b		0				;dino shot
	dc.b		0				;oddit shot 0
	dc.b		0				;oddit shot 1
	dc.b		0				;mud man shot
	dc.b		0				;serpent shot
	dc.b		0				;weird robot tail shot
	dc.b		0				;weird robot right hand shot
	dc.b		0				;weird robot left hand shot
	dc.b		0				;dragon shot
shot_speeds::													;speeds for each type of enemy shot
	dc.b		5				;batskull shot
	dc.b		6				;turborat shot
	dc.b		8				;spit
	dc.b		3				;fern shot
	dc.b		6				;seymour shot
	dc.b		5				;small scorpion shot
	dc.b		6				;big scorpion shot
	dc.b		5				;buggy shot
	dc.b		5				;cube shot
	dc.b		5				;sphere shot
	dc.b		5				;firebug shot
	dc.b		5				;hummingbird shot
	dc.b		5				;vulture shot
	dc.b		5				;gundino shot
	dc.b		5				;firefly shot
	dc.b		5				;kilrun shot
	dc.b		5				;sadmask shot
	dc.b		5				;desert robot boss shot 0
	dc.b		5				;desert robot boss shot 1
	dc.b		5				;fish taxi
	dc.b		5				;air robot boss
	dc.b		7				;cave robot boss tube shot
	dc.b		6				;cave robot boss arm shot
	dc.b		5				;tri top piece
	dc.b		5				;tri top middle piece
	dc.b		5				;tri bottom middle piece
	dc.b		5				;baby shot
	dc.b		5				;city robot head shot
	dc.b		6				;city robot shoulder missile
	dc.b		3				;city robot waist ring
	dc.b		4				;slug shot
	dc.b		6				;quetzal shot
	dc.b		5				;skull shot head
	dc.b		14				;skull shot back horn
	dc.b		14				;skull shot front horn
	dc.b		13				;skull shot nose horn
	dc.b		15				;dino shot
	dc.b		5				;oddit shot 0
	dc.b		6				;oddit shot 1
	dc.b		7				;mud man shot
	dc.b		6				;serpent shot
	dc.b		5				;weird robot tail shot
	dc.b		6				;weird robot right hand shot
	dc.b		6				;weird robot left hand shot
	dc.b		6				;dragon shot
sh_usetg::													;1 if enemy shot uses a target
	dc.b		0				;batskull shot
	dc.b		0				;turborat shot
	dc.b		0				;spit
	dc.b		0				;fern shot
	dc.b		0				;seymour shot
	dc.b		0				;small scorpion shot
	dc.b		0				;big scorpion shot
	dc.b		0				;buggy shot
	dc.b		0				;cube shot
	dc.b		0				;sphere shot
	dc.b		0				;firebug shot
	dc.b		0				;hummingbird shot
	dc.b		0				;vulture shot
	dc.b		0				;gundino shot
	dc.b		0				;firefly shot
	dc.b		0				;kilrun shot
	dc.b		0				;sadmask shot
	dc.b		1				;desert robot boss shot 0
	dc.b		1				;desert robot boss shot 1
	dc.b		0				;fish taxi
	dc.b		0				;air robot boss
	dc.b		0				;cave robot boss tube shot
	dc.b		0				;cave robot boss arm shot
	dc.b		0				;tri top piece
	dc.b		0				;tri top middle piece
	dc.b		0				;tri bottom middle piece
	dc.b		0				;baby shot
	dc.b		0				;city robot head shot
	dc.b		0				;city robot shoulder missile
	dc.b		0				;city robot waist ring
	dc.b		0				;slug shot
	dc.b		0				;quetzal shot
	dc.b		1				;skull shot head
	dc.b		0				;skull shot back horn
	dc.b		0				;skull shot front horn
	dc.b		0				;skull shot nose horn
	dc.b		0				;dino shot
	dc.b		1				;oddit shot 0
	dc.b		0				;oddit shot 1
	dc.b		0				;mud man shot
	dc.b		0				;serpent shot
	dc.b		0				;weird robot tail shot
	dc.b		0				;weird robot right hand shot
	dc.b		0				;weird robot left hand shot
	dc.b		0				;dragon shot
shotdirs::													;$FF means aim at player
;$FF = use direction to player as shot direction
;$FE = use any random direction
;$FD = use random left direction (only 13, 12, 11, 10)
;$FC = use any random left direction
;$FB = use any random right direction
	dc.b		12				;batskull shot
	dc.b		12				;turborat shot
	dc.b		0				;spit
	dc.b		$FF				;fern shot
	dc.b		12				;seymour shot
	dc.b		12				;small scorpion shot
	dc.b		$FD				;big scorpion shot
	dc.b		4				;buggy shot
	dc.b		12				;cube shot
	dc.b		12				;sphere shot
	dc.b		12				;firebug shot
	dc.b		12				;hummingbird shot
	dc.b		12				;vulture shot
	dc.b		12				;gundino shot
	dc.b		4				;firefly shot
	dc.b		12				;kilrun shot
	dc.b		$FF				;sadmask shot
	dc.b		$FF				;desert robot boss 0
	dc.b		$FF				;desert robot boss 1
	dc.b		12				;fish taxi
	dc.b		12				;air robot boss
	dc.b		12				;cave robot boss tube shot
	dc.b		$FD				;cave robot boss arm shot
	dc.b		$FF				;tri top piece
	dc.b		$FF				;tri top middle piece
	dc.b		$FF				;tri bottom middle piece
	dc.b		12				;baby shot
	dc.b		$FD				;city robot head shot
	dc.b		$FD				;city robot shoulder missile
	dc.b		12				;city robot waist ring
	dc.b		$FF				;slug shot
	dc.b		12				;quetzal shot
	dc.b		$FF				;skull shot head
	dc.b		$FC				;skull shot back horn
	dc.b		$FC				;skull shot front horn
	dc.b		$FE				;skull shot nose horn
	dc.b		$FD				;dino shot
	dc.b		$FC				;oddit shot
	dc.b		$FF				;oddit shot
	dc.b		$FD				;mud man shot
	dc.b		$FD				;serpent shot
	dc.b		$FC				;weird robot tail shot
	dc.b		$FD				;weird robot right hand shot
	dc.b		$FD				;weird robot left hand shot
	dc.b		12				;dragon shot
	.even

track_dirs::
	dc.b		 0, 1, 2				;   15  1
	dc.b		 4, 3, 2				; 14  0  2
	dc.b		 4, 5, 6				;13 \ | / 3
	dc.b		 8, 7, 6				;12---+---4
	dc.b		 8, 9,10				;11 / | \ 5
	dc.b		12,11,10				; 10  8  6
	dc.b		12,13,14				;   9   7
	dc.b		 0,15,14
	.even

pwrtable::
;when a powerup is created, the type is picked randomly from this table
	dcb.b	40, P_BULL1		;bullets
	dcb.b	11, P_BOMB1		;bombs
	dcb.b	10, P_BEAM		;beam
	dcb.b	10, P_MAGNET		;magnet
	dcb.b	 1, P_LIFE		;life
	dcb.b	11, P_MISS		;missile
	dcb.b	10, P_RING		;ring
	dcb.b	11, P_TRACE		;trace
	dcb.b	 3, P_FLASH		;flash
	dcb.b	10, P_BOLT		;bolt
	dcb.b	11, P_SHIELD		;shield
;-------------128 total---------------------

	.even

pwr_data::						;address in rom for each type of powerup
	dc.l		pwbull1,pwbull2,pwbull3,pwbull3,pwbull3,pwbomb1,pwbomb2
	dc.l		pwbeam,pwmagnet,pwlife,pwmiss,pwring,pwtrace,pwflash,pwbolt,pwshld,pwpoints
pw_coll::
;subroutines for what happens when you pick up each type of powerup
	dc.l		pw_bull,pw_bull,pw_bull,pw_bull,pw_bull,pw_bomb,pw_bomb
	dc.l		pw_beam,pw_mag,pw_life,pw_miss,pw_ring,pw_trace,pw_flash,pw_bolt,pw_shld,pw_pts

buldata::										;bullet object data for each power level
	dc.l		bulletl0,bulletl1,bulletl2,bulletl3,bulletl3,bulletl3
bulheight::						;O_HEIGHT for player bullets
	dc.w		5,7,9,11,22,33
buldwid::							;O_DWIDTH, O_IWIDTH for player bullets
	dc.w		1,1,2,2,2,2
bulwidth::						;width for collision detection
	dc.w		5,7,10,12,12,12
bulcolht::						;height for collision detection (halflines)
	dc.w		10,14,18,22,44,66
bulyoff::							;add to player ypos to get bullet starting position
	dc.w		BULLET0_YPOS,BULLET1_YPOS,BULLET2_YPOS,BULLET3_YPOS,BULLET4_YPOS,BULLET5_YPOS
bulfirst::						;O_FIRSTPIX for player bullets
	dc.b		24,8,48,32,32,32
	.even
bull_dmg::						;damage done by each type of bullet
	dc.w		BULLET0_DAMAGE,BULLET1_DAMAGE,BULLET2_DAMAGE,BULLET3_DAMAGE,BULLET4_DAMAGE,BULLET5_DAMAGE

bomb_hpos_chg::
	dc.b		3,3,2,2,2,2,2,2,2,2,1,2,1,2,1,2		;16 numbers per line
	dc.b		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
	dc.b		1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1
	dc.b		0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
bomb_vpos_chg::
	dc.b		2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4
	dc.b		5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7
	dc.b		7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9
	dc.b		10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11
	dc.b		12,12,12,12,12,12,13,13,13,13,13,14,14,14,14,14
	.even
bomb_dmg::						;amount of damage done by each type of bomb
	dc.w		BOMB0_DAMAGE,BOMB1_DAMAGE,BOMB2_DAMAGE
bombsrom::						;rom addresses for bomb object data
	dc.l		bmb0rom,bmb1rom,bmb2rom

s_coll_addr::						;collision detection routines
	dc.l		magcoll
	dc.l		traccoll
	dc.l		beamcoll
	dc.l		flshcoll
	dc.l		misscoll
	dc.l		ringcoll
	dc.l		boltcoll
	dc.l		shldcoll
f_spec::							;firing routines for special weapons
	dc.l		f_magnet
	dc.l		f_tracer
	dc.l		f_beam
	dc.l		f_flash
	dc.l		f_missile
	dc.l		f_ring
	dc.l		f_bolt
	dc.l		f_shield
m_spec::							;moving or animation routines for special weapons
	dc.l		m_magnet
	dc.l		m_tracer
	dc.l		m_beam
	dc.l		m_flash
	dc.l		m_missile
	dc.l		m_ring
	dc.l		m_bolt
	dc.l		m_shield
spec_snd::						;sound that is played when each special weapon is fired
	dc.b		MAGNET_SND			;magnet
	dc.b		TRACER_SND			;tracer
	dc.b		BEAM_SND				;beam
	dc.b		EXPLOS1_SND			;flash
	dc.b		LAUNCH_SND			;missile
	dc.b		RINGWPN_SND			;ring
	dc.b		ELECTRIC_SND			;bolt
	dc.b		SHIELD_SND			;shield

specssnd::						;sound that is played when each special weapon is selected
	dc.b		SELECTX_SND			;magnet
	dc.b		SELECTX_SND			;tracer
	dc.b		SELECTX_SND			;beam
	dc.b		SELECTX_SND			;flash
	dc.b		SELECTX_SND			;missile
	dc.b		SELECTX_SND			;ring
	dc.b		SELECTX_SND			;bolt
	dc.b		SELECTX_SND			;shield
	dc.b		SELECTX_SND			;cutter
	.even

specblit::						;information to blit each special weapon
;data address in rom for each special weapon object
;B_COUNT value for blitting data
;A1_STEP value
;A1_FLAGS, A2_FLAGS value
	dc.l		magrom,		$00130018,	$0001FFE8,	PITCH1|PIXEL16|XADDPHR|WID24			;magnet
	dc.l		tracerm0,		$00140018,	$0001FFE8,	PITCH1|PIXEL16|XADDPHR|WID24			;tracer
	dc.l		beamrom,		$00040008,	$0001FFF8,	PITCH1|PIXEL8|XADDPHR|WID8			;beam
	dc.l		0,			0,			0,			0								;flash - specflsh is used instead of spec_weapon object
	dc.l		missrom,		$00090018,	$0001FFE8,	PITCH1|PIXEL8|XADDPHR|WID24			;missile
	dc.l		ringrom,		$00140018,	$0001FFE8,	PITCH1|PIXEL16|XADDPHR|WID24			;ring
	dc.l		bolttop,		$00090010,	$0001FFF0,	PITCH1|PIXEL16|XADDPHR|WID16			;bolt
	dc.l		shield00,		$00350020,	$0001FFE0,	PITCH1|PIXEL32|XADDPHR|WID32			;shield
spec_ht::							;height of each special weapon object
	dc.w		19					;magnet
	dc.w		20					;tracer
	dc.w		4					;beam
	dc.w		0					;flash - specflsh object is used instead of spec_weapon
	dc.w		9					;missile
	dc.w		20					;ring
	dc.w		18					;bolt - this is the starting height
	dc.w		53					;shield
specinfw::
;add first number to player xpos to get starting X position for each special weapon object
;add second number to player ypos to get starting Y position for each special weapon object
;third number is dwidth
;fourth number is iwidth
	dc.w		 26,		 -4,	  6,	  6		;magnet
	dc.w		 20,		 -4,	  6,	  6		;tracer
	dc.w		BEAM_X,BEAM_Y,	  1,	  1		;beam
	dc.w		  8,		  0,	  0,	  0		;flash (has its own object header so it can display over foreground objects)
	dc.w		 18,		  4,	  3,	  3		;missile
	dc.w		  0,		  0,	  6,	  6		;ring
	dc.w		 24,		 -2,	  4,	  4		;bolt
	dc.w		SHLD_X,SHLD_Y,	 16,	 16		;shield
specinfb::
;O_FLAGS setting for each special weapon object
;O_DEPTH
;O_INDEX
;O_PITCH
	dc.b		TRANS_ON,	4,	0,	1	;magnet
	dc.b		TRANS_ON,	4,	0,	1	;tracer
	dc.b		0,		3,	0,	0	;beam
	dc.b		0,		0,	0,	0	;flash
	dc.b		TRANS_ON,	3,	0,	1	;missile
	dc.b		TRANS_ON,	4,	0,	1	;ring
	dc.b		TRANS_ON,	4,	0,	1	;bolt
	dc.b		TRANS_ON,	4,	0,	1	;shield
tracdata::
	dc.l		tracerm0,tracerm1,tracerm2
spec_icons::
	dc.l		magicn,traceicn,beamicn,flashicn,missicn,ringicn,bolticn,shldicn,cutricn

ringoffs::					;distance from player ship for each ringstep
;add first number to player xpos to get ring xpos
;add second number to player ypos to get ring ypos
	dc.w		 73,  8			;to right of ship
	dc.w		 73,  8
	dc.w		 72,-16
	dc.w		 67,-38
	dc.w		 56,-52
	dc.w		 45,-60
	dc.w		 31,-64
	dc.w		 17,-64			;straight above ship
	dc.w		  3,-64
	dc.w		-10,-60
	dc.w		-21,-52
	dc.w		-32,-38
	dc.w		-37,-16
	dc.w		-38,  8			;to left of ship
	dc.w		-37, 24
	dc.w		-32, 54
	dc.w		-21, 70
	dc.w		-10, 78
	dc.w		  3, 82
	dc.w		 17, 82			;below ship
	dc.w		 31, 82
	dc.w		 45, 78
	dc.w		 56, 70
	dc.w		 67, 54
	dc.w		 72, 32


;TABLES FOR LOADING ENEMIES AT THE BEGINNING OF A LEVEL
;source address in rom
;destination address in ram
;width of data in 8 pixel blocks
;width setting for blitter
;compression quality (dq.abs table to use)
;loading stops when the destination address in ram is 0

;destination address for mask
;width setting for blitter
;B_COUNT setting for blitter
;A1_STEP, A2_STEP settings for blitter
;source address for mask data
;size of mask
;stop when destination address is 0
;******************************************************************************
spc_en0::
	dc.l	bigrocks,	bigrok00,	6,	WID48,	q65		;big rock		48 x 752	(48 x 47, 16 frames)
	dc.l	medrocks,	medrok00,	4,	WID32,	q65		;med rock		32 x 368	(32 x 23, 16 frames)
	dc.l	smlrocks,	smlrok00,	2,	WID16,	q65		;sml rock		16 x 176	(16 x 11, 16 frames)
	dc.l	mdcrsa,	mdcrsa00,	4,	WID32,	q65		;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb,	mdcrsb00,	4,	WID32,	q65		;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcryst,	bigcrs00,	8,	WID64,	q65		;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar,	bigstar0,	8,	WID64,	q65		;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar,	medstar0,	4,	WID32,	q65		;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	burplb,	burplb00,	8,	WID64,	q65		;big burple	64 x 600	(64 x xx, 16 frames)
	dc.l	burpls,	burpls00,	4,	WID32,	q65		;sml burple	32 x 304	(32 x xx, 16 frames)
	dc.l	bubblb,	bubblb00,	8,	WID64,	q65		;big bubble	64 x 576	(64 x xx, 16 frames)
	dc.l	bubbls,	bubbls00,	4,	WID32,	q65		;sml bubble	64 x 288	(32 x xx, 16 frames)
	dc.l	cube,	cube00,	6,	WID48,	q65		;cube		48 x 664	(48 x 39, 17 frames)
	dc.l	sphere,	sphere00,	6,	WID48,	q65		;sphere		48 x 760	(48 x xx, 25 frames)
	dc.l	0
spc_en0m::
	dc.l	bigrok00,	WID48,	$02F00030,	$0001FFD0,	bigrk_m,	(48*752/8)	;big rock		48 x 752	(48 x 47, 16 frames)
	dc.l	medrok00,	WID32,	$01700020,	$0001FFE0,	mrock_m,	(32*368/8)	;med rock		32 x 368	(32 x 23, 16 frames)
	dc.l	smlrok00,	WID16,	$00B00010,	$0001FFF0,	smlrk_m,	(16*176/8)	;sml rock		16 x 176	(16 x 11, 16 frames)
	dc.l	mdcrsa00,	WID32,	$01700020,	$0001FFE0,	mcrysa_m,	(32*368/8)	;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb00,	WID32,	$01700020,	$0001FFE0,	mcrysb_m,	(32*368/8)	;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcrs00,	WID64,	$02000040,	$0001FFC0,	bcrst_m,	(64*512/8)	;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar0,	WID64,	$01000040,	$0001FFC0,	bstar_m,	(64*256/8)	;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar0,	WID32,	$00800020,	$0001FFE0,	mstar_m,	(32*128/8)	;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	burplb00,	WID64,	$02560040,	$0001FFC0,	burplb_m,	(64*598/8)	;big burple	64 x 598	(64 x xx, 16 frames)
	dc.l	burpls00,	WID32,	$012D0020,	$0001FFE0,	burpls_m,	(32*301/8)	;sml burple	32 x 301	(32 x xx, 16 frames)
	dc.l	bubblb00,	WID64,	$023B0040,	$0001FFC0,	bubblb_m,	(64*571/8)	;big bubble	64 x 571	(64 x xx, 16 frames)
	dc.l	bubbls00,	WID32,	$011B0020,	$0001FFE0,	bubbls_m,	(32*283/8)	;sml bubble	32 x 283	(32 x xx, 16 frames)
	dc.l	cube00,	WID48,	$02970030,	$0001FFD0,	cube_m,	(48*663/8)	;cube		48 x 663	(48 x 39, 17 frames)
	dc.l	sphere00,	WID48,	$02F70030,	$0001FFD0,	sphere_m,	(48*759/8)	;sphere		48 x 759	(48 x xx, 25 frames)
	dc.l	0
spc_en1::
	dc.l	mdcrsa,	mdcrsa00,	4,	WID32,	q65		;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb,	mdcrsb00,	4,	WID32,	q65		;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcryst,	bigcrs00,	8,	WID64,	q65		;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar,	bigstar0,	8,	WID64,	q65		;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar,	medstar0,	4,	WID32,	q65		;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	prockb,	prockb00,	8,	WID64,	q65		;big purp rock	64 x 704	(64 x xx, 14 frames)
	dc.l	prockm,	prockm00,	4,	WID32,	q65		;med purp rock	32 x 360	(32 x xx, 14 frames)
	dc.l	procks,	procks00,	2,	WID16,	q65		;sml purp rock	16 x 184	(16 x xx, 14 frames)
	dc.l	burplb,	burplb00,	8,	WID64,	q65		;big burple	64 x 600	(64 x xx, 16 frames)
	dc.l	burpls,	burpls00,	4,	WID32,	q65		;sml burple	32 x 304	(32 x xx, 16 frames)
	dc.l	bubblb,	bubblb00,	8,	WID64,	q65		;big bubble	64 x 576	(64 x xx, 16 frames)
	dc.l	bubbls,	bubbls00,	4,	WID32,	q65		;sml bubble	64 x 288	(32 x xx, 16 frames)
	dc.l	cube,	cube00,	6,	WID48,	q65		;cube		48 x 664	(48 x 39, 17 frames)
	dc.l	sphere,	sphere00,	6,	WID48,	q65		;sphere		48 x 760	(48 x xx, 25 frames)
	dc.l	0
spc_en1m::
	dc.l	mdcrsa00,	WID32,	$01700020,	$0001FFE0,	mcrysa_m,	(32*368/8)	;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb00,	WID32,	$01700020,	$0001FFE0,	mcrysb_m,	(32*368/8)	;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcrs00,	WID64,	$02000040,	$0001FFC0,	bcrst_m,	(64*512/8)	;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar0,	WID64,	$01000040,	$0001FFC0,	bstar_m,	(64*256/8)	;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar0,	WID32,	$00800020,	$0001FFE0,	mstar_m,	(32*128/8)	;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	prockb00,	WID64,	$02BC0040,	$0001FFC0,	prockb_m,	(64*700/8)	;big purp rock	64 x 700	(64 x xx, 14 frames)
	dc.l	prockm00,	WID32,	$01680020,	$0001FFE0,	prockm_m,	(32*360/8)	;med purp rock	32 x 360	(32 x xx, 14 frames)
	dc.l	procks00,	WID16,	$00B60010,	$0001FFF0,	procks_m,	(16*182/8)	;sml purp rock	16 x 182	(16 x xx, 14 frames)
	dc.l	burplb00,	WID64,	$02560040,	$0001FFC0,	burplb_m,	(64*598/8)	;big burple	64 x 598	(64 x xx, 16 frames)
	dc.l	burpls00,	WID32,	$012D0020,	$0001FFE0,	burpls_m,	(32*301/8)	;sml burple	32 x 301	(32 x xx, 16 frames)
	dc.l	bubblb00,	WID64,	$023B0040,	$0001FFC0,	bubblb_m,	(64*571/8)	;big bubble	64 x 571	(64 x xx, 16 frames)
	dc.l	bubbls00,	WID32,	$011B0020,	$0001FFE0,	bubbls_m,	(32*283/8)	;sml bubble	32 x 283	(32 x xx, 16 frames)
	dc.l	cube00,	WID48,	$02970030,	$0001FFD0,	cube_m,	(48*663/8)	;cube		48 x 663	(48 x 39, 17 frames)
	dc.l	sphere00,	WID48,	$02F70030,	$0001FFD0,	sphere_m,	(48*759/8)	;sphere		48 x 759	(48 x xx, 25 frames)
	dc.l	0
spc_en2::
	dc.l	mdcrsa,	mdcrsa00,	4,	WID32,	q65		;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb,	mdcrsb00,	4,	WID32,	q65		;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcryst,	bigcrs00,	8,	WID64,	q65		;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar,	bigstar0,	8,	WID64,	q65		;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar,	medstar0,	4,	WID32,	q65		;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	burplb,	burplb00,	8,	WID64,	q65		;big burple	64 x 600	(64 x xx, 16 frames)
	dc.l	burpls,	burpls00,	4,	WID32,	q65		;sml burple	32 x 304	(32 x xx, 16 frames)
	dc.l	bubblb,	bubblb00,	8,	WID64,	q65		;big bubble	64 x 576	(64 x xx, 16 frames)
	dc.l	bubbls,	bubbls00,	4,	WID32,	q65		;sml bubble	64 x 288	(32 x xx, 16 frames)
	dc.l	pebblb,	pebblb00,	8,	WID64,	q65		;big pebble	64 x 672	(64 x 42, 16 frames)
	dc.l	pebblm,	pebblm00,	6,	WID48,	q65		;med pebble	48 x 384	(48 x 24, 16 frames)
	dc.l	pebbls,	pebbls00,	2,	WID16,	q65		;sml pebble	16 x 192	(16 x 12, 16 frames)
	dc.l	cube,	cube00,	6,	WID48,	q65		;cube		48 x 664	(48 x 39, 17 frames)
	dc.l	sphere,	sphere00,	6,	WID48,	q65		;sphere		48 x 760	(48 x xx, 25 frames)
	dc.l	0
spc_en2m::
	dc.l	mdcrsa00,	WID32,	$01700020,	$0001FFE0,	mcrysa_m,	(32*368/8)	;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb00,	WID32,	$01700020,	$0001FFE0,	mcrysb_m,	(32*368/8)	;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcrs00,	WID64,	$02000040,	$0001FFC0,	bcrst_m,	(64*512/8)	;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar0,	WID64,	$01000040,	$0001FFC0,	bstar_m,	(64*256/8)	;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar0,	WID32,	$00800020,	$0001FFE0,	mstar_m,	(32*128/8)	;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	burplb00,	WID64,	$02560040,	$0001FFC0,	burplb_m,	(64*598/8)	;big burple	64 x 598	(64 x xx, 16 frames)
	dc.l	burpls00,	WID32,	$012D0020,	$0001FFE0,	burpls_m,	(32*301/8)	;sml burple	32 x 301	(32 x xx, 16 frames)
	dc.l	bubblb00,	WID64,	$023B0040,	$0001FFC0,	bubblb_m,	(64*571/8)	;big bubble	64 x 571	(64 x xx, 16 frames)
	dc.l	bubbls00,	WID32,	$011B0020,	$0001FFE0,	bubbls_m,	(32*283/8)	;sml bubble	32 x 283	(32 x xx, 16 frames)
	dc.l	pebblb00,	WID64,	$02A00040,	$0001FFC0,	pebblb_m,	(64*672/8)	;big pebble	64 x 672	(64 x 42, 16 frames)
	dc.l	pebblm00,	WID48,	$01800030,	$0001FFD0,	pebblm_m,	(48*384/8)	;med pebble	48 x 384	(48 x 24, 16 frames)
	dc.l	pebbls00,	WID16,	$00C00010,	$0001FFF0,	pebbls_m,	(16*192/8)	;sml pebble	16 x 192	(16 x 12, 16 frames)
	dc.l	cube00,	WID48,	$02970030,	$0001FFD0,	cube_m,	(48*663/8)	;cube		48 x 663	(48 x 39, 17 frames)
	dc.l	sphere00,	WID48,	$02F70030,	$0001FFD0,	sphere_m,	(48*759/8)	;sphere		48 x 759	(48 x xx, 25 frames)
	dc.l	0
spc_en3::
	dc.l	bigrocks,	bigrok00,	6,	WID48,	q65		;big rock		48 x 752	(48 x 47, 16 frames)
	dc.l	medrocks,	medrok00,	4,	WID32,	q65		;med rock		32 x 368	(32 x 23, 16 frames)
	dc.l	smlrocks,	smlrok00,	2,	WID16,	q65		;sml rock		16 x 176	(16 x 11, 16 frames)
	dc.l	mdcrsa,	mdcrsa00,	4,	WID32,	q65		;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb,	mdcrsb00,	4,	WID32,	q65		;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcryst,	bigcrs00,	8,	WID64,	q65		;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar,	bigstar0,	8,	WID64,	q65		;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar,	medstar0,	4,	WID32,	q65		;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	prockb,	prockb00,	8,	WID64,	q65		;big purp rock	64 x 704	(64 x xx, 14 frames)
	dc.l	prockm,	prockm00,	4,	WID32,	q65		;med purp rock	32 x 360	(32 x xx, 14 frames)
	dc.l	procks,	procks00,	2,	WID16,	q65		;sml purp rock	16 x 184	(16 x xx, 14 frames)
	dc.l	burplb,	burplb00,	8,	WID64,	q65		;big burple	64 x 600	(64 x xx, 16 frames)
	dc.l	burpls,	burpls00,	4,	WID32,	q65		;sml burple	32 x 304	(32 x xx, 16 frames)
	dc.l	bubblb,	bubblb00,	8,	WID64,	q65		;big bubble	64 x 576	(64 x xx, 16 frames)
	dc.l	bubbls,	bubbls00,	4,	WID32,	q65		;sml bubble	64 x 288	(32 x xx, 16 frames)
	dc.l	pebblb,	pebblb00,	8,	WID64,	q65		;big pebble	64 x 672	(64 x 42, 16 frames)
	dc.l	pebblm,	pebblm00,	6,	WID48,	q65		;med pebble	48 x 384	(48 x 24, 16 frames)
	dc.l	pebbls,	pebbls00,	2,	WID16,	q65		;sml pebble	16 x 192	(16 x 12, 16 frames)
	dc.l	cube,	cube00,	6,	WID48,	q65		;cube		48 x 664	(48 x 39, 17 frames)
	dc.l	tri,		tri00,	6,	WID48,	q65		;tri			48 x 496	(48 x 31, 16 frames)
	dc.l	trisht0,	tri16,	2,	WID16,	q65		;tri top piece	16 x  32	(16 x  7,  4 frames)
	dc.l	trisht1,	tri20,	4,	WID32,	q65		;tri topmid pc	32 x  48	(32 x 11,  4 frames)
	dc.l	trisht2,	tri24,	4,	WID32,	q65		;tri botmid pc	32 x  56	(32 x 13,  4 frames)
	dc.l	0
spc_en3m::
	dc.l	bigrok00,	WID48,	$02F00030,	$0001FFD0,	bigrk_m,	(48*752/8)	;big rock		48 x 752	(48 x 47, 16 frames)
	dc.l	medrok00,	WID32,	$01700020,	$0001FFE0,	mrock_m,	(32*368/8)	;med rock		32 x 368	(32 x 23, 16 frames)
	dc.l	smlrok00,	WID16,	$00B00010,	$0001FFF0,	smlrk_m,	(16*176/8)	;sml rock		16 x 176	(16 x 11, 16 frames)
	dc.l	mdcrsa00,	WID32,	$01700020,	$0001FFE0,	mcrysa_m,	(32*368/8)	;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb00,	WID32,	$01700020,	$0001FFE0,	mcrysb_m,	(32*368/8)	;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcrs00,	WID64,	$02000040,	$0001FFC0,	bcrst_m,	(64*512/8)	;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar0,	WID64,	$01000040,	$0001FFC0,	bstar_m,	(64*256/8)	;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar0,	WID32,	$00800020,	$0001FFE0,	mstar_m,	(32*128/8)	;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	prockb00,	WID64,	$02BC0040,	$0001FFC0,	prockb_m,	(64*700/8)	;big purp rock	64 x 700	(64 x xx, 14 frames)
	dc.l	prockm00,	WID32,	$01680020,	$0001FFE0,	prockm_m,	(32*360/8)	;med purp rock	32 x 360	(32 x xx, 14 frames)
	dc.l	procks00,	WID16,	$00B60010,	$0001FFF0,	procks_m,	(16*182/8)	;sml purp rock	16 x 182	(16 x xx, 14 frames)
	dc.l	burplb00,	WID64,	$02560040,	$0001FFC0,	burplb_m,	(64*598/8)	;big burple	64 x 598	(64 x xx, 16 frames)
	dc.l	burpls00,	WID32,	$012D0020,	$0001FFE0,	burpls_m,	(32*301/8)	;sml burple	32 x 301	(32 x xx, 16 frames)
	dc.l	bubblb00,	WID64,	$023B0040,	$0001FFC0,	bubblb_m,	(64*571/8)	;big bubble	64 x 571	(64 x xx, 16 frames)
	dc.l	bubbls00,	WID32,	$011B0020,	$0001FFE0,	bubbls_m,	(32*283/8)	;sml bubble	32 x 283	(32 x xx, 16 frames)
	dc.l	pebblb00,	WID64,	$02A00040,	$0001FFC0,	pebblb_m,	(64*672/8)	;big pebble	64 x 672	(64 x 42, 16 frames)
	dc.l	pebblm00,	WID48,	$01800030,	$0001FFD0,	pebblm_m,	(48*384/8)	;med pebble	48 x 384	(48 x 24, 16 frames)
	dc.l	pebbls00,	WID16,	$00C00010,	$0001FFF0,	pebbls_m,	(16*192/8)	;sml pebble	16 x 192	(16 x 12, 16 frames)
	dc.l	cube00,	WID48,	$02970030,	$0001FFD0,	cube_m,	(48*663/8)	;cube		48 x 663	(48 x 39, 17 frames)
	dc.l	tri00,	WID48,	$01F00030,	$0001FFD0,	tri_m,	(48*496/8)	;tri			48 x 496	(48 x 31, 16 frames)
	dc.l	tri16,	WID16,	$001C0010,	$0001FFF0,	tri0_m,	(16*28/8)		;tri top piece	16 x  28	(16 x  7,  4 frames)
	dc.l	tri20,	WID32,	$002C0020,	$0001FFE0,	tri1_m,	(32*44/8)		;tri topmid pc	32 x  44	(32 x 11,  4 frames)
	dc.l	tri24,	WID32,	$00340020,	$0001FFE0,	tri2_m,	(32*52/8)		;tri botmid pc	32 x  52	(32 x 13,  4 frames)
	dc.l	0
spc_en4::
	dc.l	bigrocks,	bigrok00,	6,	WID48,	q65		;big rock		48 x 752	(48 x 47, 16 frames)
	dc.l	medrocks,	medrok00,	4,	WID32,	q65		;med rock		32 x 368	(32 x 23, 16 frames)
	dc.l	smlrocks,	smlrok00,	2,	WID16,	q65		;sml rock		16 x 176	(16 x 11, 16 frames)
	dc.l	mdcrsa,	mdcrsa00,	4,	WID32,	q65		;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb,	mdcrsb00,	4,	WID32,	q65		;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcryst,	bigcrs00,	8,	WID64,	q65		;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar,	bigstar0,	8,	WID64,	q65		;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar,	medstar0,	4,	WID32,	q65		;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	prockb,	prockb00,	8,	WID64,	q65		;big purp rock	64 x 704	(64 x xx, 14 frames)
	dc.l	prockm,	prockm00,	4,	WID32,	q65		;med purp rock	32 x 360	(32 x xx, 14 frames)
	dc.l	procks,	procks00,	2,	WID16,	q65		;sml purp rock	16 x 184	(16 x xx, 14 frames)
	dc.l	burplb,	burplb00,	8,	WID64,	q65		;big burple	64 x 600	(64 x xx, 16 frames)
	dc.l	burpls,	burpls00,	4,	WID32,	q65		;sml burple	32 x 304	(32 x xx, 16 frames)
	dc.l	bubblb,	bubblb00,	8,	WID64,	q65		;big bubble	64 x 576	(64 x xx, 16 frames)
	dc.l	bubbls,	bubbls00,	4,	WID32,	q65		;sml bubble	64 x 288	(32 x xx, 16 frames)
	dc.l	pebblb,	pebblb00,	8,	WID64,	q65		;big pebble	64 x 672	(64 x 42, 16 frames)
	dc.l	pebblm,	pebblm00,	6,	WID48,	q65		;med pebble	48 x 384	(48 x 24, 16 frames)
	dc.l	pebbls,	pebbls00,	2,	WID16,	q65		;sml pebble	16 x 192	(16 x 12, 16 frames)
	dc.l	cube,	cube00,	6,	WID48,	q65		;cube		48 x 664	(48 x 39, 17 frames)
	dc.l	tri,		tri00,	6,	WID48,	q65		;tri			48 x 496	(48 x 31, 16 frames)
	dc.l	trisht0,	tri16,	2,	WID16,	q65		;tri top piece	16 x  32	(16 x  7,  4 frames)
	dc.l	trisht1,	tri20,	4,	WID32,	q65		;tri topmid pc	32 x  48	(32 x 11,  4 frames)
	dc.l	trisht2,	tri24,	4,	WID32,	q65		;tri botmid pc	32 x  56	(32 x 13,  4 frames)
	dc.l	0
spc_en4m::
	dc.l	bigrok00,	WID48,	$02F00030,	$0001FFD0,	bigrk_m,	(48*752/8)	;big rock		48 x 752	(48 x 47, 16 frames)
	dc.l	medrok00,	WID32,	$01700020,	$0001FFE0,	mrock_m,	(32*368/8)	;med rock		32 x 368	(32 x 23, 16 frames)
	dc.l	smlrok00,	WID16,	$00B00010,	$0001FFF0,	smlrk_m,	(16*176/8)	;sml rock		16 x 176	(16 x 11, 16 frames)
	dc.l	mdcrsa00,	WID32,	$01700020,	$0001FFE0,	mcrysa_m,	(32*368/8)	;med crystal A	32 x 368	(32 x 23, 16 frames)
	dc.l	mdcrsb00,	WID32,	$01700020,	$0001FFE0,	mcrysb_m,	(32*368/8)	;med crystal B	32 x 368	(32 x 23, 16 frames)
	dc.l	bigcrs00,	WID64,	$02000040,	$0001FFC0,	bcrst_m,	(64*512/8)	;big crystal	64 x 512	(64 x 64,  8 frames)
	dc.l	bigstar0,	WID64,	$01000040,	$0001FFC0,	bstar_m,	(64*256/8)	;big star		64 x 256	(64 x 63,  4 frames)
	dc.l	medstar0,	WID32,	$00800020,	$0001FFE0,	mstar_m,	(32*128/8)	;med star		32 x 128	(32 x 31,  4 frames)
	dc.l	prockb00,	WID64,	$02BC0040,	$0001FFC0,	prockb_m,	(64*700/8)	;big purp rock	64 x 700	(64 x xx, 14 frames)
	dc.l	prockm00,	WID32,	$01680020,	$0001FFE0,	prockm_m,	(32*360/8)	;med purp rock	32 x 360	(32 x xx, 14 frames)
	dc.l	procks00,	WID16,	$00B60010,	$0001FFF0,	procks_m,	(16*182/8)	;sml purp rock	16 x 182	(16 x xx, 14 frames)
	dc.l	burplb00,	WID64,	$02560040,	$0001FFC0,	burplb_m,	(64*598/8)	;big burple	64 x 598	(64 x xx, 16 frames)
	dc.l	burpls00,	WID32,	$012D0020,	$0001FFE0,	burpls_m,	(32*301/8)	;sml burple	32 x 301	(32 x xx, 16 frames)
	dc.l	bubblb00,	WID64,	$023B0040,	$0001FFC0,	bubblb_m,	(64*571/8)	;big bubble	64 x 571	(64 x xx, 16 frames)
	dc.l	bubbls00,	WID32,	$011B0020,	$0001FFE0,	bubbls_m,	(32*283/8)	;sml bubble	32 x 283	(32 x xx, 16 frames)
	dc.l	pebblb00,	WID64,	$02A00040,	$0001FFC0,	pebblb_m,	(64*672/8)	;big pebble	64 x 672	(64 x 42, 16 frames)
	dc.l	pebblm00,	WID48,	$01800030,	$0001FFD0,	pebblm_m,	(48*384/8)	;med pebble	48 x 384	(48 x 24, 16 frames)
	dc.l	pebbls00,	WID16,	$00C00010,	$0001FFF0,	pebbls_m,	(16*192/8)	;sml pebble	16 x 192	(16 x 12, 16 frames)
	dc.l	cube00,	WID48,	$02970030,	$0001FFD0,	cube_m,	(48*663/8)	;cube		48 x 663	(48 x 39, 17 frames)
	dc.l	tri00,	WID48,	$01F00030,	$0001FFD0,	tri_m,	(48*496/8)	;tri			48 x 496	(48 x 31, 16 frames)
	dc.l	tri16,	WID16,	$001C0010,	$0001FFF0,	tri0_m,	(16*28/8)		;tri top piece	16 x  28	(16 x  7,  4 frames)
	dc.l	tri20,	WID32,	$002C0020,	$0001FFE0,	tri1_m,	(32*44/8)		;tri topmid pc	32 x  44	(32 x 11,  4 frames)
	dc.l	tri24,	WID32,	$00340020,	$0001FFE0,	tri2_m,	(32*52/8)		;tri botmid pc	32 x  52	(32 x 13,  4 frames)
	dc.l	0
des_en::
	dc.l	rat,		trat00,	8,	WID64,	q65		;rat			64 x 776	(64 x xx, 19 frames)
	dc.l	scrpb,	scorp00b,	24,	WID192,	q65		;big scorp	192x 592	(192x 98,  6 frames)
	dc.l	scrps,	scorp00s,	4,	WID32,	q65		;sml scorp	32 x  96	(32 x 16,  6 frames)
	dc.l	fbug,	fbug00,	6,	WID48,	q65		;firebug		48 x 848	(48 x xx, 19 frames)
	dc.l	vult,	vult00,	8,	WID64,	q65		;vulture		64 x1128	(64 x xx, 32 frames)
	dc.l	ball,	ball00,	8,	WID64,	q65		;ball		64 x  48
	dc.l	geyser,	geyser00,	6,	WID48,	q65		;geyser		48 x 744
	dc.l	poppy0,	poppy00,	4,	WID32,	q65		;poppy0		32 x  64
	dc.l	poppy1,	poppy01,	2,	WID16,	q65		;poppy1		16 x  48
	dc.l	poppy2,	poppy02,	4,	WID32,	q65		;poppy2		32 x  80
	dc.l	dsob00,	dso00,	40,	WID320,	q65		;arch		320x  96
	dc.l	dsob01,	dso01,	20,	WID160,	q65		;triangle rock	160x  72
	dc.l	dsob02,	dso02,	28,	WID224,	q65		;half arch	224x  104
	dc.l	dsob03,	dso03,	24,	WID192,	q65		;rock w/pole	192x  88
	dc.l	dsob04,	dso04,	20,	WID160,	q65		;tri rock		160x  80
	dc.l	0
des_enm::
	dc.l	trat00,	WID64,	$03070040,	$0001FFC0,	rat_m,	(64*775/8)	;rat			64 x 775	(64 x xx, 19 frames)
	dc.l	scorp00b,	WID192,	$024C00C0,	$0001FF40,	scrpb_m,	(192*588/8)	;big scorp	192x 588	(192x 98,  6 frames)
	dc.l	scorp00s,	WID32,	$00600020,	$0001FFE0,	scrps_m,	(32*96/8)		;sml scorp	32 x  96	(32 x 16,  6 frames)
	dc.l	fbug00,	WID48,	$034B0030,	$0001FFD0,	fbug_m,	(48*843/8)	;firebug		48 x 843	(48 x xx, 19 frames)
	dc.l	vult00,	WID64,	$04640040,	$0001FFC0,	vult_m,	(64*1124/8)	;vulture		64 x1124	(64 x xx, 32 frames)
	dc.l	ball00,	WID64,	$00300040,	$0001FFC0,	ball_m,	(64*48/8)		;ball		64 x  48
	dc.l	geyser00,	WID48,	$02E60030,	$0001FFD0,	geyser_m,	(48*742/8)	;geyser		48 x 742
	dc.l	poppy00,	WID32,	$00390020,	$0001FFE0,	poppy0m,	(32*57/8)		;poppy0		32 x  57
	dc.l	poppy01,	WID16,	$00290010,	$0001FFF0,	poppy1m,	(16*41/8)		;poppy1		16 x  41
	dc.l	poppy02,	WID32,	$004A0020,	$0001FFE0,	poppy2m,	(32*74/8)		;poppy2		32 x  74
	dc.l	dso00,	WID320,	$00600140,	$0001FEC0,	dsob0m,	(320*96/8)	;arch		320x  96
	dc.l	dso01,	WID160,	$004800A0,	$0001FF60,	dsob1m,	(160*72/8)	;triangle rock	160x  72
	dc.l	dso02,	WID224,	$006800E0,	$0001FF20,	dsob2m,	(224*104/8)	;half arch	224x  104
	dc.l	dso03,	WID192,	$005800C0,	$0001FF40,	dsob3m,	(192*88/8)	;rock w/pole	192x  88
	dc.l	dso04,	WID160,	$005000A0,	$0001FF60,	dsob4m,	(160*80/8)	;tri rock		160x  80
	dc.l	0
sw_en::
	dc.l	spore,	spore0,	8,	WID64,	q65		;spore		64 x 336	(64 x 48,	 7 frames)
	dc.l	fern,	fern0,	4,	WID32,	q65		;fern		32 x 224	(32 x 28,  8 frames)
	dc.l	pbug,	pillbug0,	2,	WID16,	q65		;pillbug		16 x 128	(16 x 16,  8 frames)
	dc.l	pexp,	pillexp0,	4,	WID32,	q65		;pillbug exp	32 x  72	(32 x 24,  3 frames)
	dc.l	seym,	seymor0,	6,	WID48,	q65		;seymour		48 x 368	(48 x 52,  7 frames)
	dc.l	seymexp,	seymexp0,	6,	WID48,	q65		;seymour exp	48 x 256	(48 x 64,  4 frames)
	dc.l	bskull,	bskull0,	4,	WID32,	q65		;batskull		32 x 232	(32 x 29,  8 frames)
	dc.l	flwr,	flwr00,	2,	WID16,	q65		;flower		16 x 112	(16 x 16,	 7 frames)
	dc.l	gund,	gund00,	4,	WID32,	q65		;gundino		32 x 160	(32 x 22,	 7 frames)
	dc.l	kilrun,	kilrun00,	6,	WID48,	q65		;kilrun		48 x 376	(48 x xx,	 8 frames)
	dc.l	sadmsk,	sadmsk00,	6,	WID48,	q65		;sadmask		48 x 464	(48 x xx,	10 frames)
	dc.l	ffly,	ffly00,	4,	WID32,	q65		;firefly		32 x 128	(32 x 21,	 6 frames)
	dc.l	buggy,	buggy0,	6,	WID48,	q65		;buggy		48 x 328	(48 x 27, 12 frames)
	dc.l	moss,	moss0,	16,	WID128,	q65		;moss		128x  96
	dc.l	mossrk,	mossrk0,	24,	WID192,	q65		;moss rock	192x 144
	dc.l	stump,	stump0,	20,	WID160,	q65		;stump		160x 144
	dc.l	tree,	tree0,	20,	WID160,	q65		;tree		160x 288
	dc.l	0
sw_enm::
	dc.l	spore0,	WID64,	$01500040,	$0001FFC0,	spore_m,	(64*336/8)	;spore		64 x 336	(64 x 48,	 7 frames)
	dc.l	fern0,	WID32,	$00E00020,	$0001FFE0,	fern_m,	(32*224/8)	;fern		32 x 224	(32 x 28,  8 frames)
	dc.l	pillbug0,	WID16,	$00800010,	$0001FFF0,	pbug_m,	(16*128/8)	;pillbug		16 x 128	(16 x 16,  8 frames)
	dc.l	pillexp0,	WID32,	$00480020,	$0001FFE0,	pexp_m,	(32*72/8)		;pillbug exp	32 x  72	(32 x 24,  3 frames)
	dc.l	seymor0,	WID48,	$01700030,	$0001FFD0,	seym_m,	(48*368/8)	;seymour		48 x 368	(48 x 52,  7 frames)
	dc.l	seymexp0,	WID48,	$01000030,	$0001FFD0,	seymex_m,	(48*256/8)	;seymour exp	48 x 256	(48 x 64,  4 frames)
	dc.l	bskull0,	WID32,	$00E80020,	$0001FFE0,	bskull_m,	(32*232/8)	;batskull		32 x 232	(32 x 29,  8 frames)
	dc.l	flwr00,	WID16,	$00700010,	$0001FFF0,	flower_m,	(16*112/8)	;flower		16 x 112	(16 x 16,	 7 frames)
	dc.l	gund00,	WID32,	$009A0020,	$0001FFE0,	gund_m,	(32*154/8)	;gundino		32 x 154	(32 x 22,	 7 frames)
	dc.l	kilrun00,	WID48,	$01720030,	$0001FFD0,	kilrun_m,	(48*370/8)	;kilrun		48 x 370	(48 x xx,	 8 frames)
	dc.l	sadmsk00,	WID48,	$01CE0030,	$0001FFD0,	sadmsk_m,	(48*462/8)	;sadmask		48 x 462	(48 x xx,	10 frames)
	dc.l	ffly00,	WID32,	$007E0020,	$0001FFE0,	ffly_m,	(32*126/8)	;firefly		32 x 126	(24 x 21,	 6 frames)
	dc.l	buggy0,	WID48,	$01440030,	$0001FFD0,	buggy_m,	(48*324/8)	;buggy		48 x 324	(48 x 27, 12 frames)
	dc.l	moss0,	WID128,	$00600080,	$0001FF80,	moss_m,	(128*96/8)	;moss		128x  96
	dc.l	mossrk0,	WID192,	$009000C0,	$0001FF40,	mossrk_m,	(192*144/8)	;moss rock	192x 144
	dc.l	stump0,	WID160,	$009000A0,	$0001FF60,	stump_m,	(160*144/8)	;stump		160 x144
	dc.l	tree0,	WID160,	$012000A0,	$0001FF60,	tree_m,	(160*288/8)	;tree		160 x288
	dc.l	0
cave_en::
	dc.l	bat,		bat00,	8,	WID64,	q65			;bat			64 x 784	(64 x xx, 28 frames)
	dc.l	spidsm,	spidsm00,	6,	WID48,	q65			;small spider	48 x 168	(48 x 28,	 6 frames)
	dc.l	spidbg,	spidbg00,	12,	WID96,	q65			;big spider	96 x 384	(96 x 63,	 6 frames)
	dc.l	slug,	slug00,	6,	WID48,	q65			;slug		48 x 120	(48 x 19,	 6 frames)
	dc.l	dino,	dino00,	24,	WID192,	q65			;big dino		192x 768	(192x 96,	 8 frames)
	dc.l	dinos,	dinos00,	8,	WID64,	q65			;small dino	64 x 256	(64 x 32,	 8 frames)
	dc.l	glowbug,	glow00,	6,	WID48,	q65			;glowbug		48 x 304	(48 x xx,	 8 frames)
	dc.l	cvrock0,	cvrock00,	20,	WID160,	q65			;cave rock 0	160x 128
	dc.l	cvrock1,	cvrock02,	20,	WID160,	q65			;cave rock 1	160x 88
	dc.l	cvrock2,	cvrock04,	6,	WID48,	q65			;falling rock	48 x 80
	dc.l	0
cave_enm::
	dc.l	bat00,	WID64,	$030D0040,	$0001FFC0,	bat_m,	(64*781/8)	;bat			64 x 781	(64 x xx, 28 frames)
	dc.l	spidsm00,	WID48,	$00A80030,	$0001FFD0,	spidsm_m,	(48*168/8)	;small spider	48 x 168	(48 x 28,	 6 frames)
	dc.l	spidbg00,	WID96,	$017A0060,	$0001FFA0,	spidbg_m,	(96*378/8)	;big spider	96 x 378	(96 x 63,	 6 frames)
	dc.l	slug00,	WID48,	$00720030,	$0001FFD0,	slug_m,	(48*114/8)	;slug		48 x 114	(48 x 19,	 6 frames)
	dc.l	dino00,	WID192,	$030000C0,	$0001FF40,	dino_m,	(192*768/8)	;big dino		192x 768	(192x 96,	 8 frames)
	dc.l	dinos00,	WID64,	$01000040,	$0001FFC0,	dinos_m,	(64*256/8)	;small dino	64 x 256	(64 x 32,	 8 frames)
	dc.l	glow00,	WID48,	$012F0030,	$0001FFD0,	glow_m,	(48*303/8)	;glowbug		48 x 303
	dc.l	cvrock00,	WID160,	$008000A0,	$0001FF60,	cvrk0m,	(160*128/8)	;cave rock 0	160x 128
	dc.l	cvrock02,	WID160,	$005800A0,	$0001FF60,	cvrk1m,	(160*88/8)	;cave rock 1	160x  88
	dc.l	cvrock04,	WID48,	$00500030,	$0001FFD0,	cvrk2m,	(48*80/8)		;falling rock	48 x  80
	dc.l	0
air_en::
	dc.l	spinner,	spin00,	6,	WID48,	q65			;spinner		48 x 136	(48 x 17,  8 frames)
	dc.l	humm,	humm00,	4,	WID32,	q65			;hummingbird	32 x 216	(32 x xx, 10 frames)
	dc.l	baby,	baby00,	16,	WID128,	q65			;baby		128x1248	(128x 89, 14 frames)
	dc.l	dragon,	dragon00,	10,	WID80,	q65			;dragon		80 x 320	(80 x xx,  6 frames)
	dc.l	blokb0,	blockb00,	32,	WID256,	q65			;big block 0	256x 144
	dc.l	blokb1,	blockb01,	32,	WID256,	q65			;big block 1	256x 144
	dc.l	blokm,	blockm00,	24,	WID192,	q65			;med block	192x 108
	dc.l	bloks0,	blocks00,	16,	WID128,	q65			;sml block 0	128x  72
	dc.l	bloks1,	blocks01,	16,	WID128,	q65			;sml block 1	128x  72
	dc.l	0
air_enm::
	dc.l	spin00,	WID48,	$00880030,	$0001FFD0,	spin_m,	(48*136/8)	;spinner		48 x 136	(48 x 17,  8 frames)
	dc.l	humm00,	WID32,	$00D50020,	$0001FFE0,	humm_m,	(32*213/8)	;hummingbird	32 x 213	(32 x xx, 10 frames)
	dc.l	baby00,	WID128,	$04E00080,	$0001FF80,	baby_m,	(128*1248/8)	;baby		128x1248	(128x 89,	14 frames)
	dc.l	dragon00,	WID80,	$013F0050,	$0001FFB0,	dragon_m,	(80*319/8)	;dragon		80 x 319	(80 x xx,  6 frames)
	dc.l	blockb00,	WID256,	$00900100,	$0001FF00,	blokb_m,	(256*144/8)	;big block	256x 144
	dc.l	blockb01,	WID256,	$00900100,	$0001FF00,	blokb_m,	(256*144/8)	;big block	256x 144
	dc.l	blockm00,	WID192,	$006C00C0,	$0001FF40,	blokm_m,	(192*108/8)	;med block	192x 108
	dc.l	blocks00,	WID128,	$00480080,	$0001FF80,	bloks_m,	(128*72/8)	;sml block	128x  72
	dc.l	blocks01,	WID128,	$00480080,	$0001FF80,	bloks_m,	(128*72/8)	;sml block	128x  72
	dc.l	0
city_en::
	dc.l	fishtx,	fishtx00,	8,	WID64,	q65			;fish taxi	64 x 872	(64 x xx, 23 frames)
	dc.l	snake0,	snake00,	12,	WID96,	q65			;snake0		96 x 64
	dc.l	snake1,	snake03,	10,	WID80,	q65			;snake1		80 x 96
	dc.l	snake2,	snake05,	8,	WID64,	q65			;snake2		64 x 152
	dc.l	snake3,	snake08,	6,	WID48,	q65			;snake3		48 x 320
	dc.l	snake4,	snake16,	4,	WID32,	q65			;snake4		32 x 208
	dc.l	tower,	tower00,	8,	WID64,	q65			;tower		64 x 160
	dc.l	ming,	ming00,	16,	WID128,	q65			;mingbot		128x  96
	dc.l	robot,	robot00,	20,	WID160,	q65			;robot		160x 448
	dc.l	bldg0,	bldg00,	10,	WID80,	q65			;bldg 0		80 x 112
	dc.l	bldg1,	bldg01,	20,	WID160,	q65			;bldg 1		160x 128
	dc.l	bldg2,	bldg02,	16,	WID128,	q65			;bldg 2		128x 128
	dc.l	bldg3,	bldg03,	14,	WID112,	q65			;bldg 3		112x 88
	dc.l	elec,	elec00,	24,	WID192,	q65			;elec		192x 64
	dc.l	eyelgbl,	eyelgbl0,	8,	WID64,	q65			;big blue eye	64 x 416
	dc.l	eyelggr,	eyelggr0,	8,	WID64,	q65			;big green eye	64 x 416
	dc.l	eyesmbl,	eyesmbl0,	6,	WID48,	q65			;sml blue eye	48 x 312
	dc.l	eyesmgr,	eyesmgr0,	6,	WID48,	q65			;sml green eye	48 x 312
	dc.l	0
city_enm::
	dc.l	fishtx00,	WID64,	$03640040,	$0001FFC0,	fishtx_m,	(64*868/8)	;fish taxi	64 x 868	(64 x xx, 23 frames)
	dc.l	snake00,	WID96,	$00390060,	$0001FFA0,	snake0m,	(96*57/8)		;snake0		96 x  57
	dc.l	snake03,	WID80,	$005B0050,	$0001FFB0,	snake1m,	(80*91/8)		;snake1		80 x  91
	dc.l	snake05,	WID64,	$00960040,	$0001FFC0,	snake2m,	(64*150/8)	;snake2		64 x 150
	dc.l	snake08,	WID48,	$013C0030,	$0001FFD0,	snake3m,	(48*316/8)	;snake3		48 x 316
	dc.l	snake16,	WID32,	$00D00020,	$0001FFE0,	snake4m,	(32*208/8)	;snake4		32 x 208
	dc.l	tower00,	WID64,	$00A00040,	$0001FFC0,	tower_m,	(64*160/8)	;tower		64 x 160
	dc.l	ming00,	WID128,	$00600080,	$0001FF80,	ming_m,	(128*96/8)	;mingbot		128x  96
	dc.l	robot00,	WID160,	$01BA00A0,	$0001FF60,	robot_m,	(160*442/8)	;robot		160x 442
	dc.l	bldg00,	WID80,	$00700050,	$0001FFB0,	bldg0_m,	(80*112/8)	;bldg 0		80 x 112
	dc.l	bldg01,	WID160,	$008000A0,	$0001FF60,	bldg1_m,	(160*128/8)	;bldg 1		160x 128
	dc.l	bldg02,	WID128,	$00800080,	$0001FF80,	bldg2_m,	(128*128/8)	;bldg 2		128x 128
	dc.l	bldg03,	WID112,	$00580070,	$0001FF90,	bldg3_m,	(112*88/8)	;bldg 3		112x 88
	dc.l	elec00,	WID192,	$004000C0,	$0001FF40,	elec_m,	(192*64/8)	;elec		192x 64
	dc.l	eyelgbl0,	WID64,	$01A00040,	$0001FFC0,	eyelg_m,	(64*416/8)	;big blue eye	64 x 416
	dc.l	eyelggr0,	WID64,	$01A00040,	$0001FFC0,	eyelg_m,	(64*416/8)	;big green eye	64 x 416
	dc.l	eyesmbl0,	WID48,	$01380030,	$0001FFD0,	eyesm_m,	(48*312/8)	;sml blue eye	48 x 312
	dc.l	eyesmgr0,	WID48,	$01380030,	$0001FFD0,	eyesm_m,	(48*312/8)	;sml green eye	48 x 312
	dc.l	0
bon_en::
	dc.l	ringl0,	ring00,	10,	WID80,	q65			;large ring b	80 x 136
	dc.l	ringl1,	ring01,	16,	WID128,	q65			;large ring f	128x 184
	dc.l	ringm0,	ring02,	8,	WID64,	q65			;med ring b	64 x 88
	dc.l	ringm1,	ring03,	12,	WID96,	q65			;med ring f	96 x 120
	dc.l	rings0,	ring04,	4,	WID32,	q65			;small ring b	32 x 64
	dc.l	rings1,	ring05,	8,	WID64,	q65			;small ring f	64 x 88
	dc.l	0
bon_enm::
	dc.l	ring00,	WID80,	$00880050,	$0001FFB0,	ringl0m,	(80*136/8)	;large ring b	80 x 136
	dc.l	ring01,	WID128,	$00B80080,	$0001FF80,	ringl1m,	(128*184/8)	;large ring f	128x 184
	dc.l	ring02,	WID64,	$00580040,	$0001FFC0,	ringm0m,	(64*88/8)		;med ring b	64 x 88
	dc.l	ring03,	WID96,	$00780060,	$0001FFA0,	ringm1m,	(96*120/8)	;med ring f	96 x 120
	dc.l	ring04,	WID32,	$00400020,	$0001FFE0,	rings0m,	(32*64/8)		;small ring b	32 x 64
	dc.l	ring05,	WID64,	$00580040,	$0001FFC0,	rings1m,	(64*88/8)		;small ring f	64 x 88
	dc.l	0

;LEVEL TABLES
enload::						;addresses of tables to use for loading enemies at beginning of level
	dc.l		spc_en0,des_en
	dc.l		spc_en1,cave_en
	dc.l		spc_en2,air_en
	dc.l		spc_en3,sw_en
	dc.l		spc_en4,city_en
	dc.l		bon_en

enloadm::						;addresses of tables to use for blitting masks after loading enemies
	dc.l		spc_en0m,des_enm
	dc.l		spc_en1m,cave_enm
	dc.l		spc_en2m,air_enm
	dc.l		spc_en3m,sw_enm
	dc.l		spc_en4m,city_enm
	dc.l		bon_enm
shload::
;source address, destination address, B_COUNT, A1_STEP for each level
	dc.l		univshts,	cubeshot,		$001E0008,	$0001FFF8
	dc.l		desshts,	tratshot,		$005E0008,	$0001FFF8		;desert
	dc.l		univshts,	cubeshot,		$001E0008,	$0001FFF8
	dc.l		cvshts,	slugshot,		$002A0008,	$0001FFF8		;cave
	dc.l		univshts,	cubeshot,		$001E0008,	$0001FFF8
	dc.l		airshts,	hummshot,		$006A0008,	$0001FFF8		;air
	dc.l		univshts,	cubeshot,		$001E0008,	$0001FFF8
	dc.l		swshts,	spit0,		$00EF0008,	$0001FFF8		;swamp
	dc.l		univshts,	cubeshot,		$001E0008,	$0001FFF8
	dc.l		cityshts,	fishtxsh,		$00010008,	$0001FFF8		;city
	dc.l		0

objload::
	dc.l		no_obj,ds_obj
	dc.l		no_obj,cv_obj
	dc.l		no_obj,no_obj
	dc.l		no_obj,no_obj
	dc.l		no_obj,no_obj
	dc.l		no_obj
;source address, destination address, B_COUNT, A1_STEP, A2_STEP, YX pos in destination, A1_FLAGS and A2_FLAGS setting
no_obj::
	dc.l		0
cv_obj::
	dc.l		cvrock00,	cvrock01,	$00800050,	$FFFFFFB0,	$0001FFB0,	$007F0000,	(PITCH1|PIXEL32|WID80|XADDPHR)		;cave rock 0
	dc.l		cvrock02,	cvrock03,	$00580050,	$FFFFFFB0,	$0001FFB0,	$00570000,	(PITCH1|PIXEL32|WID80|XADDPHR)		;cave rock 1
	dc.l		0
ds_obj::
	dc.l		geyser00,	geyser01+(48*12*2),	$00100018,	$0001FFE8,	$0001FFE8,	$00000000,	(PITCH1|PIXEL32|WID24|XADDPHR)
	dc.l		geyser00,	geyser02+(48*32*2),	$00100018,	$0001FFE8,	$0001FFE8,	$00000000,	(PITCH1|PIXEL32|WID24|XADDPHR)
	dc.l		geyser00,	geyser03+(48*69*2),	$00100018,	$0001FFE8,	$0001FFE8,	$00000000,	(PITCH1|PIXEL32|WID24|XADDPHR)
	dc.l		geyser00,	geyser04+(48*108*2),$00100018,	$0001FFE8,	$0001FFE8,	$00000000,	(PITCH1|PIXEL32|WID24|XADDPHR)
	dc.l		geyser00,	geyser05+(48*182*2),$00100018,	$0001FFE8,	$0001FFE8,	$00000000,	(PITCH1|PIXEL32|WID24|XADDPHR)
	dc.l		geyser00,	geyser06+(48*227*2),$00100018,	$0001FFE8,	$0001FFE8,	$00000000,	(PITCH1|PIXEL32|WID24|XADDPHR)
	dc.l		0

adblktbl::						;start, end addresses for adjblack after loading enemies
	dc.l	bigrok00,	cube00+(48*664*2)
	dc.l	trat00,	tratshot
	dc.l	bigrok00,	cube00+(48*664*2)
	dc.l	bat00,	cvrock04+(48*80*2)
	dc.l	bigrok00,	cube00+(48*664*2)
	dc.l	spin00,	blocks01+(128*72*2)
	dc.l	bigrok00,	cube00+(48*664*2)
	dc.l	spore0,	tree0+(160*288*2)
	dc.l	bigrok00,	cube00+(48*664*2)
	dc.l	fishtx00,	fishtxsh
	dc.l	0

tile_q::						;addresses of compression quality tables
	dc.l		q85,q65
	dc.l		q85,q65
	dc.l		q85,q65
	dc.l		q85,q65
	dc.l		q85,q65
	dc.l		q65
bk_ypos::
	dc.w		SCRN_TOP-64,SCRN_TOP-64
	dc.w		SCRN_TOP-64,SCRN_TOP-60
	dc.w		SCRN_TOP-64,SCRN_TOP-64
	dc.w		SCRN_TOP-64,SCRN_TOP-64
	dc.w		SCRN_TOP-64,SCRN_TOP-96
	dc.w		SCRN_TOP-64
max_gtbl::					;highest enemy number that can be used as a ground enemy for each level
	dc.b		0,7
	dc.b		0,6
	dc.b		0,5
	dc.b		0,3
	dc.b		0,5
	dc.b		9
	.even

frontcol::
	dc.b		0,0
	dc.b		0,1
	dc.b		0,0
	dc.b		0,0
	dc.b		0,0
	dc.b		1
	.even
elisttbl::
;enemy list to use for each level
	dc.l		elistsp0,elistds
	dc.l		elistsp1,elistcv
	dc.l		elistsp2,elistair
	dc.l		elistsp3,elistsw
	dc.l		elistsp4,elistcty
	dc.l		0
glisttbl::
;ground object list to use for each level
	dc.l		0,glistds
	dc.l		0,glistcv
	dc.l		0,glistair
	dc.l		0,glistsw
	dc.l		0,glistcty
	dc.l		glistbon
flisttbl::
;foreground object list to use for each level
	dc.l		0,flistds
	dc.l		0,flistcv
	dc.l		0,0
	dc.l		0,flistsw
	dc.l		0,flistcty
	dc.l		0
frinftbl::
	dc.l		0,frinfds
	dc.l		0,frinfcv
	dc.l		0,0
	dc.l		0,frinfsw
	dc.l		0,frinfcty
	dc.l		frinfbon
tlisttbl::
;tile list to use for each level
	dc.l		tlistsp0,tlistds
	dc.l		tlistsp1,tlistcv
	dc.l		tlistsp2,tlistair
	dc.l		tlistsp3,tlistsw
	dc.l		tlistsp4,tlistcty
	dc.l		tlistbn

til_tbl::
;list of background tiles to use for each level
	dc.l		til_spc,til_des
	dc.l		til_spc,til_cv
	dc.l		til_spc,til_air
	dc.l		til_spc,til_sw
	dc.l		til_spc,til_cty
	dc.l		til_bon
;data for background tiles
;need a 0 at the end of each table
til_sw::
	dc.l		sw00,sw01,sw02,sw03,sw04,sw05,sw06,sw07
	dc.l		sw08,sw09,sw10,sw11,sw12,sw13,sw14,sw15
	dc.l		0
til_des::
	dc.l		des00,des01,des02,des03,des04,des05,des06,des07
	dc.l		des08,des09,des10,des11,des12,des13,des14,des15
	dc.l		0
til_air::
	dc.l		air00,air01,air02,air03,air04,air05,air06,air07
	dc.l		air08,air09,air10,air11,air12,air13,air14,air15
	dc.l		0
til_cv::
	dc.l		cv0,cv1,cv2,cv3,cv4,cv5,cv6,cv7
	dc.l		0
til_cty::
	dc.l		cty00,cty01,cty02,cty03,cty04,cty05,cty06,cty07
	dc.l		cty08,cty09,cty10,cty11,cty12,cty13,cty14,cty15
	dc.l		cty16,cty17,cty18,cty19,cty20						;cty21 gets loaded at end of level
	dc.l		0
til_spc::
	dc.l		s00,s01,s02,s03,s04,s05,s06,s07
	dc.l		s08,s09,s10,s11,s12,s13
	dc.l		0
til_bon::
	dc.l		bon00,bon01
	dc.l		0

statypos::
	dc.w		0,SCRN_BOTTOM-240
	dc.w		0,SCRN_BOTTOM-300
	dc.w		0,SCRN_BOTTOM-220
	dc.w		0,SCRN_BOTTOM-220
	dc.w		0,SCRN_BOTTOM-190
	dc.w		0
scoreclr::
	dc.l		scrclr0,scrclr0
	dc.l		scrclr0,scrclr1
	dc.l		scrclr0,scrclr1
	dc.l		scrclr0,scrclr0
	dc.l		scrclr0,scrclr0
	dc.l		scrclr0
;put these colors in the palette starting at color $B8
scrclr0::
	dc.w	$07D4,$07D8,$07DA,$07DD,$07E1,$37EA,$577B,$FFC0			;blue
scrclr1::
	dc.w	$F83F,$F83F,$F83F,$F83F,$F83F,$F83F,$F83F,$FFC0			;yellow

forms::
;addresses of lists of formations to create for each level
	dc.l		0,formsds
	dc.l		0,0
	dc.l		0,0
	dc.l		0,0
	dc.l		0,0
	dc.l		0

formtbl::
;addresses of info to create each type of formation
;tables at these addresses have enemy type, X, Y positions
	dc.l		form00in,form01in,form02in,form03in,form04in,form05in,form06in,form07in
	dc.l		form08in,form09in

;$8000 must end each table
;enemy type, X position, Y position, direction, speed
form00in::
	dc.w		TURBORAT,	SCRN_RIGHT,	240,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+42,	176,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+42,	304,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+84,	112,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+84,	368,		12,		1
	dc.w		$8000
form01in::
	dc.w		TURBORAT,	SCRN_RIGHT,	250,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+42,	186,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+42,	314,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+84,	122,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+84,	368,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+126, 68,		12,		1
	dc.w		TURBORAT,	SCRN_RIGHT+126,422,		12,		1
	dc.w		$8000
form02in::
	dc.w		FBUG,	SCRN_RIGHT,	220,		12,		2
	dc.w		FBUG,	SCRN_RIGHT+42,	166,		12,		2
	dc.w		FBUG,	SCRN_RIGHT+42,	294,		12,		2
	dc.w		FBUG,	SCRN_RIGHT+84,	102,		12,		2
	dc.w		FBUG,	SCRN_RIGHT+84,	348,		12,		2
	dc.w		$8000
form03in::
	dc.w		FBUG,	SCRN_RIGHT,	220,		12,		1
	dc.w		FBUG,	SCRN_RIGHT,	220,		13,		3
	dc.w		FBUG,	SCRN_RIGHT,	220,		11,		3
	dc.w		FBUG,	SCRN_RIGHT,	220,		14,		2
	dc.w		FBUG,	SCRN_RIGHT,	220,		10,		2
	dc.w		FBUG,	SCRN_RIGHT,	220,		15,		1
	dc.w		FBUG,	SCRN_RIGHT,	220,		 9,		1
	dc.w		$8000
form04in::
	dc.w		TURBORAT,	SCRN_RIGHT+10,	260,		12,		2
	dc.w		TURBORAT,	SCRN_RIGHT,	210,		11,		3
	dc.w		TURBORAT,	SCRN_RIGHT+10,	310,		13,		2
	dc.w		TURBORAT,	SCRN_RIGHT,	160,		10,		1
	dc.w		TURBORAT,	SCRN_RIGHT,	360,		14,		1
	dc.w		$8000
form05in::
	dc.w		TURBORAT,	SCRN_RIGHT,	270,		12,		2
	dc.w		TURBORAT,	SCRN_RIGHT,	200,		 4,		1
	dc.w		TURBORAT,	SCRN_RIGHT,	340,		 4,		1
	dc.w		TURBORAT,	SCRN_RIGHT,	120,		12,		2
	dc.w		TURBORAT,	SCRN_RIGHT,	400,		12,		2
	dc.w		$8000
form06in::
	dc.w		VULT,	SCRN_RIGHT,	250,		12,		1
	dc.w		VULT,	SCRN_RIGHT+40,	150,		12,		1
	dc.w		VULT,	SCRN_RIGHT+40,	350,		12,		1
	dc.w		VULT,	SCRN_RIGHT+80,	250,		12,		1
	dc.w		$8000
form07in::
	dc.w		VULT,	410,			 60,		12,		1
	dc.w		VULT,	420,			110,		13,		1
	dc.w		VULT,	430,			160,		11,		1
	dc.w		VULT,	440,			230,		12,		1
	dc.w		VULT,	430,			310,		13,		1
	dc.w		VULT,	420,			370,		11,		1
	dc.w		VULT,	410,			430,		12,		1
	dc.w		$8000
form08in::
	dc.w		FBUG,	SCRN_RIGHT,	250,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+70,	250,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+140,250,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+210,250,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+50,	150,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+50,	350,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+120, 60,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+120,440,		12,		1
	dc.w		$8000
form09in::
	dc.w		FBUG,	SCRN_RIGHT,	250,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+30,	200,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+30,	300,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+90,	250,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+90,	150,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+210,350,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+160,100,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+160,200,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+160,300,		12,		1
	dc.w		FBUG,	SCRN_RIGHT+160,400,		12,		1
	dc.w		$8000


palette::
;$AE - $AF for flash
;$D0 - $D4 bombs
;$B8 - $BF score numbers
;$EF scrcover
;$F0 - $FF for powerup color cycling
	dc.w	$0000,$04D3,$FE7F,$ED79,$DCB3,$C3ED,$B326,$A260,$89DA,$68CE,$FFC0,$FDFE,$FD3C,$FB78,$FA75,$F9B1
	dc.w	$F8AD,$E01F,$C81A,$A814,$904F,$784B,$FFC0,$EFBA,$E7FB,$BFB4,$972C,$76E5,$569F,$3E18,$25D1,$0D8B
	dc.w	$04C8,$0446,$0384,$01C0,$FFC0,$DF36,$CEB2,$BE2E,$ADAA,$9D26,$8CA2,$7C1E,$18C7,$0000,$FFC0,$FEB9
	dc.w	$F5B1,$E362,$DA59,$D191,$C888,$C800,$B000,$9800,$8000,$6800,$5000,$2000,$FFC0,$9CBA,$62F2,$522D
	dc.w	$3969,$2062,$1019,$0815,$0011,$000D,$4854,$4052,$5096,$304E,$3850,$D9A3,$D157,$E1F0,$F9BF,$D013
	dc.w	$F77C,$EEB7,$DDB2,$D4ED,$C428,$BBA3,$AADF,$A25B,$91D7,$71E0,$7963,$91A8,$9A2C,$AAF0,$CBB7,$D819
	dc.w	$50DB,$3854,$3011,$180B,$FFFC,$DEA8,$F819,$F015,$E811,$D80A,$C807,$FC3F,$DA6C,$D1E6,$C15F,$B8D8
	dc.w	$07C0,$FFFF,$FFC0,$F839,$F834,$F82E,$F829,$F823,$F81E,$E00D,$784B,$9009,$B012,$F9EC,$FC3F,$FFC0
	dc.w	$AD6A,$5295,$D6B4,$B5AD,$9CE6,$8C63,$7BDF,$739C,$6319,$4A52,$39CE,$294B,$2108,$F829,$F824,$FFC0
	dc.w	$FFC0,$FFC0,$F806,$7800,$4800,$3000,$FD3F,$FB76,$FA6D,$F924,$D81B,$B012,$9009,$6800,$FEBF,$FC7C
	dc.w	$FBB8,$FAB2,$F9EC,$F0DC,$E094,$D84D,$D006,$C800,$B000,$A000,$9000,$1084,$FFFF,$FFC0,$F83E,$FFFF
	dc.w	$3396,$328F,$318A,$1906,$4BD8,$07E6,$07EA,$FFC0,$07D4,$07D8,$07DA,$07DD,$07E1,$37EA,$577B,$FFC0
	dc.w	$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFFF,$D6B4,$FFC0
	dc.w	$F810,$E80C,$E009,$D005,$C803,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$37EA,$577B
	dc.w	$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$FFC0,$0000
	dc.w	$07FF,$07F8,$07F2,$07EC,$07E6,$07E0,$07DA,$07D4,$07D8,$07DD,$07E1,$07E6,$07EA,$07EF,$07F3,$07F8


;OBJECT HEADERS
gameolst::
;bkground
	dc.b		0			;type
	dc.b		4			;depth
	dc.w		0			;xpos	
	dc.w		SCRN_TOP		;ypos
	dc.w		TILE_HEIGHT	;height
	dc.w		128			;dwidth
	dc.w		128			;iwidth
	dc.l		screen		;data
	dc.b		0			;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;station
	dc.b		0			;type
	dc.b		4			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		104			;height
	dc.w		48			;dwidth
	dc.w		48			;iwidth
	dc.l		station0		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;station flag
	dc.b		0			;type
	dc.b		4			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		56			;height
	dc.w		12			;dwidth
	dc.w		12			;iwidth
	dc.l		statflg0		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;enemy0::
;(byte)type, (byte)depth, X, Y, height, dwidth, iwidth, (long)data, (byte)flags, (byte)firstpix, (byte)pitch, (byte)index, (long)desc, (long)scaling
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy0
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy1
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy2
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy3
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy4
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy5
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy6
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy7
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy8
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,$20,$20,$20	;enemy9
;powerup::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			;height
	dc.w		2			;dwidth
	dc.w		2			;iwidth
	dc.l		pwrupdata		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;cutter::
	dc.b		0			;type
	dc.b		4			;depth
	dc.w		100			;xpos	
	dc.w		200			;ypos
	dc.w		24			;height
	dc.w		16			;dwidth
	dc.w		14			;iwidth
	dc.l		cutrdata		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;cutshot0::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		7			;height
	dc.w		1			;dwidth
	dc.w		1			;iwidth
	dc.l		bulletl1		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;cutshot1::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		7			;height
	dc.w		1			;dwidth
	dc.w		1			;iwidth
	dc.l		bulletl1		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;cutshot2::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		7			;height
	dc.w		1			;dwidth
	dc.w		1			;iwidth
	dc.l		bulletl1		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;cutshot3::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		7			;height
	dc.w		1			;dwidth
	dc.w		1			;iwidth
	dc.l		bulletl1		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;player::
	dc.b		0			;type
	dc.b		PLR_DEPTH		;depth
	dc.w		PLR_XPOS		;xpos	
	dc.w		PLR_YPOS		;ypos
	dc.w		PLR_OHEIGHT	;height
	dc.w		PLR_DWIDTH	;dwidth
	dc.w		PLR_IWIDTH	;iwidth
	dc.l		player00		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;(byte)type, (byte)depth, X, Y, height, dwidth, iwidth, (long)data, (byte)flags, (byte)firstpix, (byte)pitch, (byte)index, (long)desc, (long)scaling
	dc.b		0,3,0,0,0,0,0,0,0,1,0,1,0,0,0,0,TRANS_ON,0,1,$38,0,0,0,0,0,$20,$20,$20	;bullet0
	dc.b		0,3,0,0,0,0,0,0,0,1,0,1,0,0,0,0,TRANS_ON,0,1,$38,0,0,0,0,0,$20,$20,$20	;bullet1
	dc.b		0,3,0,0,0,0,0,0,0,1,0,1,0,0,0,0,TRANS_ON,0,1,$38,0,0,0,0,0,$20,$20,$20	;bullet2
	dc.b		0,3,0,0,0,0,0,0,0,1,0,1,0,0,0,0,TRANS_ON,0,1,$38,0,0,0,0,0,$20,$20,$20	;bullet3
	dc.b		0,3,0,0,0,0,0,0,0,1,0,1,0,0,0,0,TRANS_ON,0,1,$38,0,0,0,0,0,$20,$20,$20	;bullet4
	dc.b		0,3,0,0,0,0,0,0,0,1,0,1,0,0,0,0,TRANS_ON,0,1,$38,0,0,0,0,0,$20,$20,$20	;bullet5
	dc.b		0,3,0,0,0,0,0,0,0,1,0,1,0,0,0,0,TRANS_ON,0,1,$38,0,0,0,0,0,$20,$20,$20	;bullet6
	dc.b		0,3,0,0,0,0,0,0,0,1,0,1,0,0,0,0,TRANS_ON,0,1,$38,0,0,0,0,0,$20,$20,$20	;bullet7
;---------------------------------------------------------------------
;(byte)type, (byte)depth, X, Y, height, dwidth, iwidth, (long)data, (byte)flags, (byte)firstpix, (byte)pitch, (byte)index, (long)desc, (long)scaling
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;en_shot0
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;en_shot1
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;en_shot2
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;en_shot3
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;en_shot4
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;en_shot5
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;en_shot6
	dc.b		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;en_shot7
;---------------------------------------------------------------------
;bomb::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		13			;height
	dc.w		2			;dwidth
	dc.w		2			;iwidth
	dc.l		bombdata		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;specweap::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		13			;height
	dc.w		4			;dwidth
	dc.w		4			;iwidth
	dc.l		specdata		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;(byte)type, (byte)depth, X, Y, height, dwidth, iwidth, (long)data, (byte)flags, (byte)firstpix, (byte)pitch, (byte)index, (long)desc, (long)scaling
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front0
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front1
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front2
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front3
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front4
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front5
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front6
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front7
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front8
	dc.b		0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,TRANS_ON,0,1,0,0,0,0,0,0,$20,$20,$20	;front9
;---------------------------------------------------------------------
;iconbox::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		ICON_XPOS		;xpos	
	dc.w		ICON_YPOS		;ypos
	dc.w		15			;height
	dc.w		10			;dwidth
	dc.w		10			;iwidth
	dc.l		iconbar		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;scorebox::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		SCORE_XPOS	;xpos	
	dc.w		SCORE_YPOS	;ypos
	dc.w		12			;height
	dc.w		10			;dwidth
	dc.w		10			;iwidth
	dc.l		scorebar		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;specflsh::
	dc.b		0			;type
	dc.b		0			;depth
	dc.w		0			;xpos	
	dc.w		SCRN_TOP		;ypos
	dc.w		288			;height
	dc.w		1			;dwidth
	dc.w		7			;iwidth	repeat same phrase of data 7 times
	dc.l		specdata		;data
	dc.b		0			;flags
	dc.b		0			;firstpix
	dc.b		0			;pitch	repeat same phrase of data 7 times
	dc.b		87			;index  use colors $AE,$AF
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;message::
	dc.b		0			;type
	dc.b		3			;depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		0			;height
	dc.w		0			;dwidth
	dc.w		0			;iwidth
	dc.l		msgdata		;data
	dc.b		TRANS_ON		;flags
	dc.b		0			;firstpix
	dc.b		1			;pitch
	dc.b		0			;index
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------

scrcov::
	dc.b		0			;type
	dc.b		0			;depth
	dc.w		0			;xpos	
	dc.w		SCRN_TOP		;ypos
	dc.w		288			;height
	dc.w		1			;dwidth
	dc.w		7			;iwidth
	dc.l		specdata		;data
	dc.b		0			;flags
	dc.b		0			;firstpix
	dc.b		0			;pitch	repeat same phrase of data 7 times
	dc.b		119			;index  use colors $EE,$EF
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------

